#!/bin/sh
CUPSD=/usr/syno/sbin/cupsd
CUPSD_LPADMIN=/usr/syno/bin/lpadmin
CUPSD_LPSTAT=/usr/syno/bin/lpstat
CUPSD_ENABLE=/usr/syno/bin/cupsenable
CUPSD_DISABLE=/usr/syno/bin/cupsdisable
CUPSD_CONF=/usr/local/cups/cupsd.conf
GET_SECTION_KEY_VALUE=/usr/syno/bin/get_section_key_value
DEBUG_LOG="/var/log/cups/cups"
DEBUG_LEVEL=0
DEBUG_ENV=""
PRINTER_PREFIX="usbprinter"
DRIVER_HOST="`/bin/get_key_value /etc.defaults/synoinfo.conf printer_driver_host`"
RSS_URL="`/bin/get_key_value /etc.defaults/synoinfo.conf rss_server`?dlSite=syno&tz="
PLATFORM=`/bin/get_key_value /etc.defaults/synoinfo.conf unique|cut -d '_' -f2`
DRIVER_LIST="_list_"
TMPFLD="/tmp/_airprint"
PRINTER_NAME=""
PPD_PATH="/usr/local/cups/ppd/"
LOGGER="/usr/bin/logger"
WGET="/usr/syno/bin/wget"
SERVICETOOL="/usr/syno/bin/servicetool"
SwapScript="/usr/syno/bin/swapaction"
USE_OTHER_WEB=0
MAX_PRINTERS=`/bin/get_key_value /etc.defaults/synoinfo.conf maxprinters`

MAXDISKS=`/bin/get_key_value /etc.defaults/synoinfo.conf maxdisks`
if [ ${MAXDISKS} -eq 0 ]; then
	DISKLESS="yes"
fi


log_msg()
{
	$LOGGER -sp $1 -t CUPS "$2"
}

make_spool_ready()
{
	Volume=`${SERVICETOOL} --get-service-path printer`
	ServiceOnVolume=$?
	if [ $ServiceOnVolume -eq 0 ] ; then
		Volume=`${SERVICETOOL} --get-alive-volume`
		FoundVolume=$?
		if [ $FoundVolume -eq 0 ] ; then
			log_msg info "Never Start CUPS until volume exist..."
			exit 1
		fi
		if [ ! -d /var/services ]; then
			rm -f /var/services
			mkdir /var/services
			chmod 755 /var/services
		fi
		rm -rf /var/services/printer
		ln -sf ${Volume}/@spool /var/services/printer
	fi

	SPOOL="${Volume}/@spool"
	/bin/rm -rf $SPOOL/cache
	/bin/mkdir -p $SPOOL/cache
	/bin/mkdir -p $SPOOL/tmp
	/bin/chmod -R 777 $SPOOL
}

check_lp_device()
{
	for i in `seq 0 $(( $MAX_PRINTERS - 1 ))`; do
		local lp_grp=`ls -l /dev/usb/lp$i| awk '{print $4}'`
		if [ "$lp_grp" != "lp" ]; then
			log_msg err "Fix /dev/usb/lp$i group: [$lp_grp] -> [lp]"
			chgrp lp /dev/usb/lp$i
		fi

		local lp_mod=`stat /dev//usb/lp$i| grep Uid| awk 'BEGIN {FS="[()/]" } ; {print $2}'`
		if [ "$lp_mod" -lt 660 ]; then
			log_msg err "Fix /dev/usb/lp$i permission: [$lp_mod] -> [660]"
			chmod 660 /dev/usb/lp$i
		fi
	done
}

start_cups()
{
	CLEAN_LOG="n"
	# skip the first argument
	shift 1
	while getopts "cd:" opt $@; do
		case "$opt" in
			"d")
				# check OPTARG is a valid number
				if [ $OPTARG -eq $OPTARG ]; then
					DEBUG_LEVEL=$OPTARG
				fi
				DEBUG_ENV="CUPS_DEBUG_LOG=${DEBUG_LOG} CUPS_DEBUG_LEVEL=${DEBUG_LEVEL}"
				log_msg info "Enable ${DEBUG_ENV}"
				;;
			"c")
				CLEAN_LOG="y"
				;;
		esac
	done
	check_lp_device
	if [ ! -x "$CUPSD" ]; then
		log_msg err "Fail to find $CUPSD, or not executable !"
		exit 1
	fi
	if [ "$CLEAN_LOG" = "y" ]; then
		/bin/rm -rf /var/log/cups
	fi
	if /bin/pidof cupsd >/dev/null; then
		log_msg info "Hup cupsd..."
		/usr/bin/killall -HUP  cupsd
	else
		log_msg info "Starting cupsd..."
		make_spool_ready
		if [ ! -z "$DEBUG_ENV" ]; then
			test -d /var/log/cups || /bin/mkdir -p /var/log/cups
		fi
		/usr/bin/env ${DEBUG_ENV} $CUPSD -c $CUPSD_CONF
	fi
	# clean cups-lpd suppress log flag
	rm -f /tmp/CUPS_LPD_SUPPRESS_LOG 2>/dev/null
}

stop_cups()
{
	PID=`pidof cupsd`
	if [ $? -eq 0 ]; then
		log_msg info "Stopping cupsd..."
		/bin/kill $PID
	else
		log_msg info "cupsd is not running. stop nothing."
	fi
}

get_loadbalance_host()
{
	if [ -z "$DRIVER_HOST" ]; then
		log_msg err "Fail to get printer_driver_host from /etc.defaults/synoinfo.conf !"
		exit 1
	fi
	TZ="`/bin/get_key_value /etc/synoinfo.conf timezone`"
	LB_HOST="`/usr/syno/bin/curl ${RSS_URL}${TZ}`"

	if [ "$USE_OTHER_WEB" -eq 0 ] && [ "${LB_HOST:0:7}" == "http://" ]; then
		DRIVER_HOST="`/bin/echo $DRIVER_HOST| /bin/sed \"s;http://[^/]*;$LB_HOST;\"`"
	fi
	log_msg info "Using server: $DRIVER_HOST"
}


case $1 in
get_driver_list)
	TMPFILE="${TMPFLD}/${DRIVER_LIST}"
	/bin/mkdir -p ${TMPFLD}
	get_loadbalance_host
	if ! $WGET ${DRIVER_HOST}/${DRIVER_LIST} -O ${TMPFILE}; then
		exit 1
	fi
	;;
uninstall)
	ID=$2
	PRINTER_NAME=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID cups\ printer\ name`

	PPD=$PPD_PATH/$ID.ppd
	test -f $PPD && rm -f $PPD
	if ! /bin/pidof cupsd >/dev/null; then
		start_cups
	fi
	$CUPSD_LPADMIN -x $PRINTER_NAME
	if [ "$DISKLESS" = "yes" ]; then
		$SwapScript off
	fi
	HOSTNAME=`hostname`
	$CUPSD_LPADMIN -p $PRINTER_NAME -E -L "$HOSTNAME" -v usb:/dev/usb/$2
	$CUPSD_DISABLE $PRINTER_NAME
	;;
uninstall_np)
	ID=$2
	PRINTER_NAME=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID cups\ printer\ name`
	IP=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID IP`
	Protocol=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID Backend`
	QName=`$GET_SECTION_KEY_VALUE /usr/syno/etc/printer.conf $ID QName`

	if [ "$Protocol" = "lpd" -o "$Protocol" = "ipp" ] && [ "$QName" != "" ]; then
		Device_URI="$Protocol://$IP/$QName"
	else
		Device_URI="$Protocol://$IP/"
	fi

	PPD=$PPD_PATH/$ID.ppd
	test -f $PPD && rm -f $PPD
	if ! /bin/pidof cupsd >/dev/null; then
		start_cups
	fi
	$CUPSD_LPADMIN -x $PRINTER_NAME
	if [ "$DISKLESS" = "yes" ]; then
		$SwapScript off
	fi
	HOSTNAME=`hostname`
	$CUPSD_LPADMIN -p $PRINTER_NAME -E -L "$HOSTNAME" -v $Device_URI
	$CUPSD_DISABLE $PRINTER_NAME
	;;
install)
	# lp0 /ppd/xxxxxx.ppd.tgz
	TMPFILE="$TMPFLD/driver.tgz"
	get_loadbalance_host
	URL="${DRIVER_HOST}/$3"
	/bin/mkdir -p $TMPFLD
	if ! $WGET "$URL" -O ${TMPFILE}; then
		exit 1
	fi
	if ! /bin/tar zxvf $TMPFILE -C $TMPFLD/; then
		/bin/rm -f $TMPFILE
		exit 1
	fi
	/bin/rm -f $TMPFILE
	/bin/sh $TMPFLD/install.sh "$2" "$DRIVER_HOST" &
	;;
add)
	if [ -z "$2" ]; then
		log_msg err "Need to specify a devicce node name: /dev/usb/deviceNodeName"
		exit 1;
	fi

	if ! /bin/pidof cupsd >/dev/null; then
		start_cups
	fi

	if [ -z "$3" ]; then
		log_msg err "Need to specify PPD file, printer=$2"
		exit 1;
	fi

	/usr/syno/bin/synoprint --ppd $2 $3
	if [ $? -eq 0 ]; then
	    exit 0;
	else
	    log_msg err "synoprint add cups ppd printer failed, $2"
	    exit 1;
	fi

	;;
start | "" | reload)
	start_cups $@
	;;
stop)
	stop_cups
	;;
restart)
	stop_cups
	/bin/sleep 1
	start_cups $@
	;;
*)
	/bin/echo "usage: $0 { start | stop | restart | reload | add | rm }" >&2
	/bin/echo "[add | rm] should specify a devie name [lpX]" >&2
	exit 1
	;;
esac
# the return value should be 0 if operation success without a hitch
