var langId = {
	title_quota_usage:		[ 'report',  'report_quota_usage'],
	title_file_owner:		[ 'report',  'report_file_owner'],
	title_volume_usage :	[ 'report',  'report_volume_usage'],
	title_share_list:		[ 'report',  'report_share_list'],
	title_file_group:		[ 'report',  'report_file_group'],
	title_duplicate_file:	[ 'report',  'report_duplicate_file'],
	title_duplicate_list:	[ 'report',  'reportUI_duplicate_list'],
	title_large_file:		[ 'report',  'report_large_file'],
	title_least_modify:		[ 'report',  'report_lrm'],
	title_most_modify:		[ 'report',  'report_mrm'],
	storage_report:			[ 'report',  'reportUI_report_name'],
	download_csv1:			[ 'report',  'reportUI_download_csv' ],
	download_csv2:			[ 'report',  'reportUI_download_csv' ],
	download_csv3:			[ 'report',  'reportUI_download_csv' ],
	download_csv4:			[ 'report',  'reportUI_download_csv' ],
	download_csv5:			[ 'report',  'reportUI_download_csv' ],
	title_name_time:		[ 'report',  'reportUI_title_name_time' ],
	sample_quota_usage1:	[ 'report',  'reportUI_title_free' ],
	sample_quota_usage2:	[ 'report',  'reportUI_title_used' ]
};

function _T(g, s)
{
	try {
		return SYNO_WebManager_Strings[g][s];
	} catch(e) {
		return '';
	}
}

function SetNameTime()
{
	var com = Ext.get('value_name_time');

	try {
		com.update(synoHostName + '<BR>' + synoCreateTime);
	} catch(e) {
	}
}

function langReplace()
{
	var com, item;

	SetNameTime();

	for(item in langId) {
		com = Ext.get(item);
		try {
			com.update(_T(langId[item][0], langId[item][1]));
		} catch(e) {
		}
	}

	if(synoDuplicateHashMatch === 1) {
		com = Ext.get('title_duplicate_file');
		try {
			com.update(_T(langId['title_duplicate_list'][0], langId['title_duplicate_list'][1]));
		} catch(e) {
		}
	}

}

function NoDataSet(myDiv)
{
	var container = Ext.fly(myDiv);
	var html = '<div align="center" style="width:930px; font-size: 23px;">' + _T('photo_viewer','no_data') + '</div>';

	if(container) {
		container.update(html);
	}
}

function pickColor(hash, key, i, total)
{
	var defaultColor = [ '#0067bb', '#10b6e6', '#db430c', '#ff8e27', '#ffd440', '#aec900', '#019d3b', '#7f39e8', '#a7855e' ];
	if (defaultColor[i]) {
		hash[key] = defaultColor[i];
		return hash[key];
	}

	var r=255, g=255, b=255;
	var totalPickingColor = total - defaultColor.length;
	var index = parseInt((255+255+255) / (totalPickingColor + 1), 10);

	i = i - defaultColor.length;

	r -= (i+1) * index;
	if( r < 0) {
		g -= 0 - r;
		r = 0;
    }
	if( g < 0) {
		b -= 0 - g;
		g = 0;
    }
	if( r < 0x10) {
		r = '0' + r.toString(16);
	} else {
		r = r.toString(16);
	}

	if( g < 0x10) {
		g = '0' + g.toString(16);
	}  else {
		g = g.toString(16);
	}

	if( b < 0x10) {
		b = '0' + b.toString(16);
	}  else {
		b = b.toString(16);
	}

	if(i % 3 === 0) {
		hash[key] = '#' + r + g + b;
	} else if(i % 3 === 1) {
		hash[key] = '#' + g + b + r;
	} else if(i % 3 === 2) {
		hash[key] = '#' + b + r + g;
	}
	return hash[key];
}

function pickRandomColor(hash, key, i, total)
{
    var r=255, g=255, b=255;
	var index = parseInt((255+255+255) / (total + 1), 10);

	r -= (i+1) * index;
    if( r < 0) {
		g -= 0 - r;
		r = 0;
    }
    if( g < 0) {
		b -= 0 - g;
		g = 0;
    }
	if( r < 0x10) {
		r = '0' + r.toString(16);
	}  else {
		r = r.toString(16);
	}

	if( g < 0x10) {
		g = '0' + g.toString(16);
	}  else {
		g = g.toString(16);
	}

	if( b < 0x10) {
		b = '0' + b.toString(16);
	}  else {
		b = b.toString(16);
	}

	if(i % 3 === 0) {
		hash[key] = '#' + r + g + b;
	} else if(i % 3 === 1) {
		hash[key] = '#' + g + b + r;
	} else if(i % 3 === 2) {
		hash[key] = '#' + b + r + g;
	}
    return hash[key];
}

function DayToFull(val, cellmeta, rec)
{
	var tmp = _T('report', 'reportUI_cannot_estimate');
	if(val <= 0) {
		cellmeta.attr = 'ext:qtip="' + tmp + '"; ext:qwidth=auto';
		return tmp;
	}
	cellmeta.attr = 'ext:qtip="' + val + '"; ext:qwidth=auto';
	return val;
}

function SizePercent(val)
{
	var a = val.split('%');
	//return new Number(a[0]).toFixed(1) + '%';
	return (1 * a[0]).toFixed(1) + '%';
}

function SizeUnit(val)
{
    var rv = '';
    var i=0;
    for(i=0; i<4; i++) {
        if(val > 1024) {
            val = val/1024;
        } else {
            break;
        }
    }

	if(i > 0) {
		val = val.toFixed(1);
	} else {
		val = parseInt(val, 10);
	}

    if( i == 0) {
        rv = val + ' ' + _T('common','size_byte');
    } else if( i == 1) {
        rv = val + ' ' + _T('common','size_kb');
    } else if( i == 2) {
		rv = val + ' ' + _T('common','size_mb');
    } else if( i == 3) {
        rv = val + ' ' + _T('common','size_gb');
    } else if( i == 4) {
        rv = val + ' ' + _T('common','size_tb');
    }
    return rv;
}

function VolumeId2Name(volume)
{
	var tmp, ret='-';
	if(volume !== '') {
		tmp	= volume.split('_');
		num = tmp[1];
		ret = String.format("{0} {1}", _T('volume', 'volume'), num);
	}

	return ret;
}

GridViewConfig = {
    autoFill: true,
    forceFit: true,
    onLayout: function() {
	var els = this.el.select('.x-grid3-scroller', this);
	var scroller = els.elements[0];

	if (scroller.clientWidth === scroller.offsetWidth) {
	    // no scroller
	    this.scrollOffset = 2;
	} else {
	    this.scrollOffset = undefined;
	}
	this.fitColumns(false);
    }
};

GridPanelPlugin = Ext.extend(Ext.Component, {
    constructor: function(limit) {
	this.limit = limit > 1 ? limit : 14;
    },
    init: function(gridpanel) {
	var me = this;
	Ext.apply(gridpanel, {
	    updateScrollbar: me.updateScrollbar
	});

	gridpanel.mon(gridpanel, 'afterrender', function(gridpanel) {
	    var count = gridpanel.getStore().getCount();

	    if (count < 1) {
		    count = 1;
	    } else if (count > this.limit) {
		    count = this.limit;
	    }

	    gridpanel.setHeight(35 + (count * 30));

		gridpanel.updateScrollbar(gridpanel.getView().scroller.dom);
	}, this, {buffer: 500});
	gridpanel.mon(gridpanel, 'resize', function(gridpanel) {
	    gridpanel.updateScrollbar(gridpanel.getView().scroller.dom);
	}, this, {buffer: 500});
    },
    updateScrollbar: function(dom) {
	if (dom && dom.fleXcroll) {
	    dom.fleXcroll.updateScrollBars();
	} else if (dom) {
	    fleXenv.fleXcrollMain(dom);
	}
    }
});

function onOpenFile(file)
{
	if(!Ext.isDefined(synoWebIp) || !Ext.isDefined(synoWebPort)) {
		return;
	}

	var url = 'http://' + synoWebIp + ':' + synoWebPort + '/webman/index.cgi?launchApp=SYNO.SDS.App.FileStation3.Instance&';
	var keyEncode;
	var fileNewPath = '';
	var value = '';

	for(var key in synoSharePathHash) {
		keyEncode = key.replace(/\//g, '\\/');
		if(file.search(keyEncode + "\/") !== -1) {
			value = synoSharePathHash[key];
			fileNewPath = file.replace(key, "/" + value);
			break;
		}
	}

	var param = { openfile: fileNewPath };
	var lparam =  Ext.urlEncode({ launchParam: Ext.urlEncode(param) });

	url += lparam;

	window.open(url, "synoreport_filestation");
}

function htmlEncodeRenderer(val, cellmeta, rec) {
	var tmp = Ext.util.Format.htmlEncode(val);
	var link = tmp;
	if(typeof(synoSharePathHash) !== 'undefined') {
		link = '<a href="javascript:onOpenFile(\'' + val + '\'); return false;">' + tmp + '</a>';
	}
	cellmeta.attr = 'ext:qtip="' + tmp + '"; ext:qwidth=auto';
	return link;
}

function styleRenderer(val, cellmeta, rec) {
	var format = '<div class = "x-grid3-first-column">{0}</div>';
	return String.format(format, val);
}

function styleRendererDecorator(func) {
	var renderer = function(val, cellmeta, rec) {
		val = func(val, cellmeta, rec);
		return styleRenderer(val, cellmeta, rec);
	};
	return renderer;
}

function styleHeaderRenderer(val) {
	return styleRenderer(val);
}


Ext.onReady(langReplace);
