#!/bin/sh

###############################################################
#   This script should be hooked when invoking SLIBNetService()
#   Usable environment variable:
#       PATH, SERVICE_IP_CHANGE, SERVICE_HOSTNAME_CHANGE, SERVICE_MTU_CHANGE,
#       SERVICE_DAEMON_ACTION, RESULT
###############################################################


SYNO_SNMPD_INC_SCRP=/usr/libexec/SNMPDCommon.sh
SYNO_SERVICE_INC_SCRP=/usr/libexec/ServiceCommon.sh
. ${SYNO_SNMPD_INC_SCRP}
. ${SYNO_SERVICE_INC_SCRP}

#At begining, acquire package settings
case $1 in
    --sdk-mod-ver)
		#Print SDK support version
		#
        echo ${SYNO_SNMPD_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYNO_SNMPD_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYNO_SNMPD_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYNO_SNMPD_VENDOR};
    ;;
    --pre)
        #Actions before net service action
    ;;
    --post)
        #Actions after net service action

		#Other action, IP_CHANGE and others, doesn't include here.
		if [ ${SERVICE_DAEMON_ACTION} -gt ${SYNO_DAEMON_MIN} -a \
		   	 ${SERVICE_DAEMON_ACTION} -lt ${SYNO_DAEMON_MAX} ]; then
	        case ${SERVICE_DAEMON_ACTION} in
    	        ${SYNO_DAEMON_STOP})
        	        RESULT_END=`${SCRIPT_SNMP_DAEMON} stop`
            	;;
	            ${SYNO_DAEMON_START})
    	            RESULT_END=`${SCRIPT_SNMP_DAEMON} start`
        	    ;;
				${SYNO_DAEMON_RESTART})
				    RESULT_END=`${SCRIPT_SNMP_DAEMON} restart`
				;;
        	    *)
            	    RESULT_END=1
	            ;;
    	    esac
		fi
    ;;
    *)
        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
    ;;
esac

