<?php
/* Copyright (c) 2010 Synology Inc. All rights reserved. */
$PHPCMD = '/usr/bin/php';
$SAFEMODEEXECDIR = '-n -d safe_mode_exec_dir=""';
$CURLMOD = '-d extension=/usr/lib/php/extensions/curl.so';
$DSMAVAILFILE = '/var/run/checkNewDSM.available';
$DSMSTATUSFILE = '/var/run/downloadDSM.status';
$CHECKSUMCMD = '/usr/syno/bin/openssl';
$CheckCmd = sprintf('%s %s %s %s', $PHPCMD, $CURLMOD, $SAFEMODEEXECDIR,
                    '/usr/syno/bin/checkNewDSM.php > /dev/null 2>&1');
$DownloadCmd = sprintf('%s %s %s %s',$PHPCMD, $CURLMOD, $SAFEMODEEXECDIR,
                       '/usr/syno/bin/downloadDSM.php');
$CheckDSMAvailCmd = '/bin/cat '.$DSMAVAILFILE;
$CheckDSMStatusCmd = '/bin/cat '.$DSMSTATUSFILE;
$ret = 0;

// open error log
openlog($argv[0], LOG_PID, LOG_CRON);

// check new DSM
$result = system($CheckCmd, $ret);
if (file_exists($DSMAVAILFILE)) {
    $result = system($CheckDSMAvailCmd, $ret);
    if ('' == $result) {
        syslog(LOG_ERR, "No new DSM available");
        goto OUT;
    }
} else {
    echo "No new DSM available\n";
    goto OUT; 
}

$list = split('[ ]', trim($result));
if (9 != sizeof($list)) {
    syslog(LOG_ERR, "Error: invalid data format!");
    $ret = -1;
    goto OUT;
} 

$path = $list[5];
$checkSum = $list[6];
$version = sprintf("%s %s", $list[7], $list[8]);

// leave if new DSM is already downloaded
if (file_exists($DSMSTATUSFILE)) {
    $result = system($CheckDSMStatusCmd, $ret);
    if ('' != $result) {
        $cList = split(' ', $result);
        if (4 != sizeof($cList)) {
            syslog(LOG_ERR, "Error invalid download status format");
            $ret = -1;
            goto OUT;
        }
        $localFile = $cList[2];

        if (file_exists($localFile)) {
            // calculate md5 checksum
            $runCmd = sprintf('%s md5 %s 2>/dev/null', $CHECKSUMCMD, $localFile);
            $result  = system($runCmd, $ret);
            if (0 != $ret) {
                $runMsg = sprintf("Error executing cmd: %s", $runCmd);
                syslog(LOG_ERR, $runMsg);
                $ret = -1;
                goto OUT;
            }
            $checkSumList = split('=', $result);
            // file already downloaded
            if (trim(end($checkSumList)) == $checkSum) {
                goto OUT;
            } 
        }
    }
}

// download new DSM
$dCmd = sprintf('%s %s "%s" %s >/dev/null 2>&1', $DownloadCmd, $path, $version, $checkSum);
$result = system($dCmd, $ret);

OUT:
closelog();
exit($ret);
?>
