#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareSet()
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, ORIGIN_SHARE_STATUS, ORIGIN_SHARE_PATH, SHARE_NAME, SHARE_STATUS, SHARE_PATH
###############################################################

#Include common scripts
SYNOBACKUP_INC_SCRP=/usr/libexec/BackupCommon.sh
. ${SYNOBACKUP_INC_SCRP}

#At begining, acquire package settings
case $1 in
    --sdk-mod-ver)
	    #Print SDK support version
        echo ${SYNOBACKUP_PKG_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYNOBACKUP_PKG_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYNOBACKUP_PKG_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYNOBACKUP_PKG_VENDOR};
    ;;
    --pre)
        #Actions before share set
    ;;
    --post)
        #Actions after share set
        RESULT_END=`${BIN_BACKUP_SHARE_RENAME} "${ORIGIN_SHARE_NAME}" "${SHARE_NAME}"`
    ;;
    *)
        echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post"
    ;;
esac

