#!/bin/sh
#S90usbip.sh - startup script for multifunctional printer
#
# This goes in /usr/syno/etc/rc.d and gets run at boot-time.
PRINTERCONF=/usr/syno/etc/printer.conf

CAT=/bin/cat
CUT=/usr/bin/cut
ECHO=/bin/echo
GET_KEY_VALUE=/bin/get_key_value
GREP=/bin/grep
INSMOD=/sbin/insmod
RMMOD=/sbin/rmmod
KILL=/bin/kill
PIDFILEDIR=/var/run
PIDOF=/bin/pidof
LOGGER=/usr/bin/logger

BIND_DRIVER=/usr/syno/sbin/bind_driver
USBIPD=/usr/syno/sbin/usbipd

USBIP_KO=/lib/modules/usbip
USBIP_COMMON_MOD_KO=/lib/modules/usbip_common_mod
VHCI_HCD_KO=/lib/modules/vhci-hcd
SYNOPRINT=/usr/syno/bin/synoprint

log_msg()
{
        $LOGGER -sp $1 -t USBIP "$2"
}

# For non-support model
SUPPORTMFP=`$GET_KEY_VALUE /etc.defaults/synoinfo.conf supportMFP`
if [ "x$SUPPORTMFP" != "xyes" ]; then
	exit 1
fi

WaitProcDead() {
        i=0
        while [ "$i" -lt 5 ] ; do
                $PIDOF $1 > /dev/null 2>&1                
                if [ "$?" -eq 1 ] ; then
                        break;
                fi
                $SLEEP 1
                i=`expr $i + 1`
        done
}

LoadModules() {
		# insmod usbip kernel modules
		$INSMOD "$USBIP_COMMON_MOD_KO.ko" > /dev/null 2>&1
		$INSMOD "$USBIP_KO.ko" > /dev/null 2>&1
		#$INSMOD "$VHCI_HCD_KO.ko" > /dev/null 2>&1
}

UnLoadModules() {
    # rmmod usbip kernel modules
    $RMMOD $USBIP_KO > /dev/null 2>&1
    $RMMOD $USBIP_COMMON_MOD_KO > /dev/null 2>&1
    #$RMMOD $VHCI_HCD_KO > /dev/null 2>&1
}

SIGUSR1USBIPD() {
    ret=`$PIDOF usbipd`
    $KILL -sigusr1 $ret > /dev/null 2>&1
}

ExecuteUSBIPD() {
    # execute the usbipd daemon or force to reload config.

    if [ "x$1" = "xrestart" ]; then    	
	WaitProcDead "usbipd"
	$USBIPD -D
    else
	ret=`$PIDOF usbipd`
	if [ $? -eq 1 ]; then
		    $USBIPD -D
	else
		    log_msg err "usbipd already have started!!"
		    #SIGUSR1USBIPD
	fi
    fi
}

STOPUSBIPD() {
    # stop the usbipd daemon and unload modules.
    $KILL -SIGTERM `$PIDOF usbipd` > /dev/null 2>&1
}

if [ "x$1" = "x" -o "x$1" = "xstart" ]; then
	PRINTER_NUM=`$SYNOPRINT --list |wc -l`
	if [ $PRINTER_NUM -gt 0 ]; then
		LoadModules
		ExecuteUSBIPD
	fi

elif [ "x$1" = "xstartd" ]; then
	LoadModules
	ExecuteUSBIPD

elif [ "x$1" = "xstop" ]; then
	STOPUSBIPD

elif [ "x$1" = "xrestart" ]; then
	STOPUSBIPD
	LoadModules
	ExecuteUSBIPD $1

elif [ "x$1" = "xbindbybusid" ]; then
    LoadModules
    $BIND_DRIVER --usbip $2 > /dev/null 2>&1
    ExecuteUSBIPD

elif [ "x$1" = "xbindbyprinterid" ]; then
    LoadModules
    $BIND_DRIVER --syno $2 > /dev/null 2>&1
    ExecuteUSBIPD

elif [ "x$1" = "xunbind" ]; then
    $BIND_DRIVER --other $2 > /dev/null 2>&1
    usbipDeviceNum=`$BIND_DRIVER --count`
    if [ $usbipDeviceNum -eq 0 ]; then
		STOPUSBIPD
    else
		SIGUSR1USBIPD
    fi
elif [ "x$1" = "xreload" ]; then
       echo "stop usbipd"
       STOPUSBIPD
       echo "unload module"
       UnLoadModules;
       echo "lsmod |grep usb"
       lsmod |grep usb
       LoadModules
       ExecuteUSBIPD
       echo "lsmod |grep usb"
       lsmod |grep usb
       echo "bind_driver --list"
       bind_driver --list
fi

