#!/bin/sh
# Copyright (c) 2003-2011 Synology Inc. All rights reserved.

PSQL="/usr/syno/pgsql/bin/psql"
DATABASE="mediaserver"
UPGRADE_DIR="/usr/syno/synoindex/sql/upgrade"

echo "test album_artist column in $DATABASE db"
SQL="SELECT album_artist FROM music LIMIT 1"
su -l admin -c "$PSQL $DATABASE -c \"$SQL\"" >/dev/null 2>&1
Ret=$?
if [ $Ret = 1 ]; then
	echo "Create album_artist column in $DATABASE db"
	Script="$UPGRADE_DIR/003_album_artist.pgsql"
	su -l admin -c "$PSQL $DATABASE < $Script"
	if [ $? != 0 ]; then
		echo "Failed to create album_artist column in $DATABASE"
		exit 2 # error
	fi

	exit 1 # need reindex
fi

exit 0 # no modification

