#!/bin/sh
OPENSSL=`which openssl`
CGIKEYDIR="/usr/syno/etc/ssl/cgi.key"
PRIVATEKEY=$CGIKEYDIR"/private.key"
PUBLICKEY=$CGIKEYDIR"/public.key"
MODULUS=$CGIKEYDIR"/modulus"

mkdir -p $CGIKEYDIR

if [ ! -s $PRIVATEKEY ]; then
	$OPENSSL genrsa -rand /dev/urandom -out $PRIVATEKEY 4096
fi

if [ ! -s $PUBLICKEY -o $PRIVATEKEY -nt $PUBLICKEY ]; then
	$OPENSSL rsa -in $PRIVATEKEY -pubout | sed 1d\$d | sed -e ':a;N;$!ba;s/\n//g' > $PUBLICKEY
fi

if [ ! -s $MODULUS -o $PRIVATEKEY -nt $MODULUS ]; then
	$OPENSSL rsa -in $PRIVATEKEY -noout -modulus | sed -e 's;.*Modulus=;;' > $MODULUS
fi

chmod 700 $CGIKEYDIR
chmod 400 $CGIKEYDIR/*
