#!/bin/sh
# Copyright (c) 2008-2010 Synology Inc. All rights reserved.

. /usr/syno/bin/synoupscommon

StartUps() { #param: START_TYPE(start, restart)
	grep -q 'STEP=4' /tmp/boot_seq.tmp
	local blOnBoot=$?
	local IsV6=0
        if [ 1 -eq $SlaveEnabled ]; then
		UpsmonServer=`/bin/get_key_value /etc/synoinfo.conf upsslave_server`
		IsV6=`echo ${UpsmonServer}|grep -c ':'`
		if [ 0 -lt $IsV6 ]; then
			UpsmonServer="[${UpsmonServer}]"
		fi
		if [ "x$UpsmonServer" = "x" ]; then
			echo "No upsmon server, disable upsmon"
			grep -vE "upsslave_enabled|upsslave_server" /etc/synoinfo.conf > /tmp/synoinfo.tmp
			mv /tmp/synoinfo.tmp /etc/synoinfo.conf
		else
			echo "Start upsmon"
			sed "/^MONITOR/c\\MONITOR ups@${UpsmonServer} 1 monuser secret slave" /usr/syno/etc/ups/upsmon.conf > /tmp/upsmon.conf
			mv /tmp/upsmon.conf /usr/syno/etc/ups/upsmon.conf
			/usr/syno/sbin/upsmon
		fi
	elif [ 1 -eq $MasterEnabled ] && [ "xsnmp" == "x${UpsMode}" ]; then
		UpsmonIp=`/bin/get_key_value /etc/synoinfo.conf ups_snmp_ip`
		SnmpCommunity=`/bin/get_key_value /etc/synoinfo.conf ups_snmp_community`

		IsV6=`echo ${UpsmonIp}|grep -c ':'`
		if [ 0 -lt $IsV6 ]; then
			UpsmonIp="udp6:[${UpsmonIp}]"
		fi

		sed -i "s/^\tdriver.*/\tdriver = snmp-ups/" /usr/syno/etc/ups/ups.conf
		sed -i "s/^\tport = .*/\tport = ${UpsmonIp}/" /usr/syno/etc/ups/ups.conf
		sed -i "s/.*community = .*/\tcommunity = ${SnmpCommunity}/" /usr/syno/etc/ups/ups.conf
		sed -i "s/.*snmp_version = .*/\tsnmp_version = v2c/" /usr/syno/etc/ups/ups.conf

		sed -i "/^MONITOR/c\\MONITOR ups@localhost 1 monuser secret master" /usr/syno/etc/ups/upsmon.conf

		/usr/syno/bin/upsdrvctl start
		sleep 1
		StartServer
		sleep 1
		if [ 0 -eq $blOnBoot ] && [ 0 -eq $StatClient ]; then
			StartClient
		else
			StartClient "-b"
		fi
	fi
}

{
flock -x 58
case "$1" in
start)
	StartUps start
	;;
stop)
	# do nothing
	StopUps
	;;
restart)
	StopUps
	WaitStop
	StartUps restart
	;;
esac

flock -u 58
} 58<>$UPS_LOCK
