#!/bin/sh

PATH="$PATH:/bin/"		# cat, echo, mkdir
PATH="$PATH:/usr/bin"		# basename

SSDPD="/usr/syno/sbin/minissdpd"

usage() {
	cat <<EOF
Usage: $(basename $0) [start|stop|restart]
EOF
}
warn() {
	local ret=$?
	echo "$@" >&2
	return $ret
}

enum_interface() {
	local i= iface=
	# to compatible with kernel lower than 2.6 (powerpc)
	if [ ! -d "/sys/class/net" ]; then
		/usr/syno/sbin/synonet --show| awk '/Network interface/ { print $3 }'
		return
	fi
	for i in /sys/class/net/*; do
		iface=$(basename $i)
		if [ -d "$i" -a "x$iface" != "xlo" ]; then
			echo $iface;
		fi
	done
}

enum_service() {
	local i=
	local dir=/usr/syno/etc/ssdp/*.conf
	if [ `ls $dir 2>/dev/null | wc -l` -ne 0 ]; then
		for i in "${dir}"; do
			echo $i;
		done
	fi
	dir=/usr/local/etc/ssdp/*.conf
	if [ `ls $dir 2>/dev/null | wc -l` -ne 0 ] ; then
		for i in "${dir}"; do 
			echo $i;
		done
	fi
}

start() {
	local reg_service="/usr/syno/bin/reg_ssdp_service"
	local i= cmd=$SSDPD 

	mkdir /usr/syno/synoman/ssdp

	for i in $(enum_interface); do
		cmd="$cmd -i $i"
	done
	echo $cmd
	if ! $cmd; then
		warn "start SSDPD failed"
		return 1
	fi

	for i in $(enum_service); do
		echo $reg_service $i
		$reg_service $i
	done
}
stop() {
	killall $(basename $SSDPD)
	rm -rf /usr/syno/synoman/ssdp
	true
}

case "$1" in
	start)   start ;;
	stop)    stop ;;
	restart) stop && start ;;
	*)       usage >&2 ; exit 1 ;;
esac

