/*var synoFileOwnerData = [
	[ 'public', 'admin', 102 ],
	[ 'music',  'guest', 35 ],
	[ 'video',  'bb',   84 ]
];*/

function FileOwner()
{
    Ext.QuickTips.init();

	if(typeof synoFileOwnerData === 'undefined' || synoFileOwnerData.length === 0) {
		NoDataSet('file_owner_nodata');
		return;
	}

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'User'},
           {name: 'Share'},
           {name: 'Count', type: 'int'},
           {name: 'Size',  type: 'int'}
        ]
    });

    // manually load local data
    store.loadData(synoFileOwnerData);

    // create the Grid
    var gridConfig = {
		border: false,
        store: store,
		stripeRows: true,
        width: 930,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		viewConfig: GridViewConfig,
        columns: [
            {
				header   : _T('common', 'username'),
                width    : 200,
                sortable : true,
                dataIndex: 'User',
				tooltip  : _T('common', 'username'),
            },
            {
				header   : styleHeaderRenderer(_T('report', 'reportUI_title_share')),
                width    : 200,
                sortable : true,
                dataIndex: 'Share',
				align: 'left',
				css: 'font-weight: bold;',
				tooltip: _T('report', 'reportUI_title_share'),
				renderer: styleRenderer
            },
            {
                header   : _T('report', 'reportUI_title_file_count'),
                width    : 100,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_file_count'),
                dataIndex: 'Count'
            },
            {
                header   : _T('common', 'size'),
                sortable : true,
                dataIndex: 'Size',
				tooltip  : _T('common', 'size'),
				renderer: SizeUnit
            }
        ],
        plugins: [ new GridPanelPlugin(14) ]
    };

var grid = new Ext.grid.GridPanel( gridConfig);
    // render the grid to the specified div in the page
    grid.render('file_owner');
}
