#!/bin/sh
#
# S03inetd.sh - startup script for inetd
#
# This goes in /usr/syno/etc/rc.d and gets run at boot-time.

INETD=/usr/sbin/inetd
INETD_CONF="/etc/inetd.conf"
RUN_TELNET=`/bin/get_key_value /etc/synoinfo.conf runtelnet`
TEMP_CONF="/tmp/inetd.$$.conf.tmp"
v4only=`/bin/get_key_value /etc.defaults/synoinfo.conf ipv4only`

case "$1" in

start)
	if pidof inetd >/dev/null; then
		echo "inetd already started"
		exit 0
	fi
	if [ "yes" = "$RUN_TELNET" ]; then
		if [ ! -f $INETD_CONF ]; then
			touch $INETD_CONF
		fi

		grep -v "^[ 	]*telnet\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		if [ "yes" == "${v4only}" ]; then
			echo "telnet	stream	tcp	nowait	root	/usr/sbin/telnetd	telnetd" >> $TEMP_CONF
		else
			echo "telnet	stream	tcp6 nowait	root	/usr/sbin/telnetd	telnetd" >> $TEMP_CONF
		fi
		mv $TEMP_CONF $INETD_CONF
	elif [ "no" = "$RUN_TELNET" ]; then
		grep -v "^[ 	]*telnet\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		mv $TEMP_CONF $INETD_CONF
	fi
	if [ -x "/usr/syno/sbin/cups-lpd" ]; then
		if [ ! -f $INETD_CONF ]; then
	   		touch $INETD_CONF
	   	fi
		grep -v "^[ 	]*printer\([ 	]\|$\)" $INETD_CONF > $TEMP_CONF
		if [ "yes" == "${v4only}" ]; then
			echo "printer	stream  tcp	nowait	root	/usr/syno/sbin/cups-lpd cups-lpd -T /var/services/printer/tmp" >> $TEMP_CONF
		else
			echo "printer	stream  tcp6 nowait	root	/usr/syno/sbin/cups-lpd cups-lpd -T /var/services/printer/tmp" >> $TEMP_CONF
		fi
		mv $TEMP_CONF $INETD_CONF
	fi

	if [ -x "$INETD" ] ; then
		echo "Starting inetd..."
		$INETD
	fi
	;;

stop)
	echo "stop inetd"
	kill `cat /var/run/inetd.pid` >/dev/null 2>&1
	if [ -r /var/run/inetd.pid ]; then
		kill -9 `cat /var/run/inetd.pid` > /dev/null 2>&1
	fi
	local retry=0
	while [ 1 ];
	do
		if pidof inetd >/dev/null; then
			killall inetd
		else
			break
		fi

		if [ $retry -gt 2 ]; then
			break
		fi
		sleep 2
		retry=`expr $retry + 1`
	done
	;;

restart)
	$0 stop
	$0 start
	;;
*)
	echo "usage: $0 { start | stop | restart}" >&2
	exit 1
	;;

esac
