#!/bin/sh

BIN_SYNOINDEX_MGR=/usr/syno/bin/synoindex_mgr

SYNOINDEX_PKG_NAME="synoindex"
SYNOINDEX_PKG_VERSION="1.0"
SYNOINDEX_PKG_VENDOR="Synology Inc."
SDK_MODVER="2.0"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${SDK_MODVER}
	;;
	--name)
		#Print package name
		echo ${SYNOTIFYD_PKG_NAME}
	;;
	--pkg-ver)
		#Print package version
		echo ${SYNOTIFYD_PKG_VERSION}
	;;
	--vendor)
		#Print package vendor
		echo ${SYNOTIFYD_PKG_VENDOR}
	;;
	--pre)
		#Actions before share encrypt action
		if [ "encrypt" = "${ENC_ACTION}" ]; then
			${BIN_SYNOINDEX_MGR} --unmount-share "${SHARE_NAME}"
		fi
	;;
	--post)
		#Actions after share encrypt action
		if ([ "encrypt" = "${ENC_ACTION}" ] && [ "0" != "${RESULT}" ]) ||
		   ([ "decrypt" = "${ENC_ACTION}" ] && [ "0" = "${RESULT}" ]); then
			${BIN_SYNOINDEX_MGR} --mount-share "${SHARE_NAME}"
		fi
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

