#!/usr/bin/env python
# coding: utf-8
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *
from FuncAPI import gVdict, initGVdict
from datetime import *
import sys
sys.path.append('/var/dynlib/securityscan/dbutils')
from dbutils import *

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_SYSTEM_CHECK
    _severity = LEVEL_RISK
    _strId = "rule_dsm_self_check_modification"

    _logPath = "/var/log/selfcheck/dsm.full.result"
    _errorFiles = []
    _WhiteList = [  '/bin/zarafa-admin',
                    '/bin/zarafa-fsck',
                    '/bin/zarafa-passwd',
                    '/bin/zarafa-archiver',
                    '/bin/zarafa-gateway',
                    '/bin/zarafa-server',
                    '/bin/zarafa-autorespond',
                    '/bin/zarafa-ical',
                    '/bin/zarafa-spooler',
                    '/bin/zarafa-dagent',
                    '/bin/zarafa-monitor',
                    '/bin/zarafa-stats',
                    '/bin/zarafa-search',
                    '/usr/syno/share/smartmontools/drivedb.db',
                    '/usr/syno/share/smartmontools/synodrivedb.db',
                    '/usr/syno/share/smartmontools/synodrivedb.version']

    def getBuildNumber(self):
        return execute("get_key_value /etc.defaults/VERSION buildnumber")[0]

    def getStatus(self):
        import re

        if os.path.exists(self._logPath):
            os.unlink(self._logPath)

        lines = []

        try:
            initGVdict()    ## Initial the gVdict and used for DSM version
            with SynoCriticalSection() as cs:
                execute("/usr/syno/bin/synoselfcheck -H dsm full")
                with open(self._logPath) as log:
                    lines = log.readlines()

            for line in lines:
                if not line.strip():
                    continue

                filename = line.split(" ")[0]
                if re.match(r'\S+ size expect\[\d+\] but get\[\d+\]', line):
                    size = re.search(r'\S+ size expect\[\d+\] but get\[(\d+)\]', line).group(1)
                else:
                    size = 0

                if filename in self._WhiteList:
                    continue

                pattern = r'^/usr/syno/synoman/webman/texts/\S{3}/mails$'
                if gVdict['productversion'] in ('6.0', '6.0.1') and re.match(pattern, filename):
                    continue

                if filename not in self._errorFiles:
                    self._errorFiles.append(filename)
        except Exception as e:
            SYSLOG(syslog.LOG_ERR, e)
            return SZ_ERROR

        return SZ_PASS if len(self._errorFiles) == 0 else SZ_FAIL

    def getMethod(self):
        return {
            METHOD_ACTION: METHOD_ACTION_LINK,
            METHOD_ACTION_VAL: 'SYNO.SDS.SupportForm.Application:SYNO.SDS.SupportForm.Application',
            METHOD_LINK_APP_STR: 'helptoc:support_center'
        }

    def getAction(self):
        return {ACTION_STR_KEY: 'action', ACTION_REPLACE_VAR: {
            '_FILES_': ', '.join(self._errorFiles)
        }}
