#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_OP_RESULT_X
#
###############################################################

BIN=/usr/syno/sbin/synosharesnapshot

handle_syslock() {
	local SHARE=$1
	local SYSLOCK_PATH="/run/sharesnap/sys_lock/""${SHARE}"".sharesnap_sys_lock"
	local FLOCK_PATH="/run/lock/sharesnap/sys_lock/""${SHARE}"".sharesnap_sys_lock"

	if [ -f "${SYSLOCK_PATH}" ]; then
		rm "${SYSLOCK_PATH}"
	fi

	if [ -f "${FLOCK_PATH}" ]; then
		rm "${FLOCK_PATH}"
	fi
}

case $1 in
	--sdk-mod-ver)
		echo "2.0" ;;
	--name)
		echo "ShareSnapshot" ;;
	--pkg-ver)
		echo "1.0" ;;
	--vendor)
		echo "Synology Inc." ;;
	--pre)
		if [ -f "${BIN}" ]; then
			INDEX=1
			NITEMS=$((NITEMS + 1))
			while [ "${INDEX}" != "${NITEMS}" ]
			do
				eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
				eval "SHARE_NAME=\$SHARE_NAME_$INDEX"
				${BIN} snap_syslock delete_share "${SHARE_NAME}"
				INDEX=$((INDEX + 1))
			done
		fi
		;;
	--post)
		INDEX=1
		NITEMS=$((NITEMS + 1))
		while [ "${INDEX}" != "${NITEMS}" ]
		do
			eval "SHARE_OP_RESULT=\$SHARE_OP_RESULT_$INDEX"
			eval "SHARE_NAME=\$SHARE_NAME_$INDEX"

			if [ "${SHARE_OP_RESULT}" == "0x0000" ]; then
				handle_syslock "${SHARE_NAME}"
			fi
			INDEX=$((INDEX + 1))
		done
	;;
	*)
		echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac
