/* Copyright (c) 2017 Synology Inc. All rights reserved. */

Ext.define("SYNO.SDS.SecurityScan.OverviewPanel",{extend:"SYNO.ux.Panel",iconStep:0,sysProgress:100,maxAlramSeverity:"",statusBarWidth:710,blOverviewStatusStoreUpdate:true,sysStatus:"firstScan",runningStatus:["running","stopping","updating"],overviewStatusStoreField:["status","text","desc","progress","elapsedTime","lastScanTime"],iconStoreField:["status"],statusBarStoreField:["category","categoryDesc","statusDesc","level","isDone","isEmpty","progress","lastProgress"],elmPool:{},constructor:function(a){this.module=a.module;this.owner=a.appWin;Ext.apply(this,a);var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.mainWindow=SYNO.SDS.SecurityScan.Window;this.SecurityStatus={running:{status:"running",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_scan"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_scan_desc")},stopping:{status:"stopping",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_stop"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_stop_desc")},updating:{status:"updating",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_update"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_update_desc")},warning:{status:"warning",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_warning"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_warning_desc")},crack:{status:"danger",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_danger"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_danger_desc")},danger:{status:"danger",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_danger"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_danger_desc")},risk:{status:"risk",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_risk"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_risk_desc")},outOfDate:{status:"outOfDate",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_outOfDate"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_outOfDate_desc")},firstScan:{status:"firstScan",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_firstScan"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_firstScan_desc")},safe:{status:"safe",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_safe"),desc:SYNO.SDS.SecurityScan._V("securityscan","securityscan_system_safe_desc")}};this.iconStore=new Ext.data.JsonStore({autoDestroy:true,fields:this.iconStoreField});this.overviewStatusStore=new Ext.data.JsonStore({autoDestroy:true,fields:this.overviewStatusStoreField});this.statusBarStore=new Ext.data.JsonStore({autoDestroy:true,fields:this.statusBarStoreField});this.statusBarInitStore=new Ext.data.JsonStore({autoDestroy:true,fields:this.statusBarStoreField});this.status=this.createStatusPanel();this.StatusField=this.createStatusBarPanel();var b={border:false,autoFlexcroll:true,items:[this.status,this.StatusField]};Ext.apply(b,a);return b},initEvents:function(){this.callParent(arguments);this.mon(this.mainWindow.sysStatusStore,"load",this.onStoreLoadDone,this);this.mon(this.mainWindow.sysStatusStore,"update",this.onStoreLoadDone,this);this.mon(this.mainWindow.sysStatusStore,"add",this.onStoreLoadDone,this);this.mon(this.statusBarStore,"load",this.onStatusBarLoadDone,this);this.mon(this.mainWindow.specialRulesStore,"update",this.barAreaSet,this)},createStatusPanel:function(){return{xtype:"syno_panel",hideLabel:true,layout:"hbox",layoutConfig:{align:"stretch",pack:"start"},border:false,height:200,items:[this.createIconPanel(),this.createOverviewStatusPanel()]}},createIconPanel:function(){var a=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div style="height:180px;padding-bottom:8px;">','<div class="securityscan-overview-overviewStatus-icon securityscan-overview-overviewStatus-icon-{status}"></div>',"</div>","</tpl>",{compiled:true}),store:this.iconStore});return{xtype:"syno_panel",layout:"vbox",border:false,width:258,height:150,layoutConfig:{align:"center",pack:"start"},items:[a]}},createOverviewStatusPanel:function(){var a=new Ext.DataView({height:100,tpl:new Ext.XTemplate('<tpl for=".">','<tpl if="this.progressShow(progress)">','<div class="securityscan-overview-overviewStatus-text securityscan-overview-overviewStatus-text-{status}">{text} ({progress}%)</div>',"</tpl>",'<tpl if="this.progressShow(progress) === false">','<div class="securityscan-overview-overviewStatus-text securityscan-overview-overviewStatus-text-{status}">{text}</div>',"</tpl>",'<tpl if="this.lastScanTimeShow(lastScanTime) === false">','<div class="securityscan-overview-overviewStatus-desc">{desc}<br/>','<tpl if="this.elapsedTimeShow(elapsedTime)">',SYNO.SDS.SecurityScan._V("securityscan","securityscan_elapsed_time"),"{elapsedTime}</tpl>","</div>","</tpl>",'<tpl if="this.lastScanTimeShow(lastScanTime)">','<div class="securityscan-overview-overviewStatus-desc">{desc}<br/>{lastScanTime}</div>',"</tpl>","</tpl>",{progressShow:function(b){if(100!==b){return true}else{return false}},lastScanTimeShow:function(b){if(""!==b){return true}else{return false}},elapsedTimeShow:function(b){if(b&&""!==b){return true}else{return false}},compiled:true}),store:this.overviewStatusStore});return{xtype:"syno_panel",hideLabel:true,height:150,layout:"vbox",layoutConfig:{align:"stretch",pack:"center"},flex:7,border:false,items:[{xtype:"syno_panel",hideLabel:true,layout:"hbox",height:100,border:false,baseCls:"",layoutConfig:{align:"end",pack:"start",defaultMargins:{top:0,right:5,bottom:0,left:0}},items:[a]},{xtype:"syno_panel",hideLabel:true,layout:"hbox",height:50,border:false,baseCls:"",layoutConfig:{align:"end",pack:"start",defaultMargins:{top:0,right:5,bottom:0,left:0}},items:[{xtype:"syno_button",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_scan"),id:this.startScanButtonID=Ext.id(),scope:this,disabled:_S("demo_mode"),handler:this.doStartScanAll},{xtype:"syno_button",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_stop"),id:this.stopScanButtonID=Ext.id(),scope:this,disabled:_S("demo_mode"),handler:this.doStopScanAll,hideLabel:true},{xtype:"syno_button",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_view_results"),scope:this,handler:function(){this.mainWindow.selectPage("SYNO.SDS.SecurityScan.ResultPanel")}}]}]}},createStatusBarPanel:function(){var a=new Ext.DataView({tpl:this.createStatusBarTpl(),store:this.statusBarInitStore});var b={xtype:"syno_fieldset",items:[a]};return b},createStatusBarTpl:function(){var a=new Ext.XTemplate('<tpl for=".">','<div class="securityscan-situation-container">','<div id="container_{category}_ID" class="securityscan-label-container">','<div class="first_area securityscan-overview-bar-icon securityscan-overview-bar-icon-{category}">','<div class="securityscan-overview-bar-title">{categoryDesc}</div>',"</div>",'<div class="second_area">','<div id="{category}_second_ID" class="securityscan-overview-bar-desc"></div>',"</div>",'<div class="third_area">','<div id="{category}_third_ID" class="securityscan-progress-desc"></div>',"</div>","</div>",'<div id="{category}_progress_bar_ID" style="width:{lastProgress}%;" class="securityscan-progress securityscan-bk-progress"></div>',"</div>","</tpl>",{isDone:function(b){return 100===b?true:false}});return a},startIconAnimate:function(){if(0<this.iconStep){var b=("running-"+(this.iconStep%24+1)).toString();var a=this;this.iconStore.loadData([{status:b}]);this.iconStep++;setTimeout(function(){a.startIconAnimate()},100)}},stopIconAnimate:function(a){this.iconStep=0;this.iconStore.loadData([{status:a}])},iconAreaSet:function(){if(0<=this.runningStatus.indexOf(this.sysStatus)){if(0===this.iconStep){this.iconStep=1;this.startIconAnimate()}}else{this.stopIconAnimate(this.sysStatus)}},setScanningTime:function(a){this.startScanningTime=a},getScanningTime:function(){return this.startScanningTime},stopOverviewStatusElapsedTime:function(a){delete this.startScanningTime;if(a){this.blOverviewStatusStoreUpdate=false}},overviewStatusAreaSet:function(){var c,a;if(!this.blOverviewStatusStoreUpdate){return}if(0<=this.runningStatus.indexOf(this.sysStatus)){this.SecurityStatus[this.sysStatus].elapsedTime=this.mainWindow.timeRender(this.startScanningTime,false);this.SecurityStatus[this.sysStatus].lastScanTime=""}else{this.stopOverviewStatusElapsedTime();this.SecurityStatus[this.sysStatus].elapsedTime="";if(!this.mainWindow.lastScanTime){this.SecurityStatus[this.sysStatus].lastScanTime=""}else{c=this.mainWindow.timeRender(this.mainWindow.lastScanTime,true);a=SYNO.SDS.SecurityScan._V("securityscan","securityscan_last_scan_time");this.SecurityStatus[this.sysStatus].lastScanTime=String.format(a,c)}}this.SecurityStatus[this.sysStatus].progress=this.sysProgress;this.overviewStatusStore.loadData([this.SecurityStatus[this.sysStatus]],false);this.overviewBtnSet(false);if(this.startScanningTime){var b=this;setTimeout(function(){b.overviewStatusAreaSet()},500)}},ruleActionExtraGet:function(d,b){var c,a;c=this.mainWindow.specialRuleRecordCheck(d,true);if(c){if(c.get("isFail")){a=c.get("actionExtra");if(a&&a[b]){return a[b]}}}return""},statusBarFontClsGet:function(a){switch(a){case"danger":case"risk":return"red-status";case"warning":case"outOfDate":return"orange-status";case"info":case"safe":return"green-status"}},statusHtmlwrapper:function(a,b){return String.format('<font class="{0}">{1}</font>',a,b)},statusDescFill:function(d,c){var f,e,b,a;for(f in c.fail){if(c.fail.hasOwnProperty(f)&&0<c.fail[f]){if("safe"===f||"info"===f||this.statusDescGet(d,f)){continue}e=String.format("securityscan_check_{0}_{1}",f,c.category);b=SYNO.SDS.SecurityScan._V("securityscan",e);if(b){a=this.statusBarFontClsGet(f);b=String.format(b,c.fail[f]);this.statusDescSet(d,f,this.statusHtmlwrapper(a,b))}}}},statusDescGet:function(b,c){var a={danger:0,risk:1,warning:2,outOfDate:3,info:4,safe:5};return b[a[c]]},statusDescSet:function(c,d,b){var a={danger:0,risk:1,warning:2,outOfDate:3,info:4,safe:5};c[a[d]]=b},barStatusDescGet:function(j){var g;var d;var n=[];var m="";var b=j.failSeverity;var h="ruleDB.Update.DSM.check_latest_dsm";var c="ruleDB.Update.Package.check_latest_pkg";var e="ruleDB.User.Password.top50000StrengthCheck";if(100!==j.progress){d="blue-status";m=SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_desc_"+j.category);if(j.runningItem){m+="<br/>"+this.mainWindow.getStringKeyVal(j.runningItem,"desc_running")}return this.statusHtmlwrapper(d,m)}d=this.statusBarFontClsGet(b);if("userInfo"===j.category){if("safe"===b||"info"===b){if(this.mainWindow.specialRuleRecordCheck(e,true)){m=SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_pass_userInfo_passwrod")+"<br/>"}m+=SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_pass_userInfo");if("info"===b){m+="</br>"+SYNO.SDS.SecurityScan._V("securityscan","securityscan_info_fail_desc")}return this.statusHtmlwrapper(d,m)}if("risk"===b){var l=this.ruleActionExtraGet(e,"FAIL_USERS_NUM");if(""!==l&&0<l){g="securityscan_check_week_password";m=String.format(SYNO.SDS.SecurityScan._V("securityscan",g),l);this.statusDescSet(n,b,this.statusHtmlwrapper(d,m))}}this.statusDescFill(n,j)}else{if("update"===j.category){if("safe"===b||"info"===b){var a=[];if(this.mainWindow.specialRuleRecordCheck(h,true)){a.push(SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_pass_update_dsm"))}if(this.mainWindow.specialRuleRecordCheck(c,true)){a.push(SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_pass_update_package"))}if(0===a.length){m=SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_pass_update")}else{if(2===a.length){m=_T("securityscan","securityscan_check_pass_update_dsm_package")}else{m=a.join("</br>")}}if("info"===b){m+="<br/>"+SYNO.SDS.SecurityScan._V("securityscan","securityscan_info_fail_desc")}return this.statusHtmlwrapper(d,m)}if("outOfDate"===b){var k=[],i,f;f=this.mainWindow.specialRuleRecordCheck(h,true);if(f&&f.get("isFail")){k.push(SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_outOfDate_updates_dsm"))}i=this.ruleActionExtraGet(c,"FAIL_PACKAGES_NUM");if(""!==i&&0<i){k.push(String.format(SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_outOfDate_updates_package"),i))}m=k.join("<br/>");this.statusDescSet(n,b,this.statusHtmlwrapper(d,m))}this.statusDescFill(n,j)}else{if("safe"===b||"info"===b){g="securityscan_check_pass_"+j.category;m=SYNO.SDS.SecurityScan._V("securityscan",g);if("info"===b){m+="<br/>"+SYNO.SDS.SecurityScan._V("securityscan","securityscan_info_fail_desc")}return this.statusHtmlwrapper(d,m)}this.statusDescFill(n,j)}}n=n.filter(function(o){return o});return n.join("<br/>")},barAreaSet:function(){var a=0;var c={};var b=[];if(0===this.mainWindow.sysStatusStore.data.length){for(a=0;a<this.mainWindow.totalCategories.length;a++){c={};c.category=this.mainWindow.totalCategories[a];c.categoryDesc=SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_"+this.mainWindow.totalCategories[a]);c.level="";c.isEmpty="";c.progress=0;c.lastProgress=0;c.statusDesc="";b.push(c)}this.statusBarInitStore.loadData(b,false);b=b.filter(function(d){return d});this.statusBarStore.loadData(b,false);return}this.mainWindow.sysStatusStore.each(function(f){var d;var e=f.data;c={};d=this.mainWindow.totalCategories.indexOf(e.category);if(0>d){return}c.category=e.category;c.categoryDesc=SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_"+e.category);c.isEmpty=e.total===0?true:false;c.progress=e.progress;c.lastProgress=this.statusBarStore.getAt(d).get("progress");if(!c.isEmpty&&100===c.progress){c.level=e.failSeverity}if(c.isEmpty){c.statusDesc='<font color="#96A0AA">'+SYNO.SDS.SecurityScan._V("securityscan","securityscan_check_empty")+"</font>"}else{c.statusDesc=this.barStatusDescGet(e)}b[d]=c},this);b=b.filter(function(d){return d});this.statusBarStore.loadData(b,false);if(0===this.statusBarInitStore.getTotalCount()){this.statusBarInitStore.loadData(b,false)}},onStoreLoadDone:function(){this.iconAreaSet();this.barAreaSet();this.overviewStatusAreaSet()},setClickHandler:function(b){var a=Ext.get("container_"+b+"_ID");if(a){a.on("click",function(d,c){this.mainWindow.resultFilterKey=b;this.mainWindow.selectPage("SYNO.SDS.SecurityScan.ResultPanel")},this)}},animateDone:function(d,c,b,f){if(100!==c&&100===b){var a=Ext.get(d+"_third_ID");var e=Ext.get("container_"+d+"_ID");if(a&&e){a.dom.innerHTML="";a.removeClass("securityscan-progress-desc");a.addClass(["securityscan-overview-icon","securityscan-overview-icon-"+f]);e.addClass(["securityscan-overview-bar-bk-"+f])}}},onStatusBarLoadDone:function(){this.statusBarStore.each(function(g){var k=g.get("category");var h=g.get("lastProgress");var a=g.get("progress");var j=k+"_second_el";var l=k+"_third_el";this.elmPool[j]=Ext.get(k+"_second_ID");this.elmPool[l]=Ext.get(k+"_third_ID");if(!this.elmPool[j]||!this.elmPool[l]){return}if(100===a){this.setClickHandler(k)}this.elmPool[j].dom.innerHTML=g.get("statusDesc");if(h!==a&&!g.get("isEmpty")){this.elmPool[l].dom.innerHTML=a+"%";var d=Ext.get(k+"_progress_bar_ID");var b=g.get("level");if(d){var f=this;try{d.animate({width:{to:(a/100)*this.statusBarWidth,from:(h/100)*this.statusBarWidth}},0.5,null,"easeOut","run");setTimeout(function(){f.animateDone(k,h,a,b)},700)}catch(i){console.log("Error: "+i)}}}},this)},doStartScanAll:function(){this.mainWindow.doStartScan("ALL")},doStopScanAll:function(){this.mainWindow.doStopScan("ALL")},sysStatusSet:function(b,a){this.sysStatus=b;this.sysProgress=a?a:0},overviewBtnSet:function(b){var a=this.sysStatus;if(!this.startScanButtonEle){this.startScanButtonEle=Ext.getCmp(this.startScanButtonID)}if(!this.stopScanButtonEle){this.stopScanButtonEle=Ext.getCmp(this.stopScanButtonID)}if(b){this.startScanButtonEle.disable();this.stopScanButtonEle.disable();return}switch(a){case"running":this.startScanButtonEle.hide();this.stopScanButtonEle.show();if(!_S("demo_mode")){this.stopScanButtonEle.enable()}break;case"stopping":case"updating":this.startScanButtonEle.disable();this.stopScanButtonEle.disable();break;default:this.startScanButtonEle.show();if(!_S("demo_mode")){this.startScanButtonEle.enable()}this.stopScanButtonEle.hide();break}this.doLayout()},openFirstScanDialog:function(){var a=new SYNO.SDS.SecurityScan.OverviewPanel.FirstScanDialog({module:this.module,owner:this.owner});a.open()},isRunningStatus:function(a){if(0<=this.runningStatus.indexOf(a)){return true}else{return false}},maxAlramSeveritySet:function(a){this.maxAlramSeverity=a}});Ext.define("SYNO.SDS.SecurityScan.OverviewPanel.FirstScanDialog",{extend:"SYNO.SDS.Wizard.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.workID=Ext.id();this.homeID=Ext.id();this.selectedID=this.homeID;this.textStore=new Ext.data.JsonStore({fields:["text","workBkCls","homeBkCls"],data:[{text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_home_desc"),homeBkCls:"securityscan-firstScan-icon-bk"}]});Ext.apply(a,{width:650,height:500,resizable:false,closable:false,title:SYNO.SDS.SecurityScan._V("common","welcome"),steps:[this.createPanel({owner:this,itemId:"chooseGroup",nextId:null})],fbar:this.configButtons()});this.callParent([a]);this.mon(this.textStore,"load",this.setClickHandler,this)},configButtons:function(){var b="syno_button";var a="->";return[{xtype:b,btnStyle:"grey",itemId:"back",text:_T("common","back"),scope:this},a,{xtype:b,btnStyle:"blue",itemId:"next",text:SYNO.SDS.SecurityScan._V("common","start"),scope:this,handler:this.doGroupSave}]},createPanel:function(b){this.mainWindow=SYNO.SDS.SecurityScan.Window;var a=new Ext.DataView({tpl:new Ext.XTemplate('<tpl for=".">','<div class="securityscan-group">','<div class="securityscan-group-label-container">','<div class="securityscan-firstScan-icon-home securityscan-firstScan-icon {homeBkCls}">','<div id="'+this.homeID+'" class="securityscan-firstScan-icon-home-icon"></div>','<div class="securityscan-firstScan-icon-home-text">'+SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_home")+"</div>","</div>",'<div class="securityscan-firstScan-icon-company securityscan-firstScan-icon {workBkCls}">','<div id="'+this.workID+'" class="securityscan-firstScan-icon-company-icon"></div>','<div class="securityscan-firstScan-icon-company-text">'+SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_company")+"</div>","</div>","</div>",'<div class="securityscan-group-bottom-container">{text}</div>',"</div>","</tpl>",{compiled:true}),height:280,store:this.textStore});var c=Ext.apply({headline:SYNO.SDS.SecurityScan._V("securityscan","first_title"),description:SYNO.SDS.SecurityScan._V("securityscan","securityscan_group_choose_desc"),xtype:"syno_formpanel",border:false,labelWidth:200,height:280,items:[a],checkState:function(){SYNO.SDS.Wizard.Step.prototype.checkState.apply(this,arguments);this.owner.getButton("next").setText(SYNO.SDS.SecurityScan._V("common","start"))}},b);return c},clickHandler:function(c,a){var b=[];if(a.id===this.workID){this.selectedID=this.workID;b.push({text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_company_desc"),workBkCls:"securityscan-firstScan-icon-bk"})}else{this.selectedID=this.homeID;b.push({text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_home_desc"),homeBkCls:"securityscan-firstScan-icon-bk"})}this.textStore.loadData(b,false)},setClickHandler:function(){var b=[this.homeID,this.workID];for(var a=0;a<b.length;a++){var c=Ext.get(b[a]);if(c){c.on("click",this.clickHandler,this)}}},doGroupSave:function(){var a={};var b=Math.floor(Math.random()*7);var d=Math.floor(Math.random()*5)+1;var c=Math.floor(Math.random()*60);a.api="SYNO.Core.SecurityScan.Conf";a.method="set";a.version=1;a.params={Input:{argGroup:this.selectedID===this.workID?"company":"home",enableSchedule:true,weekday:b.toString(),hour:d,minute:c,scheduleTaskId:-1}};this.getEl().mask(_T("common","loading"));this.mainWindow.apiSend.call(this,a,function(e){this.mainWindow.doStartScan("ALL");this.getEl().unmask();this.close()},function(e){this.getEl().unmask()})},onOpen:function(){this.callParent(arguments);this.setClickHandler()}});Ext.define("SYNO.SDS.SecurityScan.ResultPanel",{extend:"SYNO.ux.GridPanel",constructor:function(a){this.module=a.module;this.owner=a.appWin;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.mainWindow=SYNO.SDS.SecurityScan.Window;this.tbarStore=new Ext.data.ArrayStore({fields:["id","display"],data:[[this.mainWindow.resultFilterID+"_ALL",SYNO.SDS.SecurityScan._V("securityscan","securityscan_all")],["",SYNO.SDS.SecurityScan._V("securityscan","securityscan_filter_category")],[this.mainWindow.resultFilterID+"_malware",SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_malware")],[this.mainWindow.resultFilterID+"_systemCheck",SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_systemCheck")],[this.mainWindow.resultFilterID+"_userInfo",SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_userInfo")],[this.mainWindow.resultFilterID+"_network",SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_network")],[this.mainWindow.resultFilterID+"_update",SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_update")]]});var b=this.createCategoryConfig();Ext.apply(b,a);return b},initEvents:function(){this.callParent(arguments);this.mon(this.mainWindow.allItemsStore,"load",this.onStoreLoadDone,this);this.mon(this.mainWindow.allItemsStore,"update",this.onStoreLoadDone,this);this.mon(this.mainWindow.allItemsStore,"add",this.onStoreLoadDone,this)},createCategoryConfig:function(){var b=[{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_status"),dataIndex:"status",sortable:true,width:40,scope:this,renderer:function(f){var d=SYNO.SDS.SecurityScan._V("securityscan","securityscan_result_"+f);var e=this.valBeauty(f,"status");return this.tplAdd(d,e)}},{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_level"),dataIndex:"severitySort",hideable:false,width:50,sortable:true,renderer:function(j,g,i,f,h,d){j=i.get("severity");if(""===j){return""}var e=SYNO.SDS.SecurityScan._V("securityscan","securityscan_severity_"+j);return this.tplAdd(e,e)},scope:this},{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_desc"),dataIndex:"strId",sortable:true,scope:this,renderer:function(i,f,h,e,g,d){if("pass"===h.get("status")){i=this.mainWindow.getStringKeyVal(i,"desc_good")}else{if("running"===h.get("status")){i=this.mainWindow.getStringKeyVal(i,"desc_running")}else{i=this.mainWindow.getStringKeyVal(i,"desc_bad")}}return this.tplAdd(i,i)},width:240},{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_update"),dataIndex:"update",sortable:true,width:60,scope:this,renderer:function(j,g,i,f,h,d){if(!j||""===j||"running"===i.get("status")){return""}var e=this.mainWindow.timeRender(j,true);return this.tplAdd(e,e)}}];var c=new Ext.Toolbar({defaultType:"syno_button",items:this.getTbarItems()});var a={tbar:c,title:"SYNO.ux.GridPanel",store:this.mainWindow.allItemsStore,height:this.mainWindow.getHeight()-40,columns:b,viewConfig:{deferEmptyText:false,emptyText:this.viewShow(),markDirty:false},listeners:{rowclick:function(d,g,f){this.onBtnCheck()},rowdblclick:function(d,e){this.openDetailDialog()},scope:this}};return a},setFilter:function(c){var b,a;this.getSelectionModel().clearSelections();a=this.tbarStore.find("id",c);b=this.tbarStore.getAt(a).get("display");Ext.getCmp(this.filterTbarID).setValue(b);this.mainWindow.storeFilter(c);this.viewShow()},viewShow:function(){if(this.getEl()){if(0===this.mainWindow.allItemsStore.data.length){this.getEl().mask(_T("securityscan","securityscan_check_empty"),"syno-ux-mask-info")}else{this.getEl().unmask(_T("securityscan","securityscan_check_empty"),"syno-ux-mask-info")}this.getView().refresh()}},customGroupSet:function(){var a={};var b=this.mainWindow.allItemsStore.snapshot||this.mainWindow.allItemsStore.data;var c="";b.each(function(f){var d=false;var e=f.get("id");this.removeItems.each(function(g){if(g.get("id")===e){d=true;return}},this);if(!d){c+=" "+e}},this);this.getEl().mask(_T("common","loading"));a.api="SYNO.Core.SecurityScan.Conf";a.method="group_set";a.version=1;a.params={items:c};this.mainWindow.apiSend.call(this,a,function(d){this.getSelectionModel().clearSelections();this.onBtnCheck();this.getEl().unmask(_T("common","loading"));this.mainWindow.defGroup="custom";this.removeItems.each(function(e){this.mainWindow.allItemsStore.remove(e)},this);this.mainWindow.onSysStatusPolling()},function(d){this.getEl().unmask(_T("common","loading"))})},beforeCustomGroupSet:function(){if("custom"!==this.mainWindow.defGroup){this.mainWindow.getMsgBox().confirm("securityscan",_T("securityscan","confirm_group_change"),function(a){if("yes"===a){this.getEl().mask(_T("common","loading"));this.customGroupSet()}},this)}else{this.getEl().mask(_T("common","loading"));this.customGroupSet()}},skipRule:function(){this.removeItems="";var a={};this.removeItems=this.getSelectionModel().getSelections();var b=this.mainWindow.allItemsStore.snapshot||this.mainWindow.allItemsStore.data;if(this.mainWindow.sysStatusRunning){this.mainWindow.getMsgBox().alert("securityscan",_T("securityscan","securityscan_error_is_scanning"));return}if(0>=this.removeItems.length||1===b.length){return}if(""===this.mainWindow.defGroup){a.api="SYNO.Core.SecurityScan.Conf";a.method="get";a.version=1;a.params={};this.getEl().mask(_T("common","loading"));this.mainWindow.apiSend.call(this,a,function(c){this.getEl().unmask(_T("common","loading"));this.mainWindow.defGroup=c.defaultGroup;this.beforeCustomGroupSet()},function(c){this.getEl().unmask(_T("common","loading"))})}else{this.beforeCustomGroupSet()}},onScanBtnCheck:function(){var a=true;var c=this.mainWindow.allItemsStore.snapshot||this.mainWindow.allItemsStore.data;var b;if(!Ext.getCmp(this.scanBtnID)){return}b=this.getSelectionModel().getSelections();if(0>=b.length){Ext.getCmp(this.scanBtnID).disable();return}c.each(function(d){if("running"===d.data.status){a=false;return}},this);if(a){if(!_S("demo_mode")){Ext.getCmp(this.scanBtnID).enable()}}else{Ext.getCmp(this.scanBtnID).disable()}},onViewBtnCheck:function(){var a;if(!Ext.getCmp(this.viewBtnID)){return}a=this.getSelectionModel().getSelections();if(1!==a.length){Ext.getCmp(this.viewBtnID).disable()}else{Ext.getCmp(this.viewBtnID).enable()}},onSkipBtnCheck:function(){var a;if(!Ext.getCmp(this.skipBtnID)){return}a=this.getSelectionModel().getSelections();if(this.mainWindow.sysStatusRunning){Ext.getCmp(this.skipBtnID).disable();return}if(1<=a.length){if(!_S("demo_mode")){Ext.getCmp(this.skipBtnID).enable()}}else{Ext.getCmp(this.skipBtnID).disable()}},onBtnCheck:function(){this.onScanBtnCheck();this.onViewBtnCheck();this.onSkipBtnCheck()},openDetailDialog:function(){var a=new SYNO.SDS.SecurityScan.ResultPanel.DetailDialog({module:this.module,owner:this.owner,seletedItem:this.getSelectionModel().getSelected().data});a.open()},onStoreLoadDone:function(a){this.onBtnCheck();this.viewShow();this.getView().refresh()},getTbarItems:function(){var a=[{text:_T("securityscan","view"),itemId:"view",tooltip:_T("securityscan","view"),id:this.viewBtnID=Ext.id(),disabled:true||_S("demo_mode"),scope:this,handler:function(c,b){this.openDetailDialog("add")}},{text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_scan"),itemId:"edit",tooltip:SYNO.SDS.SecurityScan._V("securityscan","securityscan_scan"),id:this.scanBtnID=Ext.id(),disabled:true,scope:this,handler:function(e,c){var b,d="";b=this.getSelectionModel().getSelections();if(0<b.length){b.each(function(f){d+=" "+f.get("id");f.set("status","running")},this);this.mainWindow.doStartScan(d)}else{this.mainWindow.getMsgBox().alert("securityscan",SYNO.SDS.SecurityScan._V("securityscan","securityscan_alert_non_items"))}}},{text:_T("common","skip"),itemId:"skip",tooltip:_T("common","skip"),id:this.skipBtnID=Ext.id(),disabled:true||_S("demo_mode"),scope:this,handler:function(c,b){this.skipRule()}},"->",{xtype:"syno_combobox",id:this.filterTbarID=Ext.id(),displayField:"display",valueField:"id",value:"ALL",store:this.tbarStore,tpl:'<tpl for="."><div class="x-combo-list-item "><tpl if="(id != \'\')">\uff0e</tpl>{display}</div></tpl>',listeners:{select:this.onFilterSelect,beforeselect:this.onBeforeFilterSelect,scope:this}}];return a},valBeauty:function(c,b){if(""===c){return c}if("status"===b){var a='<div class="securityscan-result securityscan-result-{0}"></div>';if("nonChecked"===c){c='<div style="text-align: center; font-size: 20px;"><font class="blue-status">-</font></div>'}else{c=String.format(a,c)}}return c},tplAdd:function(b,a){if(!b){return}b=Ext.util.Format.htmlEncode(b);b=b.replace("'","&lsquo;");return"<div ext:qtip='"+b+"'>"+a+"</div>"},onBeforeFilterSelect:function(c,a,b){if(""===a.get("id")){return false}return true},onFilterSelect:function(c,a,b){var d=a.get("id");this.setFilter(d)},onPageActivate:function(){var a=String.format("{0}_{1}",this.mainWindow.resultFilterID,this.mainWindow.resultFilterKey);this.setFilter(a);this.onBtnCheck();this.viewShow()},onPageDeactivate:function(){this.mainWindow.resultFilterKey="ALL"}});Ext.define("SYNO.SDS.SecurityScan.SettingsPanel",{extend:"SYNO.ux.Panel",mainPanel:null,constructor:function(a){this.module=a.module;this.owner=a.appWin;var b={border:false,itemId:"config",layout:"fit",items:[this.mainPanel=this.createConfigPanel()]};this.callParent([b])},createConfigPanel:function(){return new SYNO.SDS.SecurityScan.SettingsContainerPanel({module:this.module,owner:this.owner})},isDirty:function(){return this.mainPanel.isDirty()},onPageActivate:function(){this.mainPanel.onActivate()}});Ext.define("SYNO.SDS.SecurityScan.SettingsContainerPanel",{extend:"SYNO.ux.FormPanel",defaultBehaviorFieldSet:null,customGroupFieldSet:null,buttonApplyId:null,app:null,constructor:function(a){this.module=a.module;this.owner=a.owner;var b=this.getContainerConfig();this.callParent([b])},getContainerConfig:function(){this.mainWindow=SYNO.SDS.SecurityScan.Window;this.defaultBehaviorFieldSet=this.createDefaultBehaviorFieldSet();this.ScheduleBehaviorFieldSet=this.createScheduleBehaviorFieldSet();var a=this.createApplyButtons();var b={labelAlign:"left",border:false,itemId:"config",autoScroll:true,trackResetOnLoad:true,buttons:a,items:[this.defaultBehaviorFieldSet,this.ScheduleBehaviorFieldSet]};return b},createDefaultBehaviorFieldSet:function(){var a=SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_home_desc")+" "+SYNO.SDS.SecurityScan._V("securityscan","list_view_desc");a=String.format(a,'<a class="link-font" href="#">',"</a>");var b={labelWidth:72,title:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group"),items:[{xtype:"syno_radio",name:"scanGroup",inputValue:"home",scope:this,handler:this.onScanGroupRatioClick,boxLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_home"),checked:true},{xtype:"syno_displayfield",indent:1,value:a,htmlEncode:false,listeners:{scope:this,single:true,buffer:80,render:function(d){var c=d.el.first("a");if(c){this.mon(c,"click",function(f){f.preventDefault();this.onClickGroup("home")},this)}}}},{xtype:"syno_radio",name:"scanGroup",inputValue:"company",scope:this,handler:this.onScanGroupRatioClick,boxLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_company")},{xtype:"syno_displayfield",indent:1,value:a,htmlEncode:false,listeners:{scope:this,single:true,buffer:80,render:function(d){var c=d.el.first("a");if(c){this.mon(c,"click",function(f){f.preventDefault();this.onClickGroup("company")},this)}}}},{xtype:"syno_radio",name:"scanGroup",inputValue:"custom",scope:this,handler:this.onScanGroupRatioClick,boxLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_custom")},{xtype:"syno_displayfield",indent:1,value:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_default_group_custom_desc")},{xtype:"syno_button",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_custom_group"),indent:1,id:this.customListBtn=Ext.id(),scope:this,handler:function(){this.onClickGroup("custom")}}]};return new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill(b))},createScheduleBehaviorFieldSet:function(){var a={labelWidth:200,title:SYNO.SDS.SecurityScan._V("securityscan","securityscan_schedule_name"),items:this.createScheduleTimeItems()};return new SYNO.ux.FieldSet(SYNO.LayoutConfig.fill(a))},onScanGroupRatioClick:function(a,b){if(!a.checked){return}if("custom"===a.value){Ext.getCmp(this.customListBtn).enable()}else{Ext.getCmp(this.customListBtn).disable()}},onClickGroup:function(b){var c;switch(b){case"home":c=_T("securityscan","securityscan_config_default_group_home");break;case"company":c=_T("securityscan","securityscan_config_default_group_company");break;case"custom":c=_T("securityscan","securityscan_config_default_group_custom");break}var a=new SYNO.SDS.SecurityScan.SettingsPanel.ListDialog({module:this.module,owner:this.owner,ownerForm:this.form,parentObj:this,group:b,title:c});a.open()},createScheduleTimeItems:function(){return[{xtype:"syno_checkbox",name:"enableSchedule",boxLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_config_schedule_desc"),hideLabel:true},{xtype:"syno_schedulefield",indent:1,fieldLabel:_T("schedule","run_on_days"),name:"weekday",allowBlank:false,editable:false,width:151},{xtype:"syno_compositefield",fieldLabel:_T("schedule","run_task"),indent:1,items:[{xtype:"syno_combobox",store:this.createTimeItemStore("hour"),displayField:"display",name:"hour",valueField:"value",triggerAction:"all",value:0,mode:"local",width:70},{xtype:"syno_displayfield",value:":",width:2},{xtype:"syno_combobox",store:this.createTimeItemStore("min"),displayField:"display",name:"minute",valueField:"value",triggerAction:"all",value:0,width:70,mode:"local"}]}]},createTimeItemStore:function(e){var a=[];var c={hour:24,min:60};if(e in c){for(var d=0;d<c[e];d++){a.push([d,String.leftPad(String(d),2,"0")])}var b=new Ext.data.SimpleStore({fields:["value","display"],data:a});return b}return null},createApplyButtons:function(){return[{xtype:"syno_button",btnStyle:"blue",text:_T("common","commit"),scope:this,disabled:_S("demo_mode"),id:this.buttonApplyId=Ext.id(),handler:this.onClickCommit},{xtype:"syno_button",btnStyle:"grey",text:SYNO.SDS.SecurityScan._V("common","alt_reset"),scope:this,handler:this.onClickRestoreDefault}]},onClickRestoreDefault:function(){this.mainWindow.getMsgBox().confirm(_TT("SYNO.SDS.AV.Instance","config","restore_default"),SYNO.SDS.SecurityScan._V("securityscan","securityscan_restore_desc"),function(a){if("yes"===a){this.doRestoreDefault()}},this);return false},doRestoreDefault:function(){this.loadConfig()},onClickCommit:function(){this.doCommitSetting()},isGroupDirty:function(){return this.originalScanGroup!==this.getForm().findField("scanGroup").getGroupValue()},isScheduleDirty:function(){return this.getForm().findField("enableSchedule").isDirty()||this.getForm().findField("weekday").isDirty()||this.getForm().findField("hour").isDirty()||this.getForm().findField("minute").isDirty()},isDirty:function(){return this.isGroupDirty()||this.isScheduleDirty()},doCommitSetting:function(){var b={};var c={};var a=false;if(!this.getForm().isValid()){this.mainWindow.getMsgBox().alert("securityscan",_T("error",_T("common","forminvalid")));return}if(this.isGroupDirty()){c.argGroup=this.getForm().findField("scanGroup").getGroupValue();a=true}if(this.isScheduleDirty()){c.enableSchedule=this.getForm().findField("enableSchedule").getValue();c.weekday=this.getForm().findField("weekday").getValue();c.hour=this.getForm().findField("hour").getValue();c.minute=this.getForm().findField("minute").getValue();c.scheduleTaskId=this.scheduleTaskId;a=true}if(!a){this.mainWindow.getMsgBox().alert("securityscan",_T("error","nochange_subject"));return}b.api="SYNO.Core.SecurityScan.Conf";b.method="set";b.version=1;b.params={Input:c};this.getEl().mask(_T("common","saving"));this.mainWindow.apiSend.call(this,b,function(d){this.getEl().unmask();this.form.setValues({scanGroup:this.getForm().findField("scanGroup").getGroupValue(),enableSchedule:this.getForm().findField("enableSchedule").getValue(),weekday:this.getForm().findField("weekday").getValue(),hour:this.getForm().findField("hour").getValue(),minute:this.getForm().findField("minute").getValue()});this.originalScanGroup=this.getForm().findField("scanGroup").getGroupValue();this.mainWindow.defGroup=this.originalScanGroup;if(d.scheduleTaskId){this.scheduleTaskId=d.scheduleTaskId}this.mainWindow.onStatusPolling("ALL");this.mainWindow.onSysStatusPolling()},function(d){this.getEl().unmask()})},loadConfig:function(){var a={};a.api="SYNO.Core.SecurityScan.Conf";a.method="get";a.version=1;a.params={};this.getEl().mask(_T("common","loading"));this.mainWindow.apiSend.call(this,a,function(b){this.scheduleTaskId=b.scheduleTaskId;this.originalScanGroup=b.defaultGroup;if(!b.weekday){b.weekday="1";b.hour=0;b.minute=0}this.form.setValues({scanGroup:b.defaultGroup,enableSchedule:b.enableSchedule,weekday:b.weekday,hour:b.hour,minute:b.minute});this.mainWindow.defGroup=b.defaultGroup;this.onScanGroupRatioClick(this.getForm().findField("scanGroup"),true);this.getEl().unmask()},function(b){this.getEl().unmask()})},onActivate:function(){var a;this.loadConfig();a=new SYNO.ux.Utils.EnableCheckGroup(this.getForm(),"enableSchedule",["weekday","hour","minute"])}});Ext.define("SYNO.SDS.SecurityScan.SettingsPanel.ListDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(a){this.module=a.module;this.owner=a.owner;this.ownerForm=a.ownerForm;this.parentObj=a.parentObj;var b=this.fillConfig(a);this.callParent([b])},fillConfig:function(a){this.group=a.group;this.mainWindow=SYNO.SDS.SecurityScan.Window;this.customListStore=this.createStore();this.gridPanel=this.createCategoryObj();var b={width:620,height:500,resizable:false,title:a.title,items:[this.gridPanel]};if("custom"==this.group){b.buttons=[{btnStyle:"blue",text:SYNO.SDS.SecurityScan._V("common","save"),id:this.customListSaveID=Ext.id(),itemId:"customListSave",scope:this,disabled:_S("demo_mode"),handler:this.customListSave},{btnStyle:"grey",text:_T("common","alt_cancel"),scope:this,handler:this.oncancel}]}else{b.buttons=[{btnStyle:"grey",text:_T("common","alt_close"),scope:this,handler:this.oncancel}]}Ext.apply(b,a);return b},createStore:function(){var b=this.mainWindow.allItemsStoreField;b.push("enabled");var a=new Ext.data.JsonStore({sortInfo:{field:"category",direction:"ASC"},proxy:new Ext.data.MemoryProxy([]),fields:b});return a},createCategoryObj:function(){var d=this.group;var b="custom"===d?false:true;this.enableColumn=new SYNO.ux.EnableColumn({header:_T("common","enabled"),dataIndex:"enabled",disableSelectAll:b,menuDisabled:true,sortable:true,width:50,align:"center",tooltip:_T("common","enabled"),isIgnore:function(g,f){return"custom"!==d},renderer:function(h,g,f){return SYNO.ux.EnableColumn.prototype.renderer(h,g,f)}});var c=[this.enableColumn,{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_category"),dataIndex:"category",hideable:false,width:50,sortable:true,renderer:function(k,h,j,g,i,f){k=SYNO.SDS.SecurityScan._V("securityscan","securityscan_category_"+k);return this.tplAdd(k,k)},scope:this},{header:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_desc"),dataIndex:"strId",sortable:true,renderer:function(k,h,j,g,i,f){if("pass"===j.get("status")){k=this.mainWindow.getStringKeyVal(k,"desc_good")}else{if("running"===j.get("status")){k=this.mainWindow.getStringKeyVal(k,"desc_running")}else{k=this.mainWindow.getStringKeyVal(k,"desc_bad")}}return this.tplAdd(k,k)},scope:this,width:200}];var e=new Ext.Toolbar({defaultType:"syno_button",items:[{text:_T("securityscan","view"),itemId:"view",id:this.viewBtnID=Ext.id(),disabled:true,tooltip:_T("securityscan","view"),scope:this,handler:function(g,f){this.openDetailDialog()}}]});var a=new SYNO.ux.GridPanel({tbar:e,title:"SYNO.ux.GridPanel",plugins:[this.enableColumn],store:this.customListStore,columns:c,height:425,listeners:{rowclick:function(f,h,g){Ext.getCmp(this.viewBtnID).enable()},rowdblclick:function(f,g){this.openDetailDialog()},scope:this}});return a},valBeauty:function(c,b){if(""===c){return c}if("status"===b){var a='<div class="securityscan-result securityscan-result-{0}"></div>';if("nonChecked"===c){c='<div style="text-align: center; font-size: 20px;"><font class="blue-status">-</font></div>'}else{if("skip"===c){c='<div style="text-align: center; "><font class="orange-status">'+SYNO.SDS.SecurityScan._V("securityscan","securityscan_result_skip")+"</div>"}else{c=String.format(a,c)}}}return c},customListSave:function(){var a="";var b={};var c={};var d=true;this.customListStore.each(function(e){if(e.data.enabled){d=false}});if(d){this.getMsgBox().alert("securityscan",SYNO.SDS.SecurityScan._V("securityscan","securityscan_alert_non_items"));return}if(!this.isStoreChanged()){this.close()}this.customListStore.each(function(e){if(e.data.enabled){a+=" "+e.data.id}});c.items=a;b.api="SYNO.Core.SecurityScan.Conf";b.method="group_set";b.version=1;b.params=c;this.getEl().mask(_T("common","saving"));this.mainWindow.apiSend.call(this,b,function(e){this.ownerForm.setValues({scanGroup:"custom"});this.parentObj.originalScanGroup="custom";this.mainWindow.defGroup="custom";this.mainWindow.onStatusPolling("ALL");this.mainWindow.onSysStatusPolling();this.getEl().unmask(_T("common","saving"));this.close()},function(e){this.getEl().unmask()})},isStoreChanged:function(){if(0<this.customListStore.getModifiedRecords().length){return true}else{return false}},tplAdd:function(b,a){return"<div ext:qtip='"+b+"'>"+a+"</div>"},oncancel:function(){if(!this.isStoreChanged()||"custom"!=this.group){this.close()}else{this.getMsgBox().confirm("securityscan",_T("common","confirm_lostchange"),function(a){if("yes"===a){this.close()}},this);return false}},openDetailDialog:function(){var a=new SYNO.SDS.SecurityScan.ResultPanel.DetailDialog({module:this.module,owner:this.owner,seletedItem:this.gridPanel.getSelectionModel().getSelected().data});a.open()},onStoreLoadDone:function(a){if(""===a[this.mainWindow.respDataRoot]){this.customListStore.loadData([],false);return}this.customListStore.loadData(a[this.mainWindow.respDataRoot],false)},onOpen:function(){var a={};a.api="SYNO.Core.SecurityScan.Conf";a.method="group_enum";a.version=1;a.params={argGroup:this.group};this.getEl().mask(_T("common","loading"));this.mainWindow.apiSend.call(this,a,function(b){this.getEl().unmask();this.onStoreLoadDone(b)},function(b){this.getEl().unmask()});this.callParent(arguments)}});Ext.define("SYNO.SDS.SecurityScan.ResultPanel.DetailDialog",{extend:"SYNO.SDS.ModalWindow",constructor:function(b){this.module=b.module;this.owner=b.owner;this.mainWindow=SYNO.SDS.SecurityScan.Window;this.data=b.seletedItem;this.panel=this.createPanel();this.form=this.panel.getForm();var a={loadMask:true,width:620,height:500,resizable:true,title:SYNO.SDS.SecurityScan._V("securityscan","securityscan_report_title"),items:[this.panel],buttons:[{text:_T("common","alt_close"),scope:this,handler:this.close}]};Ext.apply(a,b);this.callParent([a])},createPanel:function(){var d=this.data.status==="pass"?this.mainWindow.getStringKeyVal(this.data.strId,"desc_good"):this.mainWindow.getStringKeyVal(this.data.strId,"desc_bad");var g={xtype:"syno_fieldset",title:SYNO.SDS.SecurityScan._V("securityscan","ecurityscan_desc_titile"),collapsible:false,items:[{xtype:"syno_displayfield",fieldLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_level"),scope:this,value:SYNO.SDS.SecurityScan._V("securityscan","securityscan_severity_"+this.data.severity)},{xtype:"syno_displayfield",fieldLabel:SYNO.SDS.SecurityScan._V("securityscan","securityscan_label_desc"),scope:this,value:d,htmlEncode:false}]};var f={xtype:"syno_fieldset",title:SYNO.SDS.SecurityScan._V("securityscan","securityscan_detail_purpose"),collapsible:false,items:[{xtype:"syno_displayfield",scope:this,value:this.mainWindow.getStringKeyVal(this.data.strId,"purpose"),htmlEncode:false}]};var e=[{xtype:"syno_displayfield",scope:this,value:this.actionStrGet(),htmlEncode:false}];e.push(this.actionMethodGet());var c={xtype:"syno_fieldset",title:SYNO.SDS.SecurityScan._V("securityscan","securityscan_setting_action_title"),collapsible:false,items:e};var b=[g,f];if("fail"===this.data.status){b.push(c)}var a={border:false,width:590,height:420,items:b};return new SYNO.ux.FormPanel(a)},actionStrGet:function(){if(!this.data.action||""===this.data.action||!this.data.action.actionKey){return""}var a,e,f,b,d;var c=/_T\([\"\' ]+(\w+)[\"\' ]+[, ]+[\"\' ]+(\w+)[\"\' ]+\)/g;var g=this.mainWindow.getStringKeyVal(this.data.strId,this.data.action.actionKey);for(var h in this.data.action.actionVar){if(this.data.action.actionVar.hasOwnProperty(h)){d=this.data.action.actionVar[h];e=d;while((a=c.exec(d))){if(3!==a.length){continue}f=a[1];b=a[2];e=e.replace(a[0],_T(f,b))}e='<font class="securityscan-severity-font-highlight">'+e+"</font>";var i=new RegExp(h,"g");g=g.replace(i,e)}}return g},actionMethodGet:function(){var b;var f=this.data.method.methodAction;if(!this.data.method){return""}if("link"===f){var d,j,k;var i=this.data.method.methodActionVal;i=i.split(":");var e=i[0];var c=i[1];var a=this.data.method.methodLinkOpenAppStr;var h=function(){};if(!a){d="tree";j="leaf_control_panel"}else{d=a.split(":")[0];j=a.split(":")[1]}if(2<i.length){var g=i[2];b='<a id="'+Ext.id()+'" class="link-font" href="#">'+_T(d,j)+"</a>";h=function(l){l.preventDefault();SYNO.SDS.AppLaunch(e,{fn:c,tab:g})}}else{b='<a id="'+Ext.id()+'" class="link-font" href="#">'+_T(d,j)+"</a>";h=function(l){l.preventDefault();SYNO.SDS.AppLaunch(e,{fn:c})}}k=String.format(SYNO.SDS.SecurityScan._V("securityscan","securityscan_setting_link"),b);return[{xtype:"syno_displayfield",scope:this,value:k,htmlEncode:false,listeners:{afterRender:function(m){var l=m.el.first("a");if(l){l.addListener("click",h)}}}}]}else{if("fixme"===f){return[{xtype:"syno_button",text:SYNO.SDS.SecurityScan._V("securityscan","securityscan_btn_fixme"),id:this.fixmeBtnID=Ext.id(),scope:this,disabled:_S("demo_mode"),handler:this.doFixmeItem}]}}},doFixmeItem:function(){this.getEl().mask(_T("common","loading"));this.mainWindow.doScan("fixme",this.data.id);this.close()}});Ext.ns("SYNO.SDS.SecurityScan");Ext.define("SYNO.SDS.SecurityScan.Instance",{extend:"SYNO.SDS.AppInstance",appWindowName:"SYNO.SDS.SecurityScan.MainWindow"});SYNO.SDS.SecurityScan._V=function(b,a){if("rules"===b){return _TT("SYNO.SDS.SecurityScan.Instance",b,a)}else{return _T(b,a)}};Ext.define("SYNO.SDS.SecurityScan.MainWindow",{extend:"SYNO.SDS.PageListAppWindow",width:990,height:570,skipDirtyCheck:false,respDataRoot:"items",sysNeedUpdate:true,lastScanTime:"",sysStatusRunning:false,pollingEnabled:true,maxAlramSeverity:"",resultFilterID:"",resultFilterKey:"ALL",defGroup:"",showStatus:["pass","fail","error","running"],specialRulesStoreField:["id","exist","isFail","actionExtra"],sysStatusStoreField:["category","progress","total","failSeverity","fail","runningItem"],allItemsStoreField:["id","method","severity","category","status","action","update","strId","severitySort"],totalCategories:["malware","systemCheck","userInfo","network","update"],severitySort:{danger:0,risk:1,warning:2,outOfDate:3,info:4},activePage:"SYNO.SDS.SecurityScan.OverviewPanel",constructor:function(a){this.app=a.appWin;SYNO.SDS.SecurityScan.Window=this;this.specialRulesStore=new Ext.data.JsonStore({proxy:new Ext.data.MemoryProxy([]),fields:this.specialRulesStoreField,data:[{id:"ruleDB.Update.DSM.check_latest_dsm",exist:false,isFail:false,actionExtra:""},{id:"ruleDB.Update.Package.check_latest_pkg",exist:false,isFail:false,actionExtra:""},{id:"ruleDB.User.Password.top50000StrengthCheck",exist:false,isFail:false,actionExtra:""}]});this.sysStatusStore=new Ext.data.JsonStore({proxy:new Ext.data.MemoryProxy([]),fields:this.sysStatusStoreField});this.allItemsStore=new Ext.data.JsonStore({sortInfo:{field:"status",direction:"ASC"},proxy:new Ext.data.MemoryProxy([]),fields:this.allItemsStoreField});var b=[{iconCls:"icon-securityscan-overview",text:SYNO.SDS.SecurityScan._V("helptoc","securityscan_overview_name"),fn:"SYNO.SDS.SecurityScan.OverviewPanel",help:"SecurityScan/securityscan_overview.html"},{iconCls:"icon-securityscan-result",text:SYNO.SDS.SecurityScan._V("helptoc","securityscan_result_name"),fn:"SYNO.SDS.SecurityScan.ResultPanel",help:"SecurityScan/securityscan_result.html"},{iconCls:"icon-securityscan-settings",text:SYNO.SDS.SecurityScan._V("common","advanced"),fn:"SYNO.SDS.SecurityScan.SettingsPanel",disabled:"recovery_site"===_S("systemdr_role"),help:"SecurityScan/securityscan_advanced.html"}];var c={cls:"syno-app-securityscan",width:this.width,height:this.height,minWidth:this.width,minHeight:this.height,resizable:false,listItems:b,listeners:{scope:this,beforeDestroy:function(){if(SYNO.SDS.SecurityScan.Window){delete SYNO.SDS.SecurityScan.Window}}}};return this.callParent([Ext.apply(c,a)])},onOpen:function(){this.timeDelayGet();this.callParent(arguments);this.sysStatusStore.loadData([],false);this.firstScanCheck()},firstScanCheck:function(){var a={};a.api="SYNO.Core.SecurityScan.Conf";a.method="first_get";a.version=1;a.params={};this.firstQuery=true;this.getEl().mask(_T("common","loading"));this.apiSend.call(this,a,function(b){if(b.firstScan){var c=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");c.openFirstScanDialog()}else{this.onStatusPolling("ALL");this.onSysStatusPolling();if(b.iscrack){this.getMsgBox().alert("securityScan_error",_T("securityscan","framwork_modified_error"))}}})},getResultData:function(){return this.allItemsStore},onLoadResultDone:function(g){var c,e,f;var j,a;var h,b,d;for(j in g){if(g.hasOwnProperty(j)){h=this.specialRulesStore.find("id",g[j].id);if(0<=h){b=this.specialRulesStore.getAt(h);b.beginEdit();b.set("exist",true);b.set("isFail","fail"===g[j].status);if(g[j].action&&g[j].action.actionExtra){b.set("actionExtra",g[j].action.actionExtra)}b.endEdit()}c=this.allItemsStore.getById(g[j].id);if(c){c.beginEdit();for(f=0;f<this.allItemsStoreField.length;f++){e=this.allItemsStoreField[f];if(g[j][e]){c.set(e,g[j][e])}}c.data.severitySort=this.severitySort[g[j].severity];c.endEdit()}else{a=new Ext.data.Record(g[j]);a.id=a.data.id;a.data.severitySort=this.severitySort[g[j].severity];this.allItemsStore.addSorted(a)}}}d=String.format("{0}_{1}",this.resultFilterID,this.resultFilterKey);this.storeFilter(d)},apiSend:function(a,d,c){var b=function(f){var e=null;if(f&&c){c.apply(this,[f])}else{this.onStatusPolling("ALL");this.onSysStatusPolling()}if(this.getMsgBox){e=this.getMsgBox()}else{if(this.owner&&this.owner.getMsgBox){e=this.owner.getMsgBox()}else{return}}if(f&&f.errinfo&&f.errinfo.sec&&f.errinfo.key){e.alert("securityscan",SYNO.SDS.SecurityScan._V(f.errinfo.sec,f.errinfo.key))}else{e.alert("securityscan",SYNO.SDS.SecurityScan._V("error","error_error_system"))}};a.scope=this;a.callback=function(g,f,e){if(g&&f.success){d.apply(this,[f])}else{b.apply(this,[f])}};this.sendWebAPI(a)},onSysStatusPolling:function(){var a={};var b=[];var c=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");a.api="SYNO.Core.SecurityScan.Status";a.method="system_get";a.version=1;a.params={};if(!this.pollingEnabled){return}if(!this.firstQuery&&!this.sysStatusRunning){c.sysStatusSet("running");this.sysStatusRunning=true;this.sysStatusStore.loadData([],false)}this.apiSend.call(this,a,function(g){var e={};if(this.firstQuery&&this.getEl&&this.getEl().isMasked&&this.getEl().isMasked()){this.firstQuery=false;this.getEl().unmask()}if(!this.sysNeedUpdate||!c){return}c.sysStatusSet(g.sysStatus,g.sysProgress);this.lastScanTime=g.lastScanTime;if(!g[this.respDataRoot]){this.sysStatusStore.loadData([],false);this.getMsgBox().alert("TTT_securityScan_error",_T("error","error_error_system"))}else{if(!c.getScanningTime()){c.setScanningTime(g.startTime)}c.maxAlramSeveritySet(g.maxAlarmSeverity);e=g[this.respDataRoot];for(var f in e){if(e.hasOwnProperty(f)){b.push(e[f])}}this.sysStatusStore.loadData(b,false)}if(c.isRunningStatus(g.sysStatus)){var d=this;setTimeout(function(){d.onSysStatusPolling()},2000)}else{this.sysStatusRunning=false}},function(){if(this.getEl&&this.getEl().isMasked&&this.getEl().isMasked()){this.getEl().unmask()}})},onStatusPolling:function(a){var b={};b.api="SYNO.Core.SecurityScan.Status";b.method="rule_get";b.version=1;b.params={items:a};if(!this.pollingEnabled){return}if("ALL"===a){this.specialRulesStore.each(function(c){c.set("exist",false)});this.allItemsStore.removeAll(false)}this.apiSend.call(this,b,function(g){var e={};var f;var c=[];if(!g.isUpdating){if(!g[this.respDataRoot]){this.onLoadResultDone({});return}e=g[this.respDataRoot];for(f in e){if(e.hasOwnProperty(f)){if("running"===e[f].status){c.push(e[f].id)}}}this.onLoadResultDone(e)}if(0<c.length){var d=this;setTimeout(function(){var h;h=c==="ALL"?"ALL":c.join(" ");d.onStatusPolling(h)},2000)}})},doScan:function(f,d){var c={};var g=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");if(!g){return}d=d.strip();c.api="SYNO.Core.SecurityScan.Operation";c.method=f;c.version=1;c.params={items:d};g.sysStatusSet("running");this.sysStatusStore.loadData([],false);g.overviewBtnSet(true);if("ALL"!==d){var a=d.split(" ");var e,b;for(b=0;b<a.length;b++){e=this.allItemsStore.find("id",a[b]);if(0<=e){this.allItemsStore.getAt(e).set("update","");this.allItemsStore.getAt(e).set("status","running")}}}this.apiSend.call(this,c,function(h){g.overviewBtnSet(false);this.onStatusPolling(c.params.items);this.onSysStatusPolling()},function(h){g.overviewBtnSet(false);this.onStatusPolling(c.params.items);this.onSysStatusPolling()})},doStartScan:function(a){var b={};var c=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");if(!c){return}if("ALL"===a){c.overviewBtnSet(true);c.sysStatusSet("updating");this.sysStatusStore.loadData([],false);b.api="SYNO.Core.SecurityScan.Operation";b.method="update";b.version=1;b.params={lang:_S("lang")};this.apiSend.call(this,b,function(d){if(d.lang){SYNO.SDS.Strings["SYNO.SDS.SecurityScan.Instance"].rules=d.lang.rules}this.doScan("start","ALL")},function(d){this.doScan("start","ALL")})}else{this.doScan("start",a)}},doStopScan:function(a){var b={};var c=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");if(!c){return}b.api="SYNO.Core.SecurityScan.Operation";b.method="stop";b.version=1;b.params={items:a};c.sysStatusSet("stopping");this.pollingEnabled=false;this.sysNeedUpdate=false;c.overviewBtnSet(true);c.overviewStatusAreaSet();this.apiSend.call(this,b,function(d){this.sysNeedUpdate=true;this.pollingEnabled=true;this.onSysStatusPolling();this.onStatusPolling("ALL");c.overviewBtnSet(false)})},onClose:function(){var a=this.pageCt.getComponent("SYNO.SDS.SecurityScan.OverviewPanel");this.pollingEnabled=false;a.stopIconAnimate("");a.stopOverviewStatusElapsedTime(true)},getStringKeyVal:function(c,a){var b=c+"_"+a;return Ext.util.Format.htmlEncode(SYNO.SDS.SecurityScan._V("rules",b))},specialRuleRecordCheck:function(d,c){var a,b;a=this.specialRulesStore.find("id",d);if(0<=a){b=this.specialRulesStore.getAt(a);if(c){if(b.get("exist")){return b}else{return false}}return b}return false},onBeforeSelect:function(b,c,d){var a;if(!this.skipDirtyCheck){if(d&&d.leaf){a=this.pageCt.getComponent(d.attributes.fn);if(a&&Ext.isFunction(a.isDirty)&&a.isDirty()){this.getMsgBox().confirm("TTT_SecuityScan",_T("common","confirm_lostchange"),function(e){if("yes"===e){this.skipDirtyCheck=true;this.selectPage(c.attributes.fn);this.skipDirtyCheck=false}},this);return false}}}return this.callParent(arguments)},timeDelayGet:function(){var b={};b.api="SYNO.Core.SecurityScan.Conf";b.method="time_get";b.version=1;b.params={};var a=new Date();this.apiSend.call(this,b,function(c){this.timeDelay=a.getTime()/1000-c.curTime})},diffSecsGet:function(c){var a=new Date();var b=Date.UTC(a.getUTCFullYear(),a.getUTCMonth(),a.getUTCDate(),a.getUTCHours(),a.getUTCMinutes(),a.getUTCSeconds());b/=1000;if(this.timeDelay){return parseInt(b-c-this.timeDelay,10)}else{return parseInt(b-c,10)}},timeRender:function(c,a){if(!c||isNaN(c)){return""}var b=0;var d=this.diffSecsGet(c);var j=" "+SYNO.SDS.SecurityScan._V("securityscan","securityscan_second");var g=" "+SYNO.SDS.SecurityScan._V("securityscan","securityscan_minute");var e=" "+SYNO.SDS.SecurityScan._V("securityscan","securityscan_hour");var l=" "+SYNO.SDS.SecurityScan._V("securityscan","securityscan_day");var h=[{val:1,limit:60,str:j},{val:0,limit:60,str:g},{val:0,limit:24,str:e},{val:0,str:l}];for(var m=0;m<h.length;m++){if(0<d){if(h[m].limit){h[m].val=d%h[m].limit;d/=h[m].limit;d=parseInt(d,10);b=m}else{h[m].val=d;b=m;break}}}if(a){return h[b].val+h[b].str}else{var f="";for(var k=b;k>=0;k--){f+=h[k].val+h[k].str+" "}return f}},storeFilter:function(b){var a="",c;if(this.resultFilterID+"_ALL"===b){this.allItemsStore.clearFilter(false);this.allItemsStore.filterBy(function(d,e){if(0>this.showStatus.indexOf(d.get("status"))){return false}else{return true}},this)}else{a="category";c=b.split("_")[1];this.resultFilterKey=c;this.allItemsStore.filterBy(function(d,e){if(0<=this.showStatus.indexOf(d.get("status"))&&c===d.get(a)){return true}else{return false}},this)}this.allItemsStore.sort("severitySort","ASC");this.allItemsStore.sort("status","ASC")}});