#!/usr/bin/python
#! coding: utf-8
# Copyright (c) 2000-2014 Synology Inc. All rights reserved.

from utils import *
import sys
sys.path.append('/var/dynlib/securityscan/dbutils')
from dbutils import *

class RuleDictResult(DictResult):
    _non_comp_version = [DEFAULT_NON_COMP_VERSION]
    _group = [GROUP_HOME, GROUP_COMPANY]
    _category = CATEGORY_SYSTEM_CHECK
    _severity = LEVEL_WARNING
    _strId = 'rule_optware_check_v2'

    """ please implement the following functions """
    def getStatus(self):
        ret = self.RunCRoutine("OptWareScan")
        self._pass_ = ret["status"] == "success"
        self._vars_ = ret["var"]

        return StrMap[ret["status"]]
    def getMethod(self):
        method = {
            METHOD_ACTION: METHOD_ACTION_LINK,
            METHOD_ACTION_VAL: 'SYNO.SDS.SupportForm.Application:SYNO.SDS.SupportForm.Application',
            METHOD_LINK_APP_STR: 'helptoc:support_center'
        }
        return method
    def getAction(self):
        if self._pass_:
            return {}
        else:
            action = {
                ACTION_STR_KEY : 'action',
                ACTION_REPLACE_VAR : self._vars_
            }
            return action

