#!/bin/sh

SZF_SSDP_LOCK="/tmp/syno_minissdp.lock"

case $1 in
	--sdk-mod-ver)
	#Print SDK support version
	echo "1.0";
	;;
	--name)
	#Print package name
	echo "SynoSSDP";
	;;
	--pkg-ver)
	#Print package version
	echo "1.0";
	;;
	--vendor)
	#Print package vendor
	echo "Synology";
	;;
	--post)
	(
	if flock -n -x 8; then
		/usr/syno/etc/rc.d/S98ssdpd.sh stop
		# avoid exec many times when encounter series net interface change event
		sleep 5
		/usr/syno/etc/rc.d/S98ssdpd.sh start
		flock -u 8
		rm ${SZF_SSDP_LOCK}
	fi
	)8> ${SZF_SSDP_LOCK}
	;;
	*)
	echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

