#!/bin/sh
# Copyright (c) 2010 Synology Inc. All rights reserved.

SYNOACLTOOL=/usr/syno/bin/synoacltool
SYNOACLOPT=-set-eadir-acl
SQLITE_BIN=/usr/syno/bin/sqlite3
SQLITE_SCHEMA_PATH=/usr/syno/etc.defaults/fileindex.sql
EADIR_NAME="@eaDir"
FI_DB_NAME="SYNO@.fileindexdb"

#Enumerate all shared that are file-indexed.
FindIndexEnableShareList(){
	SHARE_LIST=`synoshare --enum ALL | awk 'NR>2{print $0}'`
	FLAG_FILE_INDEX=0x40
	FLAG_SHARE_DISABLE=0x01
	ORI_IFS=$IFS
	IFS=$'\n'
 	for shared in ${SHARE_LIST}
        do
		SHARE_STATUS=`synoshare --get "$shared" | grep 'Status .....' | sed 's/^.*\[\(.*\)\]/\1/'`;
		FILE_INDEXED=$(($SHARE_STATUS & $FLAG_FILE_INDEX));
		if [ $FILE_INDEXED -gt 0 ]; then
			FI_SHARE_LIST="$FI_SHARE_LIST
$shared"
		fi
	done
	IFS=$ORI_IFS
}

UpgradeFileIndexDB(){
	FI_SHARE_LIST=""

	FindIndexEnableShareList;

	ORI_IFS=$IFS
	IFS=$'\n'
	for shared in ${FI_SHARE_LIST}
	do
        	IS_EXTERNAL_DISK=0;
        	SHARE_PATH=`synoshare --get "$shared" | grep 'Path .....' | sed 's/^.*\[\(.*\)\]/\1/'`;
		SHARE_NAME=`echo ${SHARE_PATH} | sed 's/^\/.*\/\(.*\)/\1/'`
        	VOL_PATH=`echo "$SHARE_PATH" | sed 's/\(^\/.*\)\/.*/\1/'`;
		IS_USB_VOL=`echo "$VOL_PATH" | grep "volumeUSB"`
		IS_SATA_VOL=`echo "$VOL_PATH" | grep "volumeSATA"`
        	if [ -n "${IS_USB_VOL}" ] || [ -n "${IS_SATA_VOL}" ]; then
                	IS_EXTERNAL_DISK=1;
        	fi

        	if [ "$IS_EXTERNAL_DISK" = "0" ]; then
                	#is interal disk
			SHAREEA="${VOL_PATH}/${EADIR_NAME}"
                	SHARE_EADIR="${SHAREEA}/${SHARE_NAME}"
                	DB_PATH="${SHARE_EADIR}/${FI_DB_NAME}"
                	if [ ! -d "$SHARE_EADIR" ]; then
                        	mkdir -p "$SHARE_EADIR";
				chmod 777 "$SHAREEA"
				$SYNOACLTOOL $SYNOACLOPT "$SHAREEA"
				chmod 777 "$SHARE_EADIR";
                        	$SQLITE_BIN "$DB_PATH" < "$SQLITE_SCHEMA_PATH";
				chmod 777 "$DB_PATH";
                	fi

			#For Upgrade
                	#/usr/syno/fileindex/sql/sql.sh "$DB_PATH";
        	fi
	done
	IFS=$ORI_IFS
}

case $1 in
	start)
		FileIndexSupport=`/bin/get_key_value /etc.defaults/synoinfo.conf supportfileindex`
		case "$FileIndexSupport" in
		[Yy][Ee][Ss])
			UpgradeFileIndexDB;
			echo "Starting Synology File Indexing Daemon ..."
			/usr/syno/sbin/fileindexd
			;;
		*)
			echo "No related services are supported. Skip..."
			;;
		esac
	;;
	stop)
		echo "Stopping Synology Indexing Daemon ..."
		killall fileindexd > /dev/null 2>&1
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
	;;
esac

