#!/bin/sh
# Copyright (c) 2000-2008 Synology Inc. All rights reserved.

. /etc.defaults/rc.subr

LinuxVersionCode=$(KernelVersionCode $(KernelVersion))
ProcName="nfsd"
PidFile="/var/run/${ProcName}.pid"
RM="/bin/rm"
TOUCH="/bin/touch"

# for version 2.4
if [ $LinuxVersionCode -lt $(KernelVersionCode "2.6") ]; then
		KERNELMODULE="nfsd"
else
		Unique=`/bin/get_key_value /etc.defaults/synoinfo.conf unique`
		# rpcsec_gss_krb5 module is built-in in kernel 2.6.32
		if [ $LinuxVersionCode -ne $(KernelVersionCode "2.6.32") ]; then
			KERNELMODULEV4="rpcsec_gss_krb5"
		fi
		KERNELMODULE="${KERNELMODULEV4} exportfs nfsd"
fi

case $1 in
	start)
		Support=`/bin/get_key_value /etc.defaults/synoinfo.conf supportNFS`
		case "$Support" in
		[Yy][Ee][Ss])
			;;
		*)
			echo "NFS server is not supported. Skip..."
			exit
			;;
		esac

		Enable=`/bin/get_key_value /etc/synoinfo.conf runnfs`
		case "$Enable" in
		[Yy][Ee][Ss])
			;;
		*)
			echo "NFS server is not enabled. Skip..."
			exit
			;;
		esac

		echo "Starting NFS server..."

		N=`cat /proc/meminfo | grep MemTotal: | awk '{ m = ($2 / 1024 / 128) ; print int(m) +1;}'`

		SYNOLoadModules $KERNELMODULE
		/bin/mount -t nfsd none /proc/fs/nfsd

		/usr/sbin/exportfs -r >/dev/null 2>&1
		/sbin/rpcbind
		/bin/mkdir -p /var/lib/nfs/v4recovery
		/usr/sbin/nfsd $N
		/bin/mkdir -p /var/lib/nfs/sm
		/usr/sbin/mountd -p 892
		/usr/sbin/statd

		if [ -f $PidFile ]; then
			$RM $PidFile
		fi

		$TOUCH $PidFile
		echo `pidof $ProcName | awk '{print $NF}'` > $PidFile
	;;
	stop)
		killall -9 statd
		killall -9 mountd
		/bin/rm -rf /var/lib/nfs/sm
		killall -9 nfsd
		killall -9 rpcbind
		retryCount=0
		while [ $retryCount -le 10 ]
		do
			if ! pidof mountd && ! pidof statd && ! pidof nfsd && ! pidof rpcbind; then
				break;
			fi &> /dev/null
			sleep 1
			retryCount=`expr $retryCount + 1`
		done
		/bin/rm -rf /var/lib/nfs/v4recovery
		/usr/sbin/exportfs -au >/dev/null 2>&1

		/bin/umount /proc/fs/nfsd
		SYNOUnloadModules $KERNELMODULE

		$RM $PidFile
	;;
	status)
		if pidof mountd && pidof statd && pidof rpcbind && pidof nfsd; then
			if [ -f $PidFile ]; then
				pid=`cat $PidFile`
				if [ 0 != `ps | grep $ProcName | grep $pid | wc -l` ]; then
					return $LSB_STAT_RUNNING
				else
					return $LSB_STAT_DEAD_FPID
				fi
			fi
			return $LSB_STAT_RUNNING
		else
			if [ -f $PidFile ]; then
				return $LSB_STAT_DEAD_FPID
			else
				return $LSB_STAT_NOT_RUNNING
			fi
		fi &> /dev/null
	;;
	restart)
		$0 stop
		sleep 1
		$0 start
	;;
	*)
	echo "Usages: $0 [start|stop|restart|status]"
	;;
esac

