#!/bin/sh

###############################################################
#   This script should be hooked when invoking SYNOShareDelete()
#   Usable environment variable:
#       NITEMS, SHARE_NAME_X, SHARE_PATH_X, SHARE_SSTATUS_X
###############################################################

#Include common scripts
SYNOBACKUP_INC_SCRP=/usr/libexec/BackupCommon.sh
. ${SYNOBACKUP_INC_SCRP}

#At begining, acquire package settings
case $1 in
    --sdk-mod-ver)
	    #Print SDK support version
        echo ${SYNOBACKUP_PKG_MODVER};
    ;;
    --name)
        #Print package name
        echo ${SYNOBACKUP_PKG_NAME};
    ;;
    --pkg-ver)
        #Print package version
        echo ${SYNOBACKUP_PKG_VERSION};
    ;;
    --vendor)
        #Print package vendor
        echo ${SYNOBACKUP_PKG_VENDOR};
    ;;
    --pre)
        #Actions before share set
    ;;
    --post)
        #Actions after share set
        CNT=1;

        #Check if service share
        while [ "${CNT}" -le "${NITEMS}" ]
        do
            if [ "${CNT}" = "${NITEMS}" ] ; then
                eval "TMP_SHARE_NAME=\$SHARE_NAME_${CNT}"
            else 
                eval "TMP_SHARE_NAME=\$SHARE_NAME_${CNT},"
            fi

            DEL_SHARES=${DEL_SHARES}${TMP_SHARE_NAME}
            CNT=$((CNT + 1))
        done
        RESULT_END=`${BIN_BACKUP_SHARE_DELETE} "${DEL_SHARES}" ${NITEMS}`
    ;;
    *)
        echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post"
    ;;
esac

