#!/bin/sh
# Copyright (c) 2000-2006 Synology Inc. All rights reserved.

Httpd="/usr/syno/apache/bin/httpd"
HttpdConf="/usr/syno/apache/conf/httpd.conf"
HttpdSSLConf="/usr/syno/apache/conf/extra/httpd-ssl.conf"
HttpdSSLConfCommon="/usr/syno/apache/conf/extra/httpd-ssl.conf-common"
PHPINI="/usr/syno/etc/php.ini"
SynoConf="/etc/synoinfo.conf"
SynoDefConf="/etc.defaults/synoinfo.conf"
PIDFILE="/var/run/httpd-user.pid"
SZD_MailStation="/var/packages/MailStation"
SZD_PhotoStation="/var/packages/PhotoStation"
SZD_RoundCube="${SZD_MailStation}/target/roundcubemail"
SZF_PHPINI="/usr/syno/etc/php.ini"
SZF_USR_SETTING_INI="/usr/syno/etc/php/user-setting.ini"
INTERCRT="/usr/syno/etc/ssl/ssl.intercrt/server-ca.crt"

SupportWeb=`/bin/get_key_value /etc.defaults/synoinfo.conf supportweb`
RunWebHTTPS=`/bin/get_key_value /etc/synoinfo.conf runWebHTTPS`
HttpPort=`/bin/get_key_value /etc/synoinfo.conf httpport`
RunWeb=`/bin/get_key_value /etc/synoinfo.conf runweb`
RunWebLocal=`/bin/get_key_value /etc/synoinfo.conf supportweblocaluser`

. /etc.defaults/rc.subr

if [  -f "${SZD_MailStation}/enabled" ]; then
	WebmailEnabled="yes"
fi
if [  -f "${SZD_PhotoStation}/enabled" ]; then
	RunPhoto="yes"
fi

BIN_RELAYD="/usr/syno/sbin/synorelayd"
UpdateRelayd()
{
	local relayd_arg=

	/usr/syno/etc/rc.d/S13synorelayd.sh status
	if [ $? -ne $LSB_STAT_RUNNING ] ; then
	    return
	fi

	case "$RunWebHTTPS" in
		"no")
		relayd_arg="$relayd_arg --remove photo_https"
		;;
		"yes")
		if $BIN_RELAYD -S | grep '"photo_http"' >/dev/null; then
			relayd_arg="$relayd_arg --add photo_https"
		fi
		;;
	esac

	if [ -z "$relayd_arg" ]; then
		relayd_arg="--hup"
	fi

	$BIN_RELAYD $relayd_arg
	return 0
	# ignore relayd return value.
	# when relayd is not running, hup will return false
}

GenerateConf()
{
	cp ${HttpdConf}-user ${HttpdConf}
	cp ${HttpdSSLConf}-user ${HttpdSSLConf}
	if [ "$HttpPort" != "80" ]; then
		echo "Listen $HttpPort" >> ${HttpdConf}
		echo "<VirtualHost *:$HttpPort>" >> ${HttpdConf}
		echo "Include /usr/syno/etc/sites-enabled-user/*.conf" >> ${HttpdConf}
		echo "</VirtualHost>" >> ${HttpdConf}
	fi
	if [ "$SupportWeb" = "yes" -a "$RunWeb" = "yes" ]; then
		echo "Include /usr/syno/etc/httpd-vhost.conf-user" >> ${HttpdConf}
		echo "DocumentRoot \"/var/services/web\"" >> ${HttpdConf}
		cat ${HttpdSSLConf} > ${HttpdSSLConf}.$$
		echo "Include /usr/syno/etc/httpd-ssl-vhost.conf-user" >> ${HttpdSSLConf}.$$
	else
		echo "DocumentRoot \"/usr/syno/synoman/phpsrc/web\"" >> ${HttpdConf}
		cat ${HttpdSSLConf} | sed 's/DocumentRoot "\/var\/services\/web"/DocumentRoot "\/usr\/syno\/synoman\/phpsrc\/web"/g' > ${HttpdSSLConf}.$$
	fi
	if [ "$SupportWeb" = "yes" -a "$RunWebLocal" = "yes" ]; then
		echo "Include /usr/syno/apache/conf/extra/httpd-userdir.conf-user" >> ${HttpdConf}
	fi

	if [ -s "${HttpdSSLConf}.$$" ]; then
		mv ${HttpdSSLConf}.$$ ${HttpdSSLConf}
	fi
	rm -f ${HttpdSSLConf}.$$ 2>/dev/null

	if [ -s ${HttpdSSLConfCommon} ]; then
		if [ -f $INTERCRT ]; then
			sed -e "/^#SSLCertificateChainFile/c\\SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCommon} > ${HttpdSSLConfCommon}.$$
		else
			sed -e "/^SSLCertificateChainFile/c\\#SSLCertificateChainFile /usr/syno/etc/ssl/ssl.intercrt/server-ca.crt" \
			${HttpdSSLConfCommon} > ${HttpdSSLConfCommon}.$$
		fi

		if [ -s "${HttpdSSLConfCommon}.$$" ]; then
			mv ${HttpdSSLConfCommon}.$$ ${HttpdSSLConfCommon}
		fi

		rm -f ${HttpdSSLConfCommon}.$$ 2>/dev/null
	fi

	if [ "x$WebmailEnabled" = "xyes" ]; then
		echo "AliasMatch ^/mail$ \"${SZD_RoundCube}/\"" >> ${HttpdConf}
		echo "Alias /mail/ \"${SZD_RoundCube}/\"" >> ${HttpdConf}
		open_basedir=`/bin/grep ^open_basedir ${SZF_USR_SETTING_INI} | cut -d'=' -f2`
		n="`expr length "$open_basedir"`"
		if [ $n -gt 1 ]; then
			open_basedir="${open_basedir}:${SZD_RoundCube}"
		fi
		# skip an error message
		open_basedir=`echo ${open_basedir}|sed 's,/source/busybox-1.1.0/synocmds/get_key_value.c (82) Buffer is too small:,,'`
		open_basedir=`echo ${open_basedir}|sed 's/:/\n/g'|sort -u|php -B '$lines=array();' -R 'array_push($lines,str_replace("\n", "", $argn));' -E 'echo join(":",$lines);'`
		sed "/^open_basedir/c\\open_basedir = ${open_basedir}" ${SZF_USR_SETTING_INI} > ${SZF_USR_SETTING_INI}.$$
		if [ -s "${SZF_USR_SETTING_INI}.$$" ]; then
			mv ${SZF_USR_SETTING_INI}.$$ ${SZF_USR_SETTING_INI}
		fi			
	fi
}

CheckPID()
{
	# check for pidfile
	if [ -f $PIDFILE ] ; then
		PID=`cat $PIDFILE`
		if [ "x$PID" != "x" ] && kill -0 $PID 2>/dev/null ; then
			STATUS="httpd (pid $PID) running"
			RUNNING=1
		else
			STATUS="httpd (pid $PID?) not running"
			RUNNING=0
		fi
	else
		STATUS="httpd (no pid file) not running"
		RUNNING=0
	fi
}

CheckPHPINI()
{
	Timezone=`/bin/get_key_value ${SynoConf} timezone`
	PHP_date_timezone=`/bin/get_key_value /usr/share/zoneinfo/Timezone/tzname ${Timezone}`
	PHP_APC_shmsize=`/bin/get_key_value ${PHPINI} apc.shm_size`
	APC_shmsize=`/bin/get_key_value ${SynoDefConf} php_cache_size`

	PHPINI_DEFAULT=/usr/syno/etc.defaults/php.ini
	# copy from default config if php.ini is empty or not exists.
	if [ ! -s ${PHPINI} ]; then
		/bin/cp ${PHPINI_DEFAULT} ${PHPINI}
	fi

	/bin/sed "s:^.*date.timezone =.*$:date.timezone = ${PHP_date_timezone}:g" ${PHPINI} > /tmp/php.ini.$$ 
	if [ "x$PHP_APC_shmsize" = "x0" ]; then
		/bin/sed /^apc.shm_size/c\\"apc.shm_size = ${APC_shmsize}" /tmp/php.ini.$$ > /tmp/php.ini.$$.tmp
		mv /tmp/php.ini.$$.tmp /tmp/php.ini.$$
	fi
	/bin/mv /tmp/php.ini.$$ ${PHPINI}.$$
	if [ -s ${PHPINI}.$$ ]; then
		/bin/mv ${PHPINI}.$$ ${PHPINI}
	else
		/bin/rm -f ${PHPINI}.$$
	fi
}
CheckPID
CheckPHPINI

case $1 in
[Ss][Tt][Oo][Pp])
	APACHE_USER_PID=$PID

	if [ $RUNNING -eq 0 ]; then
		echo $STATUS
	else
		if kill $PID ; then
			echo "$0: user httpd stopped"
		else
			echo "$0: user httpd could not be stopped"
			exit 1;
		fi
	fi

	MAXTRY=30
	i=0
	while [ $i -lt $MAXTRY -a $RUNNING -eq 1 ] ; do
		CheckPID
		if [ $RUNNING -eq 1 ] ; then
			sleep 1
		fi
		i=`expr $i + 1`
	done

	kill -9 $APACHE_USER_PID 2> /dev/null;
	UpdateRelayd
	;;
[Ss][Tt][Aa][Rr][Tt])
	if [ ! -x "$Httpd" ]; then
		echo "$Httpd is not executable."
		exit 1;
	fi

	PHP_Spool="/var/spool/php"
	TmpDir="/volume1/@tmp/php"
	SupportRAID=`/bin/get_key_value /etc.defaults/synoinfo.conf supportraid`
	case "${SupportRAID}" in
	[Yy][Ee][Ss])
		TmpDir="${PHP_Spool}";;
	esac

	rm -rf ${TmpDir}
	mkdir -p ${TmpDir}
	chmod 1777 ${TmpDir}
	if [ "${TmpDir}" != "${PHP_Spool}" ]; then
		rm -rf ${PHP_Spool}
		ln -sf ${TmpDir} ${PHP_Spool}
	fi
	mkdir -p ${PHP_Spool}/apc
	chmod 1777 ${PHP_Spool}/apc

	# Dir for Blog banner image file. 
	chown -R 1023 /var/services/blog/
	chmod 755 /var/services/blog/

	#clean up Assistant Photo Uploader temp files	
	rm -rf "/var/services/photo/@eaDir/ASST_PHOTO_UPLOAD_TMP_DIR"

	if [ $RUNNING -eq 1 ]; then
		echo "$0 $ARG: httpd (pid $PID) already running"
	else
		GenerateConf
		count=1
		while [ ! -s "${HttpdConf}" -a $count -lt 3 ];
		do
			GenerateConf
			count=$(($count + 1))
		done
		if [ ! -s ${HttpdConf} ]; then
			logger -p err -t $0 "${HttpdConf} is empty."
		fi

		PHP_PATH="/bin:/sbin:/usr/bin:/usr/sbin:/usr/syno/bin:/usr/syno/sbin:/usr/local/bin:/usr/local/sbin"

		startArg=""
		if [ "yes" = "$RunWebHTTPS" ]; then
			startArg="$startArg -DSSL"
		fi

		if [ "$SupportWeb" = "yes" -a \( "$RunWeb" = "yes" -o "$RunPhoto" = "yes" -o "$RunWebLocal" = "yes" -o "$WebmailEnabled" = "yes" \) ]; then
			startArg="$startArg -DHAVE_PHP"
		fi

		echo "Start User Apache Server ....."
		if env TMPDIR=${TmpDir} PATH=${PHP_PATH} $Httpd $startArg; then
			echo "$0: user httpd started"
		else
			echo "$0: user httpd could not be started"
			exit 1;
		fi
		UpdateRelayd
	fi
	;;
[Rr][Ee][Ss][Tt][Aa][Rr][Tt])
	if [ $RUNNING -eq 0 ]; then
		$0 start
	else
		$0 stop		
		$0 start
	fi
	;;
[Gg][Rr][Aa][Cc][Ee][Ff][Uu][Ll])
	if [ $RUNNING -eq 0 ]; then
		$0 start
	else
		GenerateConf
		if kill -HUP $PID ; then
			echo "$0: user httpd restarted"
		else
			echo "$0: user httpd could not be restarted"
			exit 1;
		fi
	fi
	;;
*)
	echo "Usage: $0 [start|stop|restart]"
	;;
esac
exit 0;
