#!/bin/sh
#set -x
SYNOSNMPCDPIDFILE=/var/run/synosnmpcd.pid
SNMPDPIDFILE=/var/run/snmpd.pid
SYNOSNMPCD=/usr/syno/sbin/synosnmpcd
SNMPD=/usr/syno/etc/rc.d/S08snmpd.sh
KILL=/bin/kill
ECHO=/bin/echo
CAT=/bin/cat
SLEEP=/bin/sleep

#Check snmpd open or not
CheckPidExist()
{
	Pid=`$CAT $1` > /dev/null 2>&1
	if [ "x$Pid" != "x" -a -d "/proc/$Pid" ]; then
		return 1
	fi
	return 0
}

StartSynoSnmpcd()
{
	CheckPidExist $SNMPDPIDFILE
	Ret1=$?
	if [ -x $SNMPD -a $Ret1 -eq 0 ]; then
		$SNMPD start
	fi
	
	CheckPidExist $SYNOSNMPCDPIDFILE
	Ret1=$?
	if [ -x $SYNOSNMPCD -a $Ret1 -eq 0 ]; then
		$ECHO
		$ECHO ' Starting Synosnmpcd'
		$SYNOSNMPCD
	fi

	return 0
}

StopSynoSnmpcd()
{
	$ECHO
	$ECHO ' Stoping Synosnmpcd'
	if [ -f $SYNOSNMPCDPIDFILE ]; then
		$KILL -s TERM `$CAT $SYNOSNMPCDPIDFILE` > /dev/null 2>&1
		$SLEEP 1
	fi
}

case $1 in
	"start")
		StartSynoSnmpcd
		;;
	"stop")
		StopSynoSnmpcd
		;;
	"restart")
		StopSynoSnmpcd
		StartSynoSnmpcd
		;;
	*)
		echo "Usage: $0 start|stop|restart"
		;;
esac

