#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

RFKILL="/usr/syno/sbin/rfkill"
RF_BLOCK_WIFI="${RFKILL} block wifi"
RF_UNBLOCK_WIFI="${RFKILL} unblock wifi"
RF_LIST_WIFI="${RFKILL} list wifi"
WIFIBLOCK_INFO="/tmp/wifiblock.info"
RCNETWORK="/etc/rc.network"
BINSLEEP="/bin/sleep"
SYNOINFO="/etc/synoinfo.conf"
NET_TOPOLOGY=`/bin/get_key_value ${SYNOINFO} net_topology`
SYNOWIRELESS="/usr/syno/bin/synowireless"

blockwifi()
{
	if [ "sta" = "${NET_TOPOLOGY}" ]; then
		${SYNOWIRELESS} -d &
	else
		${RCNETWORK} stop-ap
	fi
	${BINSLEEP} 2
	${RF_BLOCK_WIFI}
}

unblockwifi()
{
	${RF_UNBLOCK_WIFI}
	${BINSLEEP} 2
	if [ "sta" = "${NET_TOPOLOGY}" ]; then
		${SYNOWIRELESS} -c &
	else
		${RCNETWORK} start-ap
	fi
}

rfswitchwifi()
{
	local soft_block=`${RF_LIST_WIFI} | grep "Soft block" | cut -d' ' -f 3`
	local hard_block=`${RF_LIST_WIFI} | grep "Hard block" | cut -d' ' -f 3`
	local isBlock=""
	if [ "${soft_block}" = "no" -a "${hard_block}" = "no" ]; then
		isBlock="no"
		blockwifi
	else
		isBlock="yes"
		unblockwifi
	fi
	echo "wifiblock=\"${isBlock}\"" > ${WIFIBLOCK_INFO}
}

action=$1
case "${action}" in
	blockall)
		blockwifi
		;;
	unblockall)
		unblockwifi
		;;
	rfswitch)
		rfswitchwifi
		;;
	*)
		echo "Usage: $0 [blockall|unblockall|rfswitch]"
		;;
esac
