#!/bin/sh

SCRIPT_UPS_DAEMON_USB=/usr/syno/bin/ups.sh
SCRIPT_UPS_DAEMON_SNMP=/usr/syno/etc/rc.d/S12upsmon.sh

UPS_V_NAME="SYNO_UPS"
UPS_V_VERSION="2.6"
UPS_V_VENDOR="Synology Inc."
UPS_V_MODVER="1.0"

UPS_F_LOCK="/tmp/synoups.lock"

UpsRestart() {
	UpsMode=`/bin/get_key_value /etc/synoinfo.conf ups_mode`
	# ups_mode will be empty when upgrade to 4.2
	if [ "x" = "x${UpsMode}" ]; then
		UpsMode="usb"
	fi

	if [ "usb" = "${UpsMode}" ]; then
		$SCRIPT_UPS_DAEMON_USB restart
	elif [ "snmp" = "${UpsMode}" ]; then
		$SCRIPT_UPS_DAEMON_SNMP restart
	fi
}



