#!/bin/sh

#include common scripts
FILE_UPS_INC_SCRIPT=/usr/libexec/UpsCommon.sh
. ${FILE_UPS_INC_SCRIPT}

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo ${UPS_V_MODVER};
	;;
	--name)
		#Print package name
		echo ${UPS_V_NAME};
	;;
	--pkg-ver)
		#Print package name
		echo ${UPS_V_VERSION};
	;;
	--vendor)
		#Printf package vendor
		echo ${UPS_V_VENDOR};
	;;
	--pre)
		#Actions before share set
	;;
	--post)
        {
		flock -x 0
                local cntUpsMon=`ps|grep '/usr/syno/sbin/upsmon'|grep -cv grep`
		if [ 0 -lt $cntUpsMon ] && [ "1" = "${SERVICE_IP_CHANGE}" ]; then
			UpsRestart
		fi
		flock -u 0
	} 0<>$UPS_F_LOCK
	;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

