#!/bin/sh
# Copyright (c) 2000-2011 Synology Inc. All rights reserved.

#Llocation of syslog server configuration
FILE_SYSLOGNG_SETTING=/usr/syno/etc/synosyslog/setting.conf
#Location of syslog runscript
FILE_SYSLOGNG_RUNSCRIPT=/usr/syno/syslogclient/scripts/runscript.sh

SYSLOGNG_SERVER_ENABLE=0
if [ -f "${FILE_SYSLOGNG_SETTING}" ]; then
    SYSLOGNG_SERVER_ENABLE=`/bin/get_key_value ${FILE_SYSLOGNG_SETTING} server_enable`
fi

case $1 in
    start)
        # System is booting
        if [ "yes" == ${SYSLOGNG_SERVER_ENABLE} ]; then
            #When booting, leave this action for real run script if server is enable
            echo "Leave start action for server run script"
            exit;
        fi

        ${FILE_SYSLOGNG_RUNSCRIPT} start
    ;;
    stop)
        # System is halting
        ${FILE_SYSLOGNG_RUNSCRIPT} hardstop
    ;;
    restart)
        ${FILE_SYSLOGNG_RUNSCRIPT} restart
    ;;
    *)
    	echo "Usage: $0 start|stop"
    ;;
esac
