#!/usr/bin/perl

use strict;
use warnings;
use Digest::MD5 qw(md5_hex);

# operations for base 64
#	$base64_string = convertToBase64(@byte_array);
#	@byte_array = convertFromBase64($base64_string);
{#{{{
	my $b64 = ".ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789_";
	sub b64_char_to_6 {
		my $i = index($b64, shift);
		return -1 == $i ? 0 : $i;
	}
	sub convertToBase64 {
		while (scalar @_ % 3) { push @_, 0; } # padding 0
		my $str = '';
		for (my $i = 0 ; $i < scalar @_ ; $i += 3) {
			my $x = ($_[$i] << 16) | ($_[$i+1] << 8) | $_[$i+2];
			$str .= substr($b64, ($x >> 18) & 0x3f, 1);
			$str .= substr($b64, ($x >> 12) & 0x3f, 1);
			$str .= substr($b64, ($x >> 6)  & 0x3f, 1);
			$str .= substr($b64, ($x)       & 0x3f, 1);
		}
		return $str;
	}
	sub convertFromBase64 {
		my $str = shift;
		my @out = ();
		$str .= '.' x (4 - length($str) % 4) if length($str) % 4; # padding "."
		while ($str =~ /(.)(.)(.)(.)/g) {
			my $x = (b64_char_to_6($1) << 18) |
				(b64_char_to_6($2) << 12) |
				(b64_char_to_6($3) << 6) |
				(b64_char_to_6($4));
			push @out, ($x >> 16) & 0xff, ($x >> 8) & 0xff, $x & 0xff;
		}
		return @out;
	}
}#}}}

# operations for byte array
#	@byte_array = putStr("hello", 10); # return an array with 11 element
#	@byte_array = putIP("192.168.1.1); # return (192, 168, 1, 1);
#	@byte_array = putUInt(256, 2);     # return (1, 0);
sub putStr  { return unpack("C*", $_[0]), map{0}(0..($_[1]-length $_[0])); }
sub putIP   { return map{+$_}split(/\./, shift); }
sub putUInt { return map{ ($_[0] >> (($_[1] - $_)*8)) & 0xff }(1..$_[1]); }


# generate encoded authentication string for login
#	$encode_string = login($file_data_page, "admin:password");
sub login {#{{{
	my ($page, $auth) = @_;
	my ($user, $pass) = split(/:/, $auth, 2);
	my $data = undef;
	
	open my $fh, "<$page" or die;
	while (<$fh>) {
		$data = $1 if /data="([^"]+)"/;
	}
	close $fh;

	my @a = convertFromBase64( $data );
	my $shex = join '', (map { sprintf "%02X",$_} @a[0..3]);
	my $str = $shex . $pass;
	$str .= '0' x (63 - length($str));
	$str .= $user eq 'user' ? 'U' : '0';
	my $hash = md5_hex($str);
	my $saltHash = $shex . $hash;
	@a = ();
	while ($saltHash =~ /(..)/g) {
		push @a, hex $1;
	}
	return convertToBase64( @a );
}#}}}

# append port forwarding parameters to byte array
#	*_append_rule(\@rule, %params);		# append a rule setting to @rule
#	*_fill_rest_by_empty(\@rule, $num) 	# fill all rule in the table. if table has 32 rule, 
#						# it will append 32 - $num rules;
{#{{{
	# default parameters
	my @alg_assoc = map{0}(1..31);
	my @filter    = (65, 108, 108, 111, 119,  32, 65, 108, 108, 0, 0, 0, 0, 0, 0, 0, 0);
	my @schedule  = (65, 108, 119,  97, 121, 115,  0,   0,   0, 0, 0, 0, 0, 0, 0, 0, 0);
	my $enable    = 1;
	my $used      = 1;

	sub vs_append_rule {
		my ($rule, %r) = @_;
		push @{$rule}, @alg_assoc, $enable, putStr($r{c}, 15), @filter, putIP($r{ip}),
			putUInt($r{sp},2), putUInt($r{p},1), putUInt($r{rp},2), @schedule, $used;
		return 1;
	}

	sub vs_fill_rest_by_empty {
		my ($rule, $num) = @_;
		push @{$rule}, @alg_assoc, !$enable, putStr('', 15), @filter, putIP('0.0.0.0'), 
			putUInt(0,2), putUInt(0,1), putUInt(0,2), @schedule, !$used for(1..(32-$num));
		return 32 - $num;
	}

	sub pf_append_rule {
		my ($rule, %r) = @_;
		push @{$rule}, $enable, putStr($r{c}, 40), putIP($r{ip}), @filter, @schedule;
		if ('0' eq $r{p} or '6' eq $r{p}) {
			push @{$rule}, putStr($r{sp}, 60);
		} else {
			push @{$rule}, putStr('', 60);
		}
		if ('0' eq $r{p} or '17' eq $r{p}) {
			push @{$rule}, putStr($r{sp}, 60);
		} else {
			push @{$rule}, putStr('', 60);
		}
		push @{$rule}, $used;
		return 1;
	}

	sub pf_fill_rest_by_empty {
		my ($rule, $num) = @_;
		push @{$rule}, !$enable, putStr('', 40), putIP('0.0.0.0'), @filter, @schedule,
			putStr('', 60), putStr('', 60), !$used for(1..(16-$num));
		return 16 - $num;
	}
}#}}}

########################### main ###############################
my $action = shift;
if ('login' eq $action) {
	print login(@ARGV);
	exit 0;
} elsif ( 'vs' ne $action and 'pf' ne $action) {
	die;
}

my ($param_file, $data_file) = @ARGV;

# read table data from router
open DATA, "<$data_file" or die;
my ($dummy, $data) = split /=/, <DATA>, 2;
chomp $data;
if ($data =~ /^"/ and $data =~ /"$/) {
	$data = substr($data, 1, length($data)-2);
}
close DATA;

# get ip and mask
my @head = convertFromBase64(substr($data, 0, 12));
pop @head;

# append rules
my @rule = ();
my $c = 0;
open PARAM, "<$param_file" or die;
while(<PARAM>) {
	chomp;
	if ('vs' eq $action) {
		$c += vs_append_rule(\@rule, split /=|&/);
		last if $c == 32;
	} elsif ('pf' eq $action) {
		$c += pf_append_rule(\@rule, split /=|&/);
		last if $c == 16;
	}
}
close PARAM;

vs_fill_rest_by_empty(\@head, $c) if ('vs' eq $action);
pf_fill_rest_by_empty(\@head, $c) if ('pf' eq $action);

my @rest = ();
if ('pf' eq $action) {
	@rest = convertFromBase64(substr($data, 4340, 4));
	shift @rest;
}

my $str = convertToBase64(@head, @rule, @rest);
substr($data, 0, length $str, $str);#replace

open OUT, ">$param_file.out" or die;
print OUT 'data=', $data;
close OUT;

print "$param_file.out";
