#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.
. /usr/syno/bin/synoupscommon

UPS_DRV_CURR=$UPS_ROOT"/ups_drv.curr"
UPS_DRV_LIST=$UPS_ROOT"/ups_drv.list"
UPS_DRV_BIN_NAME=""
UPS_VENDER_ID=""
UPS_PROD_ID=""

{
flock -x 58

SwitchConf2Usb() {
	/bin/sed -i "s/^\tport = .*/\tport = auto/" /usr/syno/etc/ups/ups.conf
	/bin/sed -i "s/.*community = .*/\t#community = /" /usr/syno/etc/ups/ups.conf
	/bin/sed -i "s/.*snmp_version = .*/\t#snmp_version = v2c/" /usr/syno/etc/ups/ups.conf
}

IsDrvAlive() {
	if [ ! -e $UPS_DRV_CURR ]; then
		return 0
	fi
	local CUR_DRV=`cat ${UPS_DRV_CURR}`
	local cntDrv=`ps|grep ${CUR_DRV}|grep -cv grep`
	if [ $cntDrv -gt 0 ]; then
		return 1
	else
		return 0
	fi
}

IsDevAlive() {
	local curr_drv=`cat ${UPS_DRV_CURR}`
	DetectDrv
	if [ $? -eq 1 ] && [ "x${curr_drv}" = "x${UPS_DRV_BIN_NAME}" ]; then
		return 1
	fi
	return 0
}

GetDrv() {
	if [ ! -e $UPS_DRV_LIST ]; then
		cp -af /usr/syno/etc/ups/nutscan-usb.h $UPS_DRV_LIST
	fi
	# { 0x0001, 0x0000, "blazer_usb" }
	eval UPS_DRV_BIN_NAME=`grep -r "0x$1, 0x$2," ${UPS_DRV_LIST} |cut -d " " -f 4`
	if [ "x" != "x$UPS_DRV_BIN_NAME" ]; then
		return 1
	fi
	return 0
}

DetectDrv() {
	local count_dev=`cat /proc/bus/usb/devices|grep -c P:`
	local sDev=''
	for i in `seq 1 1 $count_dev`; do
		sDev=`cat /proc/bus/usb/devices|grep P:|sed -n "${i}p"`
		eval `echo $sDev| awk '{print $2}'` #Vendor=xxxx
		eval `echo $sDev| awk '{print $3}'` #ProdID=xxxx
		GetDrv ${Vendor} ${ProdID}
		if [ $? -eq 1 ]; then
			return 1
		fi
	done
	return 0
}

SaveDrv() {
#	grep 'driver =' /usr/syno/etc/ups/ups.conf|grep -v ^#|cut -d '=' -f 2|sed 's/^[[:space:]]*\(.*\)[[:space:]]*$/\1/' > $UPS_DRV_CURR
	/usr/syno/bin/synogetkeyvalue /usr/syno/etc/ups/ups.conf driver > $UPS_DRV_CURR
}

StartDrv() { #param: DRV_NAME
	sed -i "s/^\tdriver.*/\tdriver = $1/" /usr/syno/etc/ups/ups.conf
	/usr/syno/bin/upsdrvctl ${ARG_PRODUCT} start

	if [ $? -ne 0 ]; then
		return 255
	fi
	return 0
}

StartAllDrv() {
	local DRV_LIST="bcmxcp_usb blazer_usb richcomm_usb tripplite_usb usbhid-ups"
	local iRet=1

	DetectDrv
	if [ $? -eq 1 ]; then
		StartDrv $UPS_DRV_BIN_NAME
		if [ $? -eq 0 ]; then
			return 0
		fi
	fi

	for URV in ${DRV_LIST}; do
		StartDrv $URV
		iRet=$?
		if [ $iRet -eq 0 ]; then
			break
		fi
	done

	if [ $iRet -ne 0 ]; then
		return 255
	fi
	return 0
}

StartUps() { #param: START_TYPE(start, restart) DRV_NAME
	grep -q 'STEP=4' /tmp/boot_seq.tmp
	local blOnBoot=$?
	local START_TYPE=$1
	local DRV_NAME=$2

	# ups delay start on system booting
	if [ $blOnBoot -ne 0 ]; then
		for i in `seq 1 1 10`; do
			sleep 3
			grep -q 'STEP=4' /tmp/boot_seq.tmp
			if [ 0 -eq $? ]; then
				break
			fi
		done
	fi

	echo "Start Driver"
	IsDrvAlive
	if [ $? -eq 0 ]; then
		if [ "xusb" != "x${UpsMode}" ]; then
			StopUps
			SwitchConf2Usb
		fi
		if [ "x" = "x${DRV_NAME}" ]; then
			StartAllDrv
		else
			StartDrv $DRV_NAME
		fi
		if [ $? -ne 0 ]; then
			echo "This UPS is not supported. product=[$PRODUCT], cmd=[$ARG_PRODUCT]"
			logger -p err -- "This UPS is not supported. product=[$PRODUCT], cmd=[$ARG_PRODUCT]"
			return 255
		fi
		logger -p err -- "The UPS is connected. driver=[$DRV_NAME]"
		/usr/syno/bin/synologset1 sys info 0x1130001A
		SaveDrv
	else
		echo "Driver alive"
		if [ "xstart" = "x${START_TYPE}" ]; then
			return 1
		fi
	fi

	# Slave enabled -> Master, disable both
	if [ $SlaveEnabled -eq 1 ] || [ "xusb" != "x${UpsMode}" ]; then
		/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf ups_enabled no
		/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf upsslave_enabled no
		MasterEnabled=0
		SlaveEnabled=0
	fi

	/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf ups_mode usb
	/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf upsmaster yes

	UPSWaitTime=`/bin/get_key_value /etc/synoinfo.conf ups_wait_time`
        /bin/sed -i "/^AT ONBATT/d" /usr/syno/etc/ups/upssched.conf
	if [ "x$UPSWaitTime" != "x" ]; then
		echo "AT ONBATT * START-TIMER fsd ${UPSWaitTime}" >> /usr/syno/etc/ups/upssched.conf
	fi

	echo "Start UPS Server"
	StartServer
	# Server daemon init time
	sleep 1

	if [ $MasterEnabled -eq 1 ]; then
		echo "Start UPS client"
		/bin/sed -i "/^MONITOR/c\\MONITOR ups@localhost 1 monuser secret master" /usr/syno/etc/ups/upsmon.conf
		if [ 0 -eq $blOnBoot ] && [ 0 -eq $StatClient ]; then
			StartClient
		else
			StartClient "-b"
		fi
	fi
	return 0
}

case "$1" in
start)
	if [ "$PRODUCT" != "" ]; then
		UPS_VENDER_ID=`echo ${PRODUCT} | awk -F/ '{printf("%04s", $1);}' | sed 's: :0:g'`
		UPS_PROD_ID=`echo ${PRODUCT} | awk -F/ '{printf("%04s", $2);}' | sed 's: :0:g'`
	else
		logger -p err -- "PRODUCT information not found. byebye."
		echo "PRODUCT information not found. byebye."
	fi

	GetDrv $UPS_VENDER_ID $UPS_PROD_ID
	if [ 1 -eq $? ]; then
		StartUps "start" $UPS_DRV_BIN_NAME
		# print log only after running sccuess to prevent to break hiperation
		if [ 0 -eq $? ]; then
			echo "$0 $1 invoked."
			logger -p err -- "$0 $1 invoked."
		fi
	fi
	;;
start-all)
	StartUps "start"
	if [ 0 -eq $? ]; then
		echo "$0 $1 invoked."
		logger -p err -- "$0 $1 invoked."
	fi
	;;
stop)
	# wait 1 sec to prevent instability leading to restart
	sleep 1
	IsDevAlive
	if [ 0 -eq $? ]; then
		StopUps log
		logger -p err -- "$0 $1 invoked."
		echo "Stop UPS"
		echo "$0 $1 invoked."
		/usr/syno/bin/synosetkeyvalue /etc/synoinfo.conf upsmaster no
	fi
	;;
restart)
	echo "Restart UPS"
	echo "$0 $1 invoked."
	logger -p err -- "$0 $1 invoked."
	StopUps
	WaitStop
	StartUps "restart"
	;;
esac

flock -u 58
} 58<>$UPS_LOCK

