#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

if [ -r /etc.defaults/rc.subr ]; then
	. /etc.defaults/rc.subr
fi

ServiceName="synorelayd"
ServiceBin=/usr/syno/sbin/synorelayd
RunKey="runrelayd"
PATH_PID=/var/run/synorelayd.pid
PATH_CONF=/usr/syno/etc/synorelayd.conf

is_enabled() { # <void>
	local toEnable=$(/bin/get_key_value /etc/synoinfo.conf "$RunKey")
	[ "${toEnable:-no"}" = "yes" ]
}
is_alive() { # <void>
	if [ ! -s "$PATH_PID" ]; then
		return ${LSB_STAT_NOT_RUNNING:-3}
	fi
	local pid=`cat "$PATH_PID"`
	# only check basename?
	if [ `readlink "/proc/$pid/exe"` = $ServiceBin ]; then
		return ${LSB_STAT_RUNNING:-0}
	else
		return ${LSB_STAT_DEAD_FPID:-1}
	fi
}
message() { # [echo args] [msgs...]
	local ret=$?
	echo $@ >&2
	return $ret
}
logerr() { # [logger args] [msgs...]
	logger -p user.err -t "$ServiceName" "$@"
}
check_bin() { # <void>
	if [ ! -x "$ServiceBin" ]; then
		if [ -e "$ServiceBin" ]; then
			message "permission denied"
			return ${LSB_ERR_PERM:-4}
		else
			message "$ServiceName not installed"
			return ${LSB_ERR_INSTALLED:-5}
		fi
	fi
	return 0
}
start() { # <void>
	check_bin || return

	if ! is_enabled || [ ! -r "$PATH_CONF" ]; then
		message "$ServiceName is not configured"
		return ${LSB_ERR_CONFIGURED:-6}
	fi

	message -n "start $ServiceName..."

	if $ServiceBin; then
		message "success"
		return ${LSB_SUCCESS:-0}
	else
		message "fail"
		logerr "$ServiceName start failed"
		return ${LSB_ERR_GENERIC:-1}
	fi
}
stop() { # <void>
	check_bin || return

	if ! is_alive; then
		# FIXME better way to check LSB_NOT_RUNNING
		return ${LSB_NOT_RUNNING:-7}
	fi

	if $ServiceBin -k; then
		message "$ServiceName stoped"
		return ${LSB_SUCCESS:-0}
	fi

	message -n "$ServiceName stop failed, stop it by kill..."

	killall -9 synorelayd
	if ! pidof synorelayd >/dev/null; then 
		message "done"
		return ${LSB_SUCCESS:-0}
	else
		message "fail"
		return ${LSB_ERR_GENERIC:1}
	fi
}
restart() { # <void>
	stop
	if [ $? -ne 0 -o $? -ne ${LSB_NOT_RUNNING:-7} ]; then
		logerr "stop failed, start again"
	fi
	start
}
reload() { # <void>
	if $ServiceBin -U; then
		message "$ServiceName reload"
		return ${LSB_SUCCESS:-0}
	else
		message "$ServiceName reload failed"
		return ${LSB_ERR_GENERIC:-1}
	fi
}
status() { # <void>
	if is_alive; then
		$ServiceBin -s
		case $? in
			0) return ${LSB_STAT_RUNNING:-0} ;;
			1) return ${LSB_STAT_NOT_RUNNING:-3} ;;
			*) return ${LSB_STAT_UNKNOWN:-4} ;;
		esac
	else
		return
	fi
}

# main
case $1 in
	start)                start ;;
	stop)                 stop  ;;
	restart)              restart ;;
	hup|reload)           reload ;;
	status)               status ;;
	force-reload)
		exit ${LSB_ERR_UNIMPLEMENTED:-3}
		;;
	*)
		exit ${LSB_ERR_ARGS:-2}
		;;
esac

