#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

HA_PREFIX="/usr/syno/synoha"

SYNOHA_PROG="$HA_PREFIX/sbin/synoha"
SYNOHASTR_PROG="$HA_PREFIX/sbin/synohastr"

HA_UNBINDING=`$SYNOHASTR_PROG --unbinding`

. $HA_PREFIX/etc.defaults/rc.subr

case "$1" in
	start)
		synoha_log "SxxPre start"
		$HA_PREFIX/sbin/synoha --update-hotspare-conf

		# enable ntp server again, because it may be disabled after upgrade
		# enable this before S23ntpd.sh start
		$SYNOHA_BIN --enable-ntp-server
		;;
	stop)
		synoha_log "SxxPre stop"

		if [ -e $HA_UNBINDING ]; then
			$SYNOHA_PROG --set-vaai-default
		fi

		;;
	restart)
		stop
		start
		;;
	status)
		;;
	*)
		echo "Usages: $0 [start|stop|restart|status]"
		;;
esac
exit $?

