#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

HA_PREFIX="/usr/syno/synoha"
PIDFILE="/var/run/ntpd_ha_client.pid"
NTPD_BIN="/usr/sbin/ntpd"
NTPCONF="/tmp/ntp_ha_client.conf"

. $HA_PREFIX/etc.defaults/rc.subr

start_()
{
	rm -f $NTPCONF
	local _remote_drbdip=`$SYNOHA_BIN --remote-drbdip`
	echo "server $_remote_drbdip" >> $NTPCONF
	echo "restrict default ignore" >> $NTPCONF
	echo "restrict -6 default ignore" >> $NTPCONF
	echo "restrict 127.0.0.1" >> $NTPCONF
	echo "restrict $_remote_drbdip" >> $NTPCONF
	$NTPD_BIN -p $PIDFILE -c $NTPCONF -g
}

stop_()
{
	if [ -f $PIDFILE ]; then
		local _pid
		_pid=`cat $PIDFILE`
		if [ "x$_pid" != "x" ] ; then
			kill $_pid
		fi
		rm -f $NTPCONF
		rm -f $PIDFILE
	fi
}

case "$1" in
	start)
		stop_
		start_
		;;
	stop)
		stop_
		;;
	restart)
		stop_
		start_
		;;
	*)
		echo "Usage: $0 { start | stop | restart}"
		;;
esac
exit $?

