#!/bin/sh

SYNOLOGD="/usr/syno/sbin/synologd"
PID_FILE="/var/run/synologd.pid"

get_pid()
{
	if [ ! -f ${PID_FILE} ]; then
		echo "${PID_FILE} not found. Not running?"
		return 1
	else
		pid=`cat ${PID_FILE} 2>/dev/null`
		if [ -f /proc/$pid/cmdline ]; then
			echo $pid
			return 0
		else
			rm -f ${PID_FILE}
			echo "${PID_FILE} is found, but not running?"
			return 1
		fi
	fi
}

FuncCheckDB()
{
	eval $(grep "^runpgsql=" /etc/synoinfo.conf)
        case "${runpgsql}" in
        [Yy][Ee][Ss])
        	 ;;
        *)
        	 echo "PGSQL service is disabled. Skip..."
        	 exit 1;
        	 ;;
        esac

	echo "Checking synolog database existence..."
	su -l admin -c "/usr/syno/pgsql/bin/psql synolog -c \"SELECT 1 FROM ftpxfer LIMIT 1\" > /dev/null"
	Ret=$?
	if [ $Ret = 2 ]; then
		echo "Creating synolog database..."
		su -l admin -c "/usr/syno/pgsql/bin/createdb synolog"
		if [ $? != 0 ]; then
			echo "Failed to create database"
			exit 1
		fi
		Ret=1
	fi

	if [ $Ret = 1 ]; then
		echo "Creating synolog tables..."
		/usr/syno/pgsql/bin/psql synolog -U admin -f /usr/syno/synologd/sql/synolog.pgsql
		if [ $? != 0 ]; then
			echo "Failed to create tables in synolog database"
			exit 1
		fi
	elif [ $Ret = 0 ]; then
	    upgrades=`find /usr/syno/synologd/sql/upgrade -name "*.sh" | sort`
	    for ThisArg in $upgrades;
	    do
		    $ThisArg
	    done
	else
		echo "Unknown error"
		exit 1
	fi
}

FuncDropWebfmTable()
{
	echo "Drop TABLE webfmxfer ..."
	su -l admin -c "/usr/syno/pgsql/bin/psql synolog -c \"SELECT 1 FROM webfmxfer LIMIT 1\" > /dev/null"
	if [ $? = 0 ]; then
		su -l admin -c "/usr/syno/pgsql/bin/psql synolog -c \"INSERT INTO dsmfmxfer SELECT * FROM webfmxfer\" > /dev/null"
		if [ $? != 0 ]; then
			echo "Fail to SELECT * INTO dsmfmxfer FROM webfmxfer"
		fi
		su -l admin -c "/usr/syno/pgsql/bin/psql synolog -c \"DROP TABLE webfmxfer\" > /dev/null"
		if [ $? != 0 ]; then
			echo "Failed to DROP TABLE webfmxfer"
		fi
	fi
}

FuncCheckIfNeedRun()
{
	echo "Checking if need to run synologd..."
	RunFTP=`/bin/get_key_value /etc/synoinfo.conf runftpd`
	LogFTP=`/bin/get_key_value /etc/synoinfo.conf ftpxferlog`
	RunTFTP=`/bin/get_key_value /etc/synoinfo.conf runtftp`
        LogTFTP=`/bin/get_key_value /etc/synoinfo.conf tftpxferlog`
	LogDSMFM=`/bin/get_key_value /etc/synoinfo.conf filebrowserxferlog`
	RunWEBDAV=`/bin/get_key_value /etc/synoinfo.conf runWebDav`
	RunWEBDAVS=`/bin/get_key_value /etc/synoinfo.conf runWebDavHTTPS`
	LogWEBDAV=`/bin/get_key_value /etc/synoinfo.conf webdavxferlog`
	RunSMB=`/bin/get_key_value /etc/synoinfo.conf runsamba`
	LogSMB=`/bin/get_key_value /etc/synoinfo.conf smbxferlog`

	if [ -z "$RunWEBDAV" ]; then
	    RunWEBDAV="no"
	fi
	if [ -z "$RunWEBDAVS" ]; then
	    RunWEBDAVS="no"
	fi

	if [ "yes" = "$RunFTP" ] && [ "yes" = "$LogFTP" ]; then
	    return 1
	elif [ "yes" = "$RunTFTP" ] && [ "yes" = "$LogTFTP" ]; then
	    return 1
	elif [ "yes" = "$LogDSMFM" ]; then
	    return 1
	elif [ "yes" = "$LogWEBDAV" ] && [ "yes" = "$RunWEBDAV" -o "yes" = "$RunWEBDAVS" ]; then
	    return 1
	elif [ "yes" = "$RunSMB" ] && [ "yes" = "$LogSMB" ]; then
	    return 1
	fi
	echo "No need to start synologd..."
	return 0
}

case $1 in
start)
	if [ -f ${PID_FILE} ]; then
		kill -0 `cat ${PID_FILE}` > /dev/null 2>&1
		if [ $? = 0 ];then
			echo "Already running."
			exit 0
		fi
	fi

	FuncCheckDB
	if [ -f "/var/.UpgradeBootup" ]; then
	    FuncDropWebfmTable
	fi
	FuncCheckIfNeedRun
	if [ $? -eq 1 ]; then
	    echo "Starting ${SYNOLOGD}"
	    ${SYNOLOGD}
	fi
	;;
stop)
	PID=`get_pid`
	RET=$?
	case "$RET" in
		1)
			exit 0
		;;
	esac
	echo "Stopping ${SYNOLOGD}"
	#1 kill pid and check that pidfile is removed
	# send kill signal and wait maximum 30 seconds for the process to end
	`kill ${PID}`
	waittime=0
	while [ -d /proc/${PID} ]; do
		echo "Wating ..."
		`sleep 1`
		waittime=`expr $waittime + 1`		
		if [ $waittime -ge 30 ]; then
			`kill -9 ${PID}`
			`sleep 1`
			break
		fi
	done
	#2 check proc/pid do not exist
	if [ ! -d /proc/${PID} ]; then
		[ -f ${PID_FILE} ] && rm -f ${PID_FILE}
		exit 0
	else
		echo "Fail to stop?"
		exit 1
	fi
	;;
restart)
	$0 stop
	$0 start
	;;
*)
	echo "Usage: $0 [start|stop|restart]"
	;;
esac

