#!/bin/sh

RunAsUser="nobody"
ChrootDir="/usr/syno/named"
Named=${ChrootDir}/bin/named
#ExtraFlags="-g"

InitDirectory()                      
{                                    
	mkdir -p ${ChrootDir}/var/run/named
	chown ${RunAsUser} ${ChrootDir}/var/run/named

	mkdir ${ChrootDir}/dev
	mknod ${ChrootDir}/dev/null c 1 3
	mknod ${ChrootDir}/dev/random c 1 8

	chown ${RunAsUser} ${ChrootDir}/etc
	mkdir ${ChrootDir}/etc/dynamic
	chown ${RunAsUser} ${ChrootDir}/etc/dynamic
	mkdir ${ChrootDir}/etc/slave
	chown ${RunAsUser} ${ChrootDir}/etc/slave

	${ChrootDir}/bin/rndc-confgen -a -b256 -u ${RunAsUser} -c ${ChrootDir}/etc/rndc.key
}

case $1 in
	start)
		if [ ! -d "${ChrootDir}/dev" ];then
			echo "Creating necessary files for named..."
			InitDirectory
		fi
		echo "Starting $Named"
		$Named -t $ChrootDir -u ${RunAsUser} $ExtraFlags
		;;
	stop)
		echo "Stopping $Named"
		killall named 
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 [start|stop|restart]"
		;;
esac

