#!/bin/sh
PID_FILE=/tmp/mysqld.pid
MYSQL_VERSION="5.1.49"
MYSQL_DIR="/usr/syno/mysql"
MYSQL_SERVICE_PATH="/var/services/mysql"
DO_NETBKP_CANCEL_TMP_FILE="/tmp/do_netbkp_cancel.chk"
LOCALBKP_CANCEL_TMP_FILE="/tmp/do_localbkp_cancel.chk"
MYSQL_RCVR_DB_CONFLICT_LIST="/tmp/mysql_rcvr_db_conflict_list.tmp"
MYSQL_RCVR_DB_NEW_LIST="/tmp/mysql_rcvr_db_new_list.tmp"
MYSQL_FAIL=1
CANCEL_RET=2
MYSQL_PROG_PATH=/usr/syno/mysql/bin/mysql

MYSQL_ARGS="--max_allowed_packet=8M"

UpgradeDatabase()
{
	# Upgrade MySQL database
	Ret=0

	# Backup root password and reset password to empty
	echo "USE mysql;" > /tmp/mysql_init.$$
	echo "DELETE FROM user WHERE user='upgrade_root_tmp';" >> /tmp/mysql_init.$$
	echo "UPDATE user SET user='upgrade_root_tmp' WHERE user='root';" >> /tmp/mysql_init.$$
	echo "GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' IDENTIFIED BY '' WITH GRANT OPTION;" >> /tmp/mysql_init.$$
	echo "FLUSH PRIVILEGES;" >> /tmp/mysql_init.$$
	${MYSQL_DIR}/bin/mysqld_safe --init-file=/tmp/mysql_init.$$ --pid-file=${PID_FILE} &
	sleep 20

	# Start Upgrade
	/usr/syno/mysql/bin/mysql_upgrade
	Ret=$?
	$0 stop
	rm /tmp/mysql_init.$$
	sleep 3

	# Restore root password
	echo "USE mysql;" > /tmp/mysql_init.$$
	echo "DELETE FROM user WHERE user='root';" >> /tmp/mysql_init.$$
	echo "UPDATE user SET user='root' WHERE user='upgrade_root_tmp';" >> /tmp/mysql_init.$$
	${MYSQL_DIR}/bin/mysqld_safe --init-file=/tmp/mysql_init.$$ --pid-file=${PID_FILE} &
	sleep 20
	$0 stop
	rm /tmp/mysql_init.$$
	sleep 3

	return $Ret
}

CheckCancellingAction()
{
	Ret=0;

	# check if user has canceld the backup task
	if [ $1 = "netbkp" ]; then
		if [ -f "${DO_NETBKP_CANCEL_TMP_FILE}" ]; then
			Ret=${CANCEL_RET}
		fi
	elif [ $1 = "localbkp" ]; then
		if [ -f "${LOCALBKP_CANCEL_TMP_FILE}" ]; then
			Ret=${CANCEL_RET}
		fi
	else
		Ret=${MYSQL_FAIL}
	fi

	return $Ret
}

BackupDatabase()
{
	# Dump MySQL database
	Ret=0
	DST_PATH=$1
	BKPTYPE=$2

	# Start dump
	for i in `find /var/services/mysql/* -type d` 
	do
		# check if user has canceld the backup task
		CheckCancellingAction ${BKPTYPE}
		Ret=$?
		if [ ${Ret} -ne 0 ]; then
			return ${Ret}
		fi

		f=`basename ${i}`
		f_tmp=`echo $f | sed -e 's/@00/\\\\x/g'`		
		f_tmp=`echo -e "$f_tmp"`		
		# skip mysql and test databases
		if [ "${f_tmp}" = "mysql" -o "${f_tmp}" = "test" ]; then
			continue
		fi
			
		# dump database
		rm -f "$DST_PATH/${f}.sql"
		/usr/syno/mysql/bin/mysqldump --single-transaction --database "${f_tmp}" > "$DST_PATH/${f}.sql"

		# If fail to dump, return ${MYSQL_FAIL}
		if [ $? -ne 0 ]; then
			return ${MYSQL_FAIL}
		fi
		
		# check if user has canceld the backup task before excuting gzip command
		CheckCancellingAction ${BKPTYPE}
		Ret=$?
		if [ ${Ret} -ne 0 ]; then
			return ${Ret}
		fi

		rm -f "$DST_PATH/${f}.sql.gz"
		gzip -f  "$DST_PATH/${f}.sql"
	done

	return $Ret
}

TablesSet()
{
	db="$1"
	ext=$2
	set_type=$3

	`echo "use '${db}'; show tables;" | ${MYSQL_PROG_PATH} > /tmp/table_list.${ext}` 
	cat /tmp/table_list.${ext} | while read line
	do
		if [ "${line}" = "Tables_in_${db}" ]; then
			continue;
		fi
		if [ ${set_type} = "rename" ]; then
			echo "use '${db}'; rename table \`${line}\` to \`${line}_${ext}\`;" | ${MYSQL_PROG_PATH}
		elif [ ${set_type} = "recover" ]; then
			ori_table=${line%_${ext}}
			echo "use '${db}'; rename table \`${line}\` to \`${ori_table}\`;" | ${MYSQL_PROG_PATH}
		elif [ ${set_type} = "drop_ori" ]; then
			# check if ${line} is the original table
			echo "${line}" | grep -q "_${ext}"
			if [ $? -eq 0 ]; then
				echo "use '${db}'; drop table \`${line}\`;" | ${MYSQL_PROG_PATH}
			fi
		elif [ ${set_type} = "drop_new" ]; then
			# check if ${line} is the original table
			echo "${line}" | grep -q "_${ext}"
			if [ $? -eq 0 ]; then
				continue;
			fi
			echo "use '${db}'; drop table \`${line}\`;" | ${MYSQL_PROG_PATH}
		fi
	done
	rm /tmp/table_list.${ext} 
}

RestoreDatabase()
{
	# Dump MySQL database
	Ret=0
	OVERWRITE_DB=${2}

	# MySQL database has not been enabled.
	if [ ! -d "${MYSQL_SERVICE_PATH}" ]; then
		return ${MYSQL_FAIL}
	fi

	time=`date +%s`
	RESTORE_RET=0
	echo -n > ${MYSQL_RCVR_DB_CONFLICT_LIST}
	echo -n > ${MYSQL_RCVR_DB_NEW_LIST}
        echo $1
	for i in `find "$1"/*.sql.gz -type f`
	do
		DB_NAME=`basename "$i"`
                DB_NAME=${DB_NAME%.sql.gz}

		DB_NAME_TMP=`echo $DB_NAME | sed -e 's/@00/\\\\x/g'`
		DB_NAME_TMP=`echo -e "$DB_NAME_TMP"` 
		# if database is conflict, need to rename its tables
		if [ -d "${MYSQL_SERVICE_PATH}/${DB_NAME}" ]; then
			if [ ${OVERWRITE_DB} = "yes" ]; then
				TablesSet "${DB_NAME_TMP}" ${time} "rename"
				# record conflict restored db to temp file
				echo "${DB_NAME_TMP}" >> ${MYSQL_RCVR_DB_CONFLICT_LIST}
			else
				continue;
			fi
		else
			# record new restored db to temp file
			echo "${DB_NAME_TMP}" >> ${MYSQL_RCVR_DB_NEW_LIST}
		fi

		gunzip -c "$1/${DB_NAME}.sql.gz" | ${MYSQL_PROG_PATH}

		# check if database is restored sucessfully
		if [ $? -ne 0 ]; then
			Ret=${MYSQL_FAIL};
			break;
		fi
	done

	# Check If the restoration task is successful, 
	# If failed, drop all new database and recover all tables in all conflict databases
	# If successful, drop all original tables in all conflct databases
	if [ ${Ret} -eq 0 ]; then
		# drop all original tables
		cat ${MYSQL_RCVR_DB_CONFLICT_LIST} | while read line
		do
			TablesSet "${line}" ${time} "drop_ori"
		done
	else
		# drop all new databases
		cat ${MYSQL_RCVR_DB_NEW_LIST} | while read line
		do
			echo "drop database ${line}" | /usr/syno/mysql/bin/msyql
		done

		cat ${MYSQL_RCVR_DB_CONFLICT_LIST} | while read line
		do
			TablesSet "${line}" ${time} "drop_new"
			TablesSet "${line}" ${time} "recover"
		done
	fi

	rm -f ${MYSQL_RCVR_DB_CONFLICT_LIST}
	rm -f ${MYSQL_RCVR_DB_NEW_LIST}

	return $Ret
}

FuncInitialEnv()
{
    chmod 755 /var
}

case $1 in
	start)
		RunMySQL=`/bin/get_key_value /etc/synoinfo.conf runmysql`
		case "$RunMySQL" in
		[Yy][Ee][Ss])
			;;
		*)
			echo "MySQL is not enabled. Skip..."
			exit;
			;;
		esac

                FuncInitialEnv

		VolHome=`/usr/syno/bin/servicetool --get-service-volume mysql`
		ServiceOnVolume=$?
		if [ ${ServiceOnVolume} -eq 0 ]; then
			echo "Let User to choose where to set MySQL..."
			exit;
		fi

		DataDir=${VolHome}/@database
		NeedUpgrade=1
		if [ ! -d ${DataDir}/mysql -o ! -f ${DataDir}/mysql/VERSION ]; then
			echo "Initialize MySQL..."
			mkdir $DataDir
			chown admin:users $DataDir
			su -l admin -c "/usr/syno/mysql/bin/mysql_install_db --datadir=${DataDir}/mysql --force"
			echo $MYSQL_VERSION > ${DataDir}/mysql/VERSION
			NeedUpgrade=0
		else
			chown admin:users $DataDir/mysql
			if [ -f ${DataDir}/mysql/VERSION ]; then
				grep $MYSQL_VERSION ${DataDir}/mysql/VERSION > /dev/null 2>&1
				if [ $? -eq 0 ]; then
					NeedUpgrade=0
				fi
			fi
		fi
		if [ $NeedUpgrade -eq 1 ]; then
			echo "Need to upgrade MySQL database. Starting..."
			UpgradeDatabase
			if [ $? -eq 0 ]; then
				echo $MYSQL_VERSION > ${DataDir}/mysql/VERSION
			fi
		fi

		echo "Starting MySQL..."
		${MYSQL_DIR}/share/mysql/mysql.server start --datadir=${DataDir}/mysql --pid-file=${PID_FILE} ${MYSQL_ARGS}
		echo "MYSQL data dir = ${DataDir}/mysql..."
		;;
	stop)
		echo "Stopping MySQL..."
		${MYSQL_DIR}/share/mysql/mysql.server stop --pid-file=${PID_FILE}
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	resetpassword)
		$0 stop
		sleep 3
		echo "use mysql;" >/tmp/mysql_init.$$
		echo "DELETE FROM user WHERE user='root';" >> /tmp/mysql_init.$$
		echo "GRANT ALL PRIVILEGES ON *.* TO 'root'@'localhost' IDENTIFIED BY '' WITH GRANT OPTION;" >> /tmp/mysql_init.$$
		${MYSQL_DIR}/bin/mysqld_safe --init-file=/tmp/mysql_init.$$ --pid-file=${PID_FILE} &
		sleep 20
		$0 stop
		rm /tmp/mysql_init.$$
		sleep 3
		;;
	backupdb)
		if [ -z "$2" -o -z "$3" ]; then
			echo "Usage: $1 backupdb destination_path backup_type[netbkp|localbkp]"
			return ${MYSQL_FAIL}
		fi
		BackupDatabase "$2" $3
		Ret=$?
		return $Ret
		;;
	restoredb)
		if [ -z "$2" -o -z "$3" ]; then
			echo "Usage: $1 restoredb source_path overwrite[yes|no]"
			return ${MYSQL_FAIL}
		fi
		RestoreDatabase "$2" $3
		Ret=$?
		return $Ret
		;;
	*)
		echo "Usage: $0 start|stop|backupdb|restoredb"
		;;
esac
