-- vim:ft=sql

BEGIN;

CREATE TABLE video_convert (
 video_path text NOT NULL,
 convert_file_path text NOT NULL,
 resolutionx int4 DEFAULT NULL,
 resolutiony int4 DEFAULT NULL,
 video_bitrate int4 DEFAULT NULL,
 vcodec text DEFAULT NULL,
 video_profile text DEFAULT NULL,
 video_level int4 DEFAULT NULL,
 acodec text DEFAULT NULL,
 audio_bitrate int4 DEFAULT NULL,
 audio_frequency int4 DEFAULT NULL,
 audio_channel int4 DEFAULT NULL,
 convert_type text NOT NULL,
 fs_online boolean DEFAULT TRUE,
 CONSTRAINT video_convert_pkey PRIMARY KEY (convert_file_path),
 CONSTRAINT video_convert_fk1 FOREIGN KEY (video_path) REFERENCES video (path) ON DELETE CASCADE ON UPDATE CASCADE
)
WITHOUT OIDS;
CREATE INDEX video_convert_convert_type_idx ON video_convert USING btree (convert_type);
CREATE INDEX video_convert_video_path_idx ON video_convert USING btree (video_path);

COMMIT;

