<?php
/* Copyright (c) 2010 Synology Inc. All rights reserved. */

// link to Synology RSS server
$RSS_FILE_PATH_DEF = "http://download.synology.com/download/DiskStation/genRSS.php";
$RSS_FILE_PATH = "";
$RSS_FILE_TEMP = "/var/run/autoupdate_tmp_file_RSS";
$FETCH_KEY_CMD = "/bin/get_key_value";
$SYNO_INFO_CONF = "/etc/synoinfo.conf";
$SYNO_INFO_CONF_DEF = "/etc.defaults/synoinfo.conf";
$DSM_VERSION = "/etc.defaults/VERSION";
$INFO_KEY_RSSSERVER = "rss_server";
$INFO_KEY_TIMEZONE = "timezone";
$INFO_KEY_UNIQUE = "unique";
$ECHO_CMD = "/bin/echo";
$CURL_CONNECT_TIMEOUT = 60;
$DSM_AVAILABLE_FILE = "/var/run/checkNewDSM.available";
$DSM_UNAVAILABLE_FILE = "/var/run/checkNewDSM.unavailable";
$DSM_ERROR_FILE = "/var/run/checkNewDSM.error";
$VERSION_KEYS = array("majorversion",
                      "minorversion",
                      "buildnumber");

function ErrLog($msg) {
    syslog(LOG_ERR, $msg);
}

function SendSysLog($isSuccess)
{
    $sysNotify = '/usr/syno/bin/synologset1';
    $sysTitle = 'sys info 0x11B01023';
    $sysTitleErr = 'sys err 0x11B01024';
    $sysCmd = '';
    if ($isSuccess) {
        $sysCmd = $sysNotify." ".$sysTitle;
    } else {
        $sysCmd = $sysNotify." ".$sysTitleErr;
    }
    if ('' != $sysCmd) {
        $res = system($sysCmd, $ret);
    }
}

function OnError($errMsg, $ret=false)
{
	global $DSM_ERROR_FILE;

	// don't output log if message is empty
	if ('' == $errMsg) {
		goto OutExit;
	}

    // send system error log
    SendSysLog(false);
    
    // error log
	if (is_null($ret) || false === $ret) {
		$errLog = $errMsg;
	} else {
	    $errLog = $errMsg." ret: ".$ret;
	}
	if ('' !== $errLog) {
	    ErrLog($errLog);
	} 
	
OutExit:
	// save error status
	touch($DSM_ERROR_FILE);

    // exit
    closelog();
    exit(-1);
}

function GetServerPath()
{
	global $FETCH_KEY_CMD;
	global $SYNO_INFO_CONF_DEF;
	global $INFO_KEY_RSSSERVER;
	global $RSS_FILE_PATH_DEF;

    $spCmd = sprintf("%s %s %s", $FETCH_KEY_CMD, $SYNO_INFO_CONF_DEF, $INFO_KEY_RSSSERVER);
    $path = '';
    if (file_exists($SYNO_INFO_CONF_DEF)) {
        $path = trim(system($spCmd, $ret));
    }

	if ('' == $path) {
		$path = $RSS_FILE_PATH_DEF;
		ErrLog("Error: failed to retrieve server path, use default: ".$RSS_FILE_PATH_DEF);
	}
    return $path;
}

function GetAndParseRSS($UserAgent)
{
    // timezone is used for load-balancing (not necessarily required)
    global $FETCH_KEY_CMD;
    global $SYNO_INFO_CONF;
	global $INFO_KEY_TIMEZONE;
    global $RSS_FILE_PATH;
	global $RSS_FILE_TEMP;
	global $CURL_CONNECT_TIMEOUT;

    $TzCmd = $FETCH_KEY_CMD." ".$SYNO_INFO_CONF." ".$INFO_KEY_TIMEZONE;
    $tz = trim(system($TzCmd, $ret));

	$isError = false;
	$errMsg = '';
    $ch = curl_init();
    if (FALSE == $ch) {
		$isError = true;
		$errMsg = "Error: failed to initiate curl";
		goto ErrOut;
    }
    $url = sprintf("%s?tz=%s", $RSS_FILE_PATH, $tz);
    $fp = fopen($RSS_FILE_TEMP, 'w');
    if (false == $fp) {
		$isError = true;
		$errMsg = "Error: failed to open temp file";
		goto ErrOut;
    }
    if (false == curl_setopt($ch, CURLOPT_URL, $url)) {
		$isError = true;
		$errMsg = "Error: failed to set url";
		goto ErrOut;
    }
    if (false == curl_setopt($ch, CURLOPT_FILE, $fp)) {
		$isError = true;
		$errMsg = "Error: failed to set output file";
		goto ErrOut;
    }
    if (false == curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $CURL_CONNECT_TIMEOUT)) {
		$isError = true;
		$errMsg = "Error: failed to set time out option";
		goto ErrOut;
    }
    if (false == curl_setopt($ch, CURLOPT_USERAGENT, $UserAgent)) {
		$isError = true;
		$errMsg = "Error: failed to set user agent option";
		goto ErrOut;
    }
    if (false == curl_exec($ch)) {
		$isError = true;
		//$errMsg = "Error: ".curl_error($ch);
		goto ErrOut;
    }
    $response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
    if ($response_code ==  '404') {
		$isError = true;
		//$errMsg = "Error: 404 not found!";
		goto ErrOut;
    }

ErrOut:

    curl_close($ch);

    if (false != $fp) {
        fclose($fp);
    }
	if ($isError) {
		OnError($errMsg);
	}

    // parse RSS
    $xml;
    if (file_exists($RSS_FILE_TEMP)) {
        $xml = @simplexml_load_file($RSS_FILE_TEMP);
        if (false === $xml || false == $xml)  {
            unlink($RSS_FILE_TEMP);
            OnError("Error: failed to load xml", false);   
        }
    } else {
        OnError("Error: failed to download xml file", false);
    }

    // remove temp RSS
    if (file_exists($RSS_FILE_TEMP)) {
        unlink($RSS_FILE_TEMP);
    }

    return $xml;
}

function GetUnique()
{
    global $FETCH_KEY_CMD;
	global $SYNO_INFO_CONF_DEF;
    global $INFO_KEY_UNIQUE;
    $uniqueCmd = $FETCH_KEY_CMD." ".$SYNO_INFO_CONF_DEF." ".$INFO_KEY_UNIQUE;
    $unique = trim(system($uniqueCmd, $ret));
    if ('' == $unique) {
        OnError("Error: failed to get unique model id!", $ret);
    }
    return $unique;    
}

function GetVersion()
{
    global $FETCH_KEY_CMD;
	global $DSM_VERSION; 
    global $VERSION_KEYS;

    $Version = array();
    
    foreach ($VERSION_KEYS as $key) {
        $cmd = $FETCH_KEY_CMD." ".$DSM_VERSION." ".$key;
        $result = system($cmd, $ret);
        $result = trim($result);
        if ('' == $result) {
            OnError("Error: failed to get version!", $rest);
        }
        $Version[$key] = $result;
    }
    return $Version;
}

function IsNewer($ver, $verNew) 
{
    global $VERSION_KEYS;
    if (sizeof($VERSION_KEYS) != sizeof($ver) ||
        sizeof($VERSION_KEYS) != sizeof($verNew) ||
        0 == sizeof($ver) ||
        0 == sizeof($verNew)) {
        ErrLog("Error version", false);
        return false;
    }
    
    foreach ($VERSION_KEYS as $key) {
        if ($verNew[$key] > $ver[$key]) {
            return true;
        } else if ($ver[$key] > $verNew[$key]) {
            return false;
        } else {
            continue;
        }
    }

   return false;
}

function IsNewDSMAvailable($rss, $unique, $version)
{
    global $VERSION_KEYS;
    $ret = array();
    
    if ('' == $unique || sizeof($VERSION_KEYS) != sizeof($version)) {
        OnError("Error: invalid unique or version", false);
    }

    if (false == $rss) {
        goto Out;
    }

        foreach ($rss->channel->item as $item) {
            $ver["majorversion"] = $item->MajorVer;
            $ver["minorversion"] = $item->MinorVer;
            $ver["buildnumber"]  = $item->BuildNum;
            
            $reqVer["majorversion"] = $item->ReqMajorVer;
            $reqVer["minorversion"] = $item->ReqMinorVer;
            $reqVer["buildnumber"]  = $item->ReqBuildNum;

            // newer release and meets previous requirement
            if (IsNewer($version, $ver) && 
                !IsNewer($version, $reqVer)) {
                
                foreach ($item->model as $model) {
                    // this release also applies to the current model
                    if ($model->mUnique == $unique) {
                        $ret = array("majorversion" => $ver["majorversion"],
                                     "minorversion" => $ver["minorversion"],
                                     "buildphase"   => 0,
                                     "buildnumber"  => $ver["buildnumber"],
                                     "builddate"    => 0,
                                     "downloadlink" => $model->mLink,
                                     "checksum"     => $model->mCheckSum);
                        goto Out;
                    }
                }
            }
        }
Out:
    return $ret;
}


/* main */
// open error log
openlog($argv[0], LOG_PID, LOG_USER);

// remove previous result
if (file_exists($DSM_AVAILABLE_FILE)) {
    unlink($DSM_AVAILABLE_FILE);
}
if (file_exists($DSM_UNAVAILABLE_FILE)) {
    unlink($DSM_UNAVAILABLE_FILE);
}
if (file_exists($DSM_ERROR_FILE)) {
	unlink($DSM_ERROR_FILE);
}

$UserAgent = $argv[1];
// get server path from synoinfo.conf
$RSS_FILE_PATH = GetServerPath();

// get and parse the rss file from server
$RSS = GetAndParseRSS($UserAgent);

// fetch unique (architechure id) and dsm version for this machine
$Unique = GetUnique();
$Version = GetVersion();

// query new available dsm using unique and current dsm version
$newDSM = IsNewDSMAvailable($RSS, $Unique, $Version);

// if there is new DSM available, save the information
if (0 != sizeof($newDSM)) {
    $outMsg = '';
    foreach ($newDSM as $key => $value) {
        $outMsg = $outMsg.$value." ";
    }

    if ('' != $outMsg) {
        $genVersion = sprintf("DSM %d.%d-%d",
                              $newDSM["majorversion"],
                              $newDSM["minorversion"],
                              $newDSM["buildnumber"]);
        $outMsg = $outMsg." ".$genVersion;
		$outCmd = sprintf("%s %s > %s", $ECHO_CMD, $outMsg, $DSM_AVAILABLE_FILE);
        $res = system($outCmd, $ret);
    } else {
        touch($DSM_UNAVAILABLE_FILE);
    }
} else {
    touch($DSM_UNAVAILABLE_FILE);
}
closelog();
?>
