<?php
/* Copyright (c) 2010 Synology Inc. All rights reserved. */
include(dirname(__FILE__).'/upgrade.inc');

$DOWNLOADDSMPID = '/var/run/downloadDSM.pid';
$DOWNLOADDIR = '/@autoupdate';
$DFCMD = '/bin/df -m';
$PATCHSIZEMB = 200;    // the number is consistent with MIN_UPGRADE_SIZE upgrade.cpp, modify both when necessary
$TMPDIR = '';
$ROOTDIR = '/';
$VOLUMEINITIAL = '/volume';
$VOLUMEUSBINITIAL = '/volumeUSB';
$FILTERINITIAL = '/^\/volume[0-9]{1,2}\/.+/';
$TMPINITIAL='/tmp';
$DOWNLOADLOG = '/var/run/downloadDSM.status';
$DOWNLOADLOGBAK = '/var/run/downloadDSM.status.bak';
$CHECKSUMCMD = '/usr/syno/bin/openssl';
$REMOVECMD = "/bin/rm";
$DownloadPercent = 0;
$downloadStatus = -1;
$isProcessRunning = 1;
$ret = 0;

function CheckPid($pid)
{
    $cmd = "ps | awk '{print $1}' | grep $pid";
    $result = system($cmd, $output);
    if ($result == $pid) {
        return true;
    }
    return false;
}

function UpdateStatus($percent, $process, $localFile, $filePath) 
{
    global $DOWNLOADLOG;
    global $DOWNLOADLOGBAK;
    global $DownloadPercent;

    $DownloadPercent = $percent;
    $cmd = sprintf("%s %s %s %s\n", $percent, $process, $localFile, $filePath);
    if ('' == $cmd) {
        return;
    } 

    $fp = fopen($DOWNLOADLOGBAK, "a");
    if (false != $fp) {
        if (false == ftruncate($fp, 0)) {
            syslog(LOG_ERR, "Failed to run ftruncate()");
        }
        if (false == fwrite($fp , $cmd)) {
            syslog(LOG_ERR, "Failed to fwrite");
        } 
        if (false == fflush($fp)) {
            syslog(LOG_ERR, "Failed to fflush");
        }
        fclose($fp);

		rename($DOWNLOADLOGBAK, $DOWNLOADLOG);
    }
}

function SendNotification($isDownloadSuccess, $outFile)
{
    global $NotificationSent;
	$sysCmd = '';
	$dsmCmd = '';
	$sysNotify = '/usr/syno/bin/synologset1';
	$sysSuccess = 'sys info 0x11B01021';
	$sysFailure = 'sys err 0x11B01022';
	$dsmNotify = '/usr/syno/bin/synodsmnotify';
	$dsmNotifySender = '@administrators';
	$dsmNotifyTitle = '"update:update_download_noti_title"';
    $dsmNotifyTitleErr = '"update:update_download_noti_title_err"';
    $dsmNotifyLinkTmpl =  '"<a {0} href=javascript:SYNO.SDS.AppLaunch(\'SYNO.SDS.ControlPanel.Instance\',{fn:\'SYNO.SDS.ControlPanel.Upgrade.Main\'})> {1} </a>"'; 
    $dsmNotifyLinkStyle = '"style=\'font-size:12px;text-decoration:underline;\'"';
    $dsmNotifyLink = "update:update_download_noti_link";

    $dsmMsg = sprintf('%s "%s" "%s"', $dsmNotifyLinkTmpl, $dsmNotifyLinkStyle, $dsmNotifyLink); 

	if ($isDownloadSuccess) {
        $sysCmd = $sysNotify." ".$sysSuccess." ".$outFile; 
        $dsmCmd = $dsmNotify." ".$dsmNotifySender." ".$dsmNotifyTitle." ".$dsmMsg;	
	} else {
		$sysCmd = $sysNotify." ".$sysFailure." ".$outFile;
        $dsmCmd = $dsmNotify." ".$dsmNotifySender." ".$dsmNotifyTitleErr." ".$dsmMsg;
	}

    if (false == $NotificationSent) {
        $NotificationSent = true;

        system($dsmCmd, $ret);
        system($sysCmd, $ret);
    }
}

function ClearPrevResults()
{
	global $DOWNLOADDSMPID;
	global $DOWNLOADLOG;

	// remove possible pid file
	if (file_exists($DOWNLOADDSMPID)) {
		unlink($DOWNLOADDSMPID);
	}

	// remove possible last downloaded patch
	if (file_exists($DOWNLOADLOG)) {
		$fp = fopen($DOWNLOADLOG, "r");
		if (false == $fp) {
			syslog(LOG_ERR, "Failed to open download status file");
			return false;
		}
		$line = trim(@fgets($fp, 1024));
		$tokens = split(" ", $line);

		// status file format:
		// [download percent] [is process running] [local file] [remote link]
		$tokens[2] = trim($tokens[2]);
		if (file_exists($tokens[2])) {
			unlink($tokens[2]);
		}
		fclose($fp);
		
		unlink($DOWNLOADLOG);
	} 
	return true;
}

function ArrayTrim($inArr)
{
	$j = 0;
	$outArr = array();
	for ($i = 0; $i < count($inArr); $i++) {
		if ("" != $inArr[$i]) {
			$outArr[$j++] = $inArr[$i];
		}
	}
	return $outArr;
}

function GetDownloadDir() 
{
	global $DFCMD;
	global $PATCHSIZEMB;
	global $DOWNLOADDIR;
	global $ROOTDIR;
	global $TMPINITIAL;
	global $VOLUMEINITIAL;
	global $FILTERINITIAL;

	$ret = '';
	$sizeLimit = $PATCHSIZEMB;
	$fp = popen($DFCMD, "r");
	if (false == $fp) {
		syslog(LOG_ERR, "fail to execute df command");
		goto OUT;
	}

	$isRootDirOK = false;
	while (!feof($fp))
	{
		$line = trim(@fgets($fp, 1024));
		$tokens = ArrayTrim(explode(" ", $line));
		if ( 0 == count($tokens)) {
			continue;
		}
		
		// make sure at least one of the local directory has enough room for patch file
		// the six cells 'df' returns: [Filesystem]  [1K-blocks]  [Used]  [Available]  [Use%]  [Mounted on]
		if (6 == count($tokens)) {
			if ($tokens[3] > $sizeLimit) {
				
				$tokens[5] = trim($tokens[5]);
				
				// skip /tmp directory
				if (0 === strncmp($tokens[5], $TMPINITIAL, strlen($TMPINITIAL))) {
					continue;
				}
				
				// check if root directory is ready for download
				if (0 === strncmp($tokens[5], $ROOTDIR, strlen($tokens[5]))) {
					$isRootDirOK = true;
					continue;
				}
				
				// Choose victim with name starts as '/volume' or '/volumeUSB' (US2)
				// but filter out those second level directoies since they could be encrypted share folders
				if (preg_match($FILTERINITIAL, $tokens[5])) {
					continue;
				}
				if (0 === strncmp($tokens[5], $VOLUMEINITIAL, strlen($VOLUMEINITIAL)) ||
					0 === strncmp($tokens[5], $VOLUMEUSBINITIAL, strlen($VOLUMEUSBINITIAL))) {
					$ret = sprintf("%s%s", $tokens[5], $DOWNLOADDIR);
					break;
				}
			}
		}
	}

	// if no other volume is available, put the file in root directory
	if ('' === $ret && $isRootDirOK) {
		$ret = $ROOTDIR;
	}

OUT:
	return $ret;
}

function DownloadCallback($totalSize, $downloadedSize, $uploaded)
{
	global $CHECKSUMCMD;
    global $OutFileName;
    global $OutFile;
    global $FileLink;
    global $FileVersion;
	global $FileCheckSum;
	global $NotificationSent;

    $percent = 0;
    if (0 < $totalSize && 0 < $downloadedSize) {
        $percent = 100*$downloadedSize/$totalSize;
        $percent = number_format($percent, 2, '.', '');
    }
    $percent = number_format($percent);

    if (100 == $percent) {
        UpdateStatus($percent, 0, $OutFile, $FileLink);
    } else {
        UpdateStatus($percent, 1, $OutFile, $FileLink);
    }
}

/* main */

// open error log
openlog($argv[0], LOG_PID, LOG_USER);

// check input parameters
if (4 != $argc) {
	echo "Usage: $argv[0] download_file_link file_version file_checksum\n";
	goto OUT;
}

// leave if dsm is being downloaded
if (file_exists($DOWNLOADDSMPID)) {
	$pid = system("cat $DOWNLOADDSMPID", $ret);
	if (CheckPid($pid)) {
		syslog(LOG_ERR, "download process $pid running, exit");
		goto OUT;
	}
} 

// find available download path for batch file
$TMPDIR = GetDownloadDir();
if ('' == $TMPDIR) {
	syslog(LOG_ERR, "no available download path");
	goto ERROUT;
}

// clear possible previous results
$savePath = $DOWNLOADDIR;
if (file_exists($savePath) && is_dir($savePath)) {
	$cmd = sprintf("%s -rf %s", $REMOVECMD, $savePath);
	$result = system($cmd, $ret);
}
if (file_exists($TMPDIR) && is_dir($TMPDIR)) {
	$cmd = sprintf("%s -rf %s", $REMOVECMD, $TMPDIR);
	$result = system($cmd, $ret);
}
if (false == ClearPrevResults()) {
	goto ERROUT;
}

// save the pid for current process
$thisPid = getmypid();

if (false == $thisPid) {
	syslog(LOG_ERR, "Failed to get pid for $argv[0]");
	goto ERROUT;
} else {
	$pidCmd = "echo '{$thisPid}' > $DOWNLOADDSMPID";
	system($pidCmd, $ret); 
	if (!file_exists($DOWNLOADDSMPID)) {
		syslog(LOG_ERR, "Failed  to save pid for $argv[0]");
		goto ERROUT;
	}
}

// create directory for temp patch file if necessary
if (!file_exists($TMPDIR)) {
	if (!mkdir($TMPDIR, 0700, true)) {
		syslog(LOG_ERR, "Failed to create $TMPDIR");
		goto ERROUT;
	}
}

// download
$list = split('[/\]', $argv[1]);
$OutFileName = $list[sizeof($list)-1];
if ($TMPDIR === $ROOTDIR) {
	$TMPDIR = '';
}
$OutFile = $TMPDIR.'/'.$OutFileName;
$FileLink = $argv[1];
$FileVersion = $argv[2];
$FileCheckSum = $argv[3];
$UserAgent = getUserAgent();
$NotificationSent = false;
$ConnectTimeOut = 30;
$DownloadTimeOut = 120;
$DownloadLimitLow = 128;    // in bytes

UpdateStatus(0, 0, $OutFile, $FileLink);

$ch = curl_init();
if (false == $ch) {
	syslog(LOG_ERR, "Error: failed to initiate curl");
	goto ERROUT;
}

$fp = fopen($OutFile, 'w');
if (false == $fp) {
    syslog(LOG_ERR, "Error: cannot open file handle.");
	goto ERROUT;
}

$curl_options = array(
    CURLOPT_URL              => $FileLink,
    CURLOPT_FILE             => $fp,
    CURLOPT_CONNECTTIMEOUT   => $ConnectTimeOut,
    CURLOPT_NOPROGRESS       => false,
    CURLOPT_BUFFERSIZE       => 1024,   
	CURLOPT_LOW_SPEED_LIMIT  => $DownloadLimitLow,
	CURLOPT_LOW_SPEED_TIME   => $DownloadTimeOut,
    CURLOPT_USERAGENT        => $UserAgent
);

if (false == curl_setopt_array($ch, $curl_options)) {
    syslog(LOG_ERR, "Error: failed to set curl option array");
    goto ERROUT;
}

if (false == curl_setopt($ch, CURLOPT_PROGRESSFUNCTION, 'DownloadCallback')) {
    syslog(LOG_ERR, "Error: failed to curl callback function");
    goto ERROUT;
}

if (false == curl_exec($ch)) {
	$msg = sprintf("failed executing curl: %s", curl_error($ch));
	syslog(LOG_ERR, $msg);
    SendNotification(false, $OutFileName);
    goto ERROUT;
}

$response_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
if ($response_code ==  '404') {
	$rMsg = sprintf("Cannot fetch %s, 404 not found", $FileLink);
	syslog(LOG_ERR, $rMsg);
	goto ERROUT;
}

curl_close($ch);

// send out notification
$stat = true;
if (100 != $DownloadPercent) {
	// download not completed
	$stat = false;
} else {
	// md5 checksum
	$runCmd = sprintf('%s md5 %s 2>/dev/null', $CHECKSUMCMD, $OutFile);
	$result  = system($runCmd, $ret);
	if (0 == $ret) {
		$checkSumList = split('=', $result);
		if (trim(end($checkSumList)) != $FileCheckSum) {
			syslog(LOG_ERR, "md5 checksum doesn't match");
			$stat = false;
		}
	}
}
SendNotification($stat, $OutFileName, $FileVersion);
if (false === $stat) {
	goto ERROUT;
}

// gracefully exit
if (false != $fp) {
	fclose($fp);
}

if (file_exists($DOWNLOADDSMPID)) {
	unlink($DOWNLOADDSMPID);
}

OUT:
closelog();
exit(0);

ERROUT:
// clear temporary result(s) and set download status to error
if (false != $fp) {
	fclose($fp);
}
ClearPrevResults();
UpdateStatus(50, 1, "*", "*");
closelog();
exit(-1);
?>
