#!/bin/sh
# Copyright (c) 2000-2007 Synology Inc. All rights reserved.

case $1 in
	start)
		LogFile="/dev/null"

		# Clean up eSATA and USB section in smb.conf
		/usr/syno/bin/synousbdisk -rcclean > ${LogFile} 2>&1

		echo "Starting Hotplug Handling Daemon ..."
		/usr/syno/sbin/hotplugd

		#mount the external SATA device if necessary
		/usr/syno/bin/synosata -bootup

		/usr/syno/sbin/eunit_info

		sleep 1
		killall -SIGUSR1 hotplugd
	;;
	stop)
		echo "Stopping Hotplug Handling Daemon ..."
		kill -9 `cat /var/run/hotplugd.pid | head -1` > /dev/null 2>&1
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
	;;
esac

