#!/bin/sh
# Copyright (c) 2000-2006 Synology Inc. All rights reserved.
KERNEL_VERSION=`uname -r`

case $1 in
	start)
		Support=0

		eval $(grep "^runpgsql=" /etc/synoinfo.conf)
                case "${runpgsql}" in
                [Yy][Ee][Ss])
                         ;;
                *)
                         echo "PGSQL service is disabled. Skip..."
                         exit 1;
                         ;;
                esac

		MediaSupport=`/bin/get_key_value /etc.defaults/synoinfo.conf supportmediaservice`
		case "$MediaSupport" in
		[Yy][Ee][Ss])
			Support=1
			;;
		*)
			;;
		esac

		PhotoSupport=`/bin/get_key_value /etc.defaults/synoinfo.conf supportphoto`
		case "$PhotoSupport" in
		[Yy][Ee][Ss])
			Support=1
			;;
		*)
			;;
		esac

		iTunesSupport=`/bin/get_key_value /etc.defaults/synoinfo.conf supportitunes`
		case "iTunesSupport" in
		[Yy][Ee][Ss])
			Support=1
			;;
		*)
			;;
		esac

		AudioSupport=`/bin/get_key_value /etc.defaults/synoinfo.conf support_audio`
		case "AudioSupport" in
		[Yy][Ee][Ss])
			Support=1
			;;
		*)
			;;
		esac

		if [ $Support -eq 1 ];then
			echo "Starting Synology Indexing Daemon ..."
			case "$KERNEL_VERSION" in
			"2.4.22-uc0" | "2.6.15" | "2.6.24")
				sleep 180 && /usr/syno/sbin/synoindexd &
				;;
			*)
				/usr/syno/sbin/synoindexd
				;;
			esac
		else
			echo "No related services are supported. Skip..."
			exit;
		fi
	;;
	stop)
		echo "Stopping Synology Indexing Daemon ..."
		killall synoindexd > /dev/null 2>&1
		;;
	restart)
		$0 stop
		sleep 1
		$0 start
		;;
	*)
		echo "Usage: $0 start|stop|restart"
	;;
esac

