/* Copyright (c) 2013 Synology Inc. All rights reserved. */

Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Util={MimeType:{ogg:"audio/ogg",ogv:"video/ogg",wav:"audio/wav",mp3:"audio/mpeg",m4a:"audio/mp4",m4b:"audio/mp4",m4v:"video/mp4",mov:"video/mp4"},utfencode:function(b){var e,d,a="";b=b.replace(/\r\n/g,"\n");for(e=0;e<b.length;e++){d=b.charCodeAt(e);if(d<128){a+=String.fromCharCode(d)}else{if((d>127)&&(d<2048)){a+=String.fromCharCode((d>>6)|192);a+=String.fromCharCode((d&63)|128)}else{a+=String.fromCharCode((d>>12)|224);a+=String.fromCharCode(((d>>6)&63)|128);a+=String.fromCharCode((d&63)|128)}}}return a},bin2hex:function(e){var c,d,g=0,b=[];e=SYNO.SDS.VideoPlayer.Util.utfencode(e)+"";g=e.length;for(d=0;d<g;d++){b[d]=e.charCodeAt(d).toString(16).replace(/^([\da-f])$/,"0$1")}return b.join("")},getDownloadLink:function(c){var b,a;b=c.substr(1+c.lastIndexOf("/")).replace(/[\/\\\:\?\>\<\*\"\;\|\#\%]/g,"-");a=Ext.util.Cookies.get("id");return String.format("/fbdownload/{0}?sid={1}&mime=1&dlink={2}",encodeURIComponent(b),encodeURIComponent(a),SYNO.SDS.VideoPlayer.Util.bin2hex(c))},formatTime:function(a){var b="";a=parseInt(a,10);if(a>3600){b+=parseInt(a/3600,10)+":"}b+=String.leftPad(parseInt((a%3600)/60,10),2,"0")+":"+String.leftPad(a%60,2,"0");return b},controller:null,launchFn:function(b){if(this.controller==null){this.controller=new SYNO.SDS.VideoPlayer.Controller()}var c=b[0].get("path");var a=c.substr(1+c.lastIndexOf("/"));this.controller.updatePlayer(a);if(this.controller.getPlayerName()=="VLC"){SYNO.SDS.WindowLaunch("SYNO.SDS.VideoPlayer.Application",{path:b[0].get("path"),file_id:b[0].get("file_id")})}else{SYNO.SDS.AppLaunch("SYNO.SDS.VideoPlayer.Application",{fb_recs:b})}},createVLCElement:function(e,f,d,a,c){var b;if(Ext.isIE){b=e.createChild({tag:"object",id:f,classid:"clsid:9BE31822-FDAD-461B-AD51-BE1D1C159921",width:d||"100%",height:a||"100%",style:c||"",cn:[{tag:"param",name:"Src",value:""},{tag:"param",name:"wmode",value:"transparent"},{tag:"param",name:"toolbar",value:"false"}]})}else{b=e.createChild({tag:"embed",id:f,type:"application/x-vlc-plugin",version:"VideoLAN.VLCPlugin.2",width:d||"100%",height:a||"100%",style:c||"",wmode:"transparent",src:"",toolbar:"false"})}return b},testVLCSupported:function(a){if(Ext.isBoolean(SYNO.SDS.VideoPlayer.Util.isVLCSupport())){SYNO.SDS.VideoPlayer.Util.testVLCSupportedReadyDone(SYNO.SDS.VideoPlayer.Util.isVLCSupport(),a);return}if(!SYNO.SDS.VideoPlayer.VLC.prototype.isSupported()){SYNO.SDS.VideoPlayer.Util.testVLCSupportedReadyDone(false,a);return}if(SYNO.SDS.VideoPlayer.VLC.prototype.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")||SYNO.SDS.VideoPlayer.VLC.prototype.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC")){SYNO.SDS.VideoPlayer.Util.testVLCSupportedReadyDone(true,a);return}SYNO.SDS.VideoPlayer.Util.createVLCElement(Ext.getBody(),"_vlc__test_video_player",1,1,'style="position: absolute; top: 0px; left: -10000px;"');SYNO.SDS.VideoPlayer.Util.testVLCSupportedReady.defer(1000,this,[a])},testVLCSupportedReady:function(c,b){b=b||1;var a=Ext.get("_vlc__test_video_player");if(!a||b>11){SYNO.SDS.VideoPlayer.Util.testVLCSupportedReadyDone(false,c,a);return}if(!Ext.isEmpty(a.dom.VersionInfo)){SYNO.SDS.VideoPlayer.Util.testVLCSupportedReadyDone(true,c,a);return}b++;arguments.callee.defer(200,this,[c,b])},testVLCSupportedReadyDone:function(a,c,b){if(b){Ext.destroy(b)}SYNO.SDS.VideoPlayer.isVLCSupported=a;if(Ext.isFunction(c)){c()}},isVLCSupport:function(a){if(!Ext.isBoolean(SYNO.SDS.VideoPlayer.isVLCSupported)&&!SYNO.SDS.VideoPlayer.isVLCSupportedProcessing){SYNO.SDS.VideoPlayer.isVLCSupportedProcessing=true;SYNO.SDS.VideoPlayer.Util.testVLCSupported(a)}else{if(Ext.isBoolean(SYNO.SDS.VideoPlayer.isVLCSupported)&&Ext.isFunction(a)){a()}}return SYNO.SDS.VideoPlayer.isVLCSupported}};SYNO.SDS.VideoPlayer.ZoomComboBox=Ext.extend(Ext.form.ComboBox,{onOverClass:"over",onClickClass:"click",afterRender:function(){SYNO.SDS.VideoPlayer.ZoomComboBox.superclass.afterRender.call(this);this.mon(this.el,"focus",this.el.blur,this.el);this.wrap.hover(this.onWrapHover.createDelegate(this,[true]),this.onWrapHover.createDelegate(this,[false]));this.mon(this.wrap,"mousedown",this.onWrapClick.createDelegate(this));this.mon(this,"enable",this.onWrapEnable.createDelegate(this,[true]));this.mon(this,"disable",this.onWrapEnable.createDelegate(this,[false]))},setValue:function(a){SYNO.SDS.VideoPlayer.ZoomComboBox.superclass.setValue.call(this,a);this.el.dom.value="";return this},onSelect:function(a,c){SYNO.SDS.VideoPlayer.ZoomComboBox.superclass.onSelect.call(this,a,c);var b=this.view.getNodes();Ext.each(b,function(d){Ext.fly(d).removeClass("syno_video_player_zoom_x-combo-active")});Ext.fly(this.view.getNode(c)).addClass("syno_video_player_zoom_x-combo-active")},onWrapHover:function(a){if(!this.onOverClass){return}if(this.disabled){return}if(a){Ext.fly(this.wrap).addClass(this.onOverClass)}else{Ext.fly(this.wrap).removeClass(this.onOverClass)}},onWrapClick:function(){if(!this.onClickClass){return}if(this.disabled){return}var c=this.wrap;var a=this.onClickClass;Ext.fly(c).addClass(a);var e=Ext.getDoc(),b=function(){Ext.fly(c).removeClass(a);e.removeListener("mouseup",b)};e.on("mouseup",b)},onWrapEnable:function(a){if(true==a){this.el.removeClass("disabled")}else{this.el.addClass("disabled")}}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.SubParser=Ext.extend(Ext.util.Observable,{subtitles:null,destroy:function(){delete this.subtitles},parseSeconds:function(b){var d,c,a,e=0;if(!b){return}d=b.split(":");a=d.length;if(a>3){return}for(c=0;c<a;++c){e=e*60+parseFloat(d[c].replace(",","."))}return e},parseSrt:function(e){var c,b,d,f,a,g;this.clear();e=e.replace(/\r\n|\r/g,"\n").trim();f=e.split("\n\n");for(c=0;c<f.length;++c){d=f[c].split("\n");if(d.length<3){continue}d.shift();a=d.shift().split(" --> ");g=d.join("<br/>");this.subtitles.push({from:this.parseSeconds(a[0]),to:this.parseSeconds(a[1]),text:g})}},clear:function(){this.subtitles=[]},getText:function(d){var b,a,c,f=this.subtitles,e=[];if(!f){return""}a=f.length;for(b=0;b<a;++b){c=f[b];if(d<c.from){break}if(c.from<=d&&d<=c.to){e.push(c.text)}}return e.join("<br/>")}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Player=Ext.extend(Ext.Component,{name:"",pluginInit:false,play:Ext.emptyFn,pause:Ext.emptyFn,stop:Ext.emptyFn,seek:Ext.emptyFn,getTime:Ext.emptyFn,getDuration:Ext.emptyFn,setVolume:Ext.emptyFn,getVolume:Ext.emptyFn,getSubtitles:Ext.emptyFn,setSubtitle:Ext.emptyFn,getState:Ext.emptyFn,playUrl:Ext.emptyFn,canPlayType:Ext.emptyFn,canTestPlayAgain:Ext.emptyFn,init:Ext.emptyFn,setVisible:Ext.emptyFn,isSupported:Ext.emptyFn,clear:function(){if(this.el){this.el.hide()}},destroy:function(){this.clear()},detectPlugin:function(){var b,d,a,c=navigator.plugins||[],f=arguments;if(Ext.isIE){try{if((new ActiveXObject(f[0]))){return true}}catch(g){}return false}for(b=0;b<c.length;++b){a=true;for(d=1;d<f.length;++d){if(-1===c[b].name.indexOf(f[d])&&-1===c[b].description.indexOf(f[d])){a=false;break}}if(a){return true}}return false}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Null=Ext.extend(SYNO.SDS.VideoPlayer.Player,{name:"Null",error:false,init:function(){return true},canPlayType:function(){return false},playUrl:function(){this.error=true},getState:function(){return this.error?"error":"stop"}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.HTML5=Ext.extend(SYNO.SDS.VideoPlayer.Player,{name:"HTML5",player:null,player_id:"_html5_video_player",stopped:false,init:function(){var a=document.createElement("video");if(!a||!a.canPlayType){return false}return true},canPlayType:function(b){var a=document.createElement("video"),c=SYNO.SDS.VideoPlayer.Util.MimeType[b]||("video/"+b);if(!a||!a.canPlayType){return false}return a.canPlayType(c)},playUrl:function(a){if(Ext.isChrome){this.destroy()}this.createPlayer();this.player.src=a;this.play();this.setVolume(this.controller.volume)},play:function(){if(this.pluginInit){if(this.stopped){this.stopped=false;try{this.player.currentTime=0}catch(a){}}this.player.play()}},pause:function(){if(this.pluginInit){this.player.pause()}},stop:function(){if(this.pluginInit){this.stopped=true;this.player.pause()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.duration){this.player.currentTime=a}},getTime:function(){if(!this.pluginInit){return -1}return this.player.currentTime},getDuration:function(){if(!this.pluginInit){return -1}return this.player.duration},setVolume:function(a){if(this.pluginInit){this.player.volume=a/100}},getVolume:function(){if(!this.pluginInit){return -1}return this.player.volume*100},getState:function(){if(!this.pluginInit){return}if(this.player.error){return"error"}if(this.player.ended||this.player.HAVE_NOTHING===this.player.readyState||this.stopped){return"stop"}if(this.player.paused){return"pause"}if(this.player.HAVE_CURRENT_DATA>=this.player.readyState){return"buffer"}return"play"},setVisible:function(a){if(Ext.isSafari&&this.el){this.el.setVisible(a)}},getVideoResolution:function(){if(!this.player){return}return{width:this.player.videoWidth,height:this.player.videoHeight}},createPlayer:function(){if(!this.player){this.el=Ext.get(this.player_id)||this.controller.container.createChild({tag:"video",id:this.player_id,style:{width:"100%",height:"100%"}});this.player=this.el.dom;this.pluginInit=true}this.el.enableDisplayMode();this.el.show();this.player.pause();return this.player}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Flash=Ext.extend(SYNO.SDS.VideoPlayer.Player,{name:"Flash",player:null,player_id:"_flash_video_player",url:null,error:false,init:function(){return this.detectPlugin("ShockwaveFlash.ShockwaveFlash","Shockwave","Flash")},clear:function(){if(this.player){delete this.player}if(this.el){Ext.destroy(this.el);delete this.el}this.pluginInit=false},canPlayType:function(a){if("flv"===a||"mp3"===a||"mov"===a||"mp4"===a||"m4a"===a||"m4v"===a){return true}return false},playUrl:function(a){this.url=a;this.error=false;this.createPlayer();if(this.pluginInit){this.onFlowPlayerReady()}},play:function(){if(this.pluginInit){this.player.DoPlay()}},pause:function(){var a=this.getState();if(!this.pluginInit||("buffer"!==a&&"play"!==a)){return}this.player.Pause()},stop:function(){var a=this.getState();if(this.pluginInit){if("buffer"!==a&&"play"!==a){this.play()}this.player.DoStop()}},seek:function(a){if(this.pluginInit&&a>=0&&a<=this.player.getDuration()){this.player.Seek(a)}},getTime:function(){if(!this.pluginInit){return -1}return this.player.getTime()},getDuration:function(){if(!this.pluginInit){return -1}return this.player.getDuration()},setVolume:Ext.emptyFn,getVolume:function(){return -1},getState:function(){if(!this.pluginInit){return}if(this.error){return"error"}if(this.player.getIsPlaying()){if(0>=this.getTime()&&100>this.player.getPercentLoaded()){return"buffer"}return"play"}if(this.player.getIsPaused()){return"pause"}return"stop"},getVideoResolution:function(){return{width:0,height:0}},createPlayer:function(){if(!this.player){window.onFlowPlayerReady=this.onFlowPlayerReady.createDelegate(this);if(Ext.isIE){this.el=this.controller.container.createChild({tag:"object",id:this.player_id,classid:"clsid:D27CDB6E-AE6D-11cf-96B8-444553540000",width:"100%",height:"100%",cn:[{tag:"param",name:"movie",value:this.controller.baseURL+"/FlowPlayerWhite.swf"},{tag:"param",name:"flashvars",value:"config={&quot;hideControls&quot;:true,&quot;loop&quot;:false,&quot;autoPlay&quot;:false,&quot;initialScale&quot;:&quot;fit&quot;}"},{tag:"param",name:"wmode",value:"transparent"},{tag:"param",name:"AllowScriptAccess",value:"always"},{tag:"param",name:"AllowFullScreen",value:"true"}]})}else{this.el=this.controller.container.createChild({tag:"embed",id:this.player_id,src:this.controller.baseURL+"/FlowPlayerWhite.swf",type:"application/x-shockwave-flash",width:"100%",height:"100%",wmode:"transparent",AllowScriptAccess:"always",AllowFullScreen:"true",flashvars:"config={&quot;hideControls&quot;:true,&quot;loop&quot;:false,&quot;autoPlay&quot;:false,&quot;initialScale&quot;:&quot;fit&quot;}"})}this.player=Ext.getDom(this.player_id)}window.onStreamNotFound=this.onError.createDelegate(this);return this.player},onError:function(){this.error=true},onFlowPlayerReady:function(){window.onFlowPlayerReady=Ext.emptyFn;if(!this.player){return}this.pluginInit=true;this.player.DoStop();this.player.Reset();if(this.url){this.player.playClip({url:this.url,scaling:"fit"});this.setVolume(this.controller.volume)}}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.VLC=Ext.extend(SYNO.SDS.VideoPlayer.Player,{name:"VLC",player:null,player_id:"_vlc_video_player",url:null,playlistItemId:0,init:function(){return this.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC")||this.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")||!!SYNO.SDS.VideoPlayer.isVLCSupported},isSupported:function(){var a=Ext.urlDecode(location.search.substr(1));if(!a.supportVLC){if((Ext.isMac&&Ext.isSafari)){return false}}return true},canTestPlayAgain:function(){return("http:"==window.location.protocol)},canPlayType:function(a){if("ogv"===a){a="ogg"}return"ogg"!==a},playUrl:function(a){this.url=a;this.createPlayer();if(this.pluginInit){this.onVLCReady()}},play:function(){if(!this.pluginInit){return}if(6===this.getPlayerState()){this.player.playlist.playItem(this.playlistItemId)}else{this.player.playlist.play()}},pause:function(){var a=this.getState();if(this.pluginInit&&("buffer"===a||"play"===a)){this.player.playlist.togglePause()}},stop:function(){var a=this.getState();if(this.pluginInit&&("stop"!==a&&"error"!==a)){this.player.playlist.stop()}},seek:function(a){a*=1000;if(this.pluginInit&&a>=0&&a<=this.player.input.length){this.player.input.time=a}},getTime:function(){if(!this.pluginInit){return -1}return this.player.input.time/1000},getDuration:function(){if(!this.pluginInit){return -1}return this.player.input.length/1000},setVolume:function(a){if(this.pluginInit){this.player.audio.volume=a}},getVolume:function(){if(!this.pluginInit){return -1}return this.player.audio.volume},getSubtitles:function(){var a,b,c=[];if(!this.pluginInit){return[]}try{b=this.player.subtitle.count;for(a=1;a<b;++a){c.push(this.player.subtitle.description(a))}}catch(d){}return c},setSubtitle:function(a){var b=this.getState();if(!this.pluginInit||("play"!==b&&"pause"!==b)){return}try{if(0===this.player.subtitle.count){return}a++;if(0>a||a>=this.player.subtitle.count){a=0}this.player.subtitle.track=a}catch(c){}},getPlayerState:function(){var a=0;try{a=this.player.input.state}catch(b){}return a},getState:function(){var a;if(!this.pluginInit){return}switch(this.getPlayerState()){case 0:case 5:case 6:a="stop";break;case 1:case 2:a="buffer";break;case 3:a="play";break;case 4:a="pause";break;case 7:a="error";break;default:a="error"}return a},createPlayer:function(){if(!this.player){this.el=SYNO.SDS.VideoPlayer.Util.createVLCElement(this.controller.container,this.player_id);this.player=Ext.getDom(this.player_id);this.onVLCReady.defer(1000,this)}this.el.enableDisplayMode();this.el.show();return this.player},fitPlayer:function(){if(this.el){this.el.setSize("100%","100%")}},adjustPlayerWidthHack:function(){if(this.el){this.el.setWidth(this.el.getWidth()+1);this.el.setWidth(this.el.getWidth()-1)}},getVideoResolution:function(){if(!this.player){return}return{width:this.player.video.width,height:this.player.video.height}},onVLCReady:function(){if(!this.player){return}if(this.player.VersionInfo){this.pluginInit=true;this.fitPlayer.defer(100,this);this.fitPlayer.defer(500,this);if(this.url){this.player.playlist.items.clear();this.playlistItemId=this.player.playlist.add(this.url);this.player.playlist.playItem(this.playlistItemId);this.setVolume(this.controller.volume)}if(Ext.isIE){this.adjustPlayerWidthHack()}return}arguments.callee.defer(100,this)}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Controller=Ext.extend(Ext.Component,{volume:50,player:null,plugins:null,constructor:function(a){var b;if("https:"==window.location.protocol){b=[new SYNO.SDS.VideoPlayer.Null({controller:this}),new SYNO.SDS.VideoPlayer.HTML5({controller:this}),new SYNO.SDS.VideoPlayer.Flash({controller:this}),new SYNO.SDS.VideoPlayer.VLC({controller:this})]}else{b=[new SYNO.SDS.VideoPlayer.Null({controller:this}),new SYNO.SDS.VideoPlayer.VLC({controller:this}),new SYNO.SDS.VideoPlayer.HTML5({controller:this}),new SYNO.SDS.VideoPlayer.Flash({controller:this})]}this.plugins=[];Ext.each(b,function(c){this.addManagedComponent(c);if(false!==c.isSupported()&&c.init()){this.plugins.push(c)}},this);this.player=this.plugins[0];SYNO.SDS.VideoPlayer.Controller.superclass.constructor.apply(this,arguments)},isPlayerSupported:function(name){var fn,ret=false,className="SYNO.SDS.VideoPlayer."+name;try{eval(String.format("fn = new {0}({controller: this});",className));ret=(false!==fn.isSupported())}catch(err){}return ret},isPlayerInstalled:function(a){var b=false;Ext.each(this.plugins,function(c){if(a===c.name){b=true;return false}});return b},getPlayerName:function(){return this.player.name},updatePlayer:function(a){var b=this.getFileExt(a);if(!this.player||false===this.player.canTestPlayAgain()||!this.player.canPlayType(b)){if(this.player){this.player.clear();delete this.player;this.player=null}Ext.each(this.plugins,function(c){if(c.canPlayType(b)){this.player=c;return false}},this)}if(!this.player){this.player=this.plugins[0]}},playUrl:function(a,b){var c=this.getFileExt(a);if(!this.player||false===this.player.canTestPlayAgain()||!this.player.canPlayType(c)){if(this.player){this.player.clear();delete this.player;this.player=null}Ext.each(this.plugins,function(d){if(d.canPlayType(c)){this.player=d;return false}},this)}if(!this.player){this.player=this.plugins[0]}this.player.playUrl(b)},play:function(){this.player.play()},pause:function(){this.player.pause()},stop:function(){this.player.stop()},getVolume:function(){var a=this.player.getVolume();if(a>=0){this.volume=a}return a},setVolume:function(a){this.volume=a;this.player.setVolume(a)},seek:function(a){this.player.seek(a)},getTime:function(){return this.player.getTime()},getDuration:function(){return this.player.getDuration()},getSubtitles:function(){return this.player.getSubtitles()},setSubtitle:function(a){this.player.setSubtitle(a)},getState:function(){return this.player.getState()},setVisible:function(a){this.container.setVisible(a);this.player.setVisible(a)},getResolution:function(){return this.player.getVideoResolution()},getFileExt:function(a){var b=(/[.]/.exec(a))?/[^.]+$/.exec(a)[0]:"";return b.toLowerCase()}});Ext.namespace("SYNO.SDS.VideoPlayer");SYNO.SDS.VideoPlayer.Application=Ext.extend(SYNO.SDS.AppInstance,{appWindowName:"SYNO.SDS.VideoPlayer.MainWindow",constructor:function(){SYNO.SDS.VideoPlayer.Application.superclass.constructor.apply(this,arguments)}});SYNO.SDS.VideoPlayer.isVLCSupported=undefined;SYNO.SDS.VideoPlayer.MainWindow=Ext.extend(SYNO.SDS.AppWindow,{pinable:false,lastState:"",emptyTimeText:"--:--",statusRunner:null,btnPlay:null,currTime:null,totalTime:null,seekBar:null,volBar:null,subtitleSelect:null,zoomSelect:null,videoContainer:null,subtitleContainer:null,subParser:null,controller:null,bbarWidth:510,seekBarProgressOffset:13,volBarProgressOffset:8,zoomArray:[[0.5,"50%"],[1,"100%"],[2,"200%"]],zoomSelected:false,constructor:function(a){SYNO.SDS.VideoPlayer.MainWindow.superclass.constructor.call(this,Ext.apply({showHelp:false,width:640,height:500,minWidth:640,minHeight:380,cls:"syno_video_player",layout:"border",bodyStyle:{background:"black"},listeners:{scope:this,resize:this.updateSize},items:[{itemId:"video",region:"center",layout:"fit",unstyled:true},{itemId:"subtitle",region:"south",layout:"fit",height:SYNO.SDS.Session.standalone?80:40,unstyled:true,cls:SYNO.SDS.Session.standalone?"subtitleContainer_standalone":"subtitleContainer"}],bbar:[{itemId:"play",iconCls:"play",scope:this,handler:this.onClickPlay},{iconCls:"stop",scope:this,handler:this.onClickStop},{itemId:"subtitleSelect",ctCls:"subtitleSelect",listClass:"syno_video_player",shadow:false,hideTrigger:true,xtype:"combo",width:132,editable:false,mode:"local",triggerAction:"all",valueField:"value",displayField:"display",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],sortInfo:{field:"value",direction:"ASC"}}),listeners:{scope:this,expand:function(b){b.list.useShim=true},select:function(b,c){this.selectSubtitle(c.get("value"))}}},{xtype:"tbspacer",width:5},new SYNO.SDS.VideoPlayer.ZoomComboBox({itemId:"zoomSelect",ctCls:"zoomSelect",listClass:"syno_video_player_zoom",disabledClass:"zoom_select_disable",hideTrigger:true,xtype:"combo",width:60,editable:false,mode:"local",triggerAction:"all",valueField:"value",displayField:"display",store:new Ext.data.ArrayStore({autoDestroy:true,fields:["value","display"],sortInfo:{field:"value",direction:"ASC"}}),listeners:{scope:this,select:function(b,c){this.selectZoom(c)}}}),{itemId:"currTime",cls:"currTime",xtype:"tbtext",width:50},{itemId:"seekBar",cls:"seekbar",xtype:"slider",width:50,animate:false,increment:1,minValue:0,maxValue:100,listeners:{scope:this,change:this.onSeekBarChange,changecomplete:this.onSeek,drag:this.onSeekDrag}},"->",{itemId:"totalTime",cls:"totalTime",xtype:"tbtext",width:50},{itemId:"volBar",cls:"volbar",xtype:"slider",width:136,animate:false,increment:1,minValue:0,maxValue:100,listeners:{scope:this,change:this.onVolBarChange,changecomplete:this.onVolume,drag:this.onVolumeDrag}}]},a));this.btnPlay=this.getBottomToolbar().getComponent("play");this.currTime=this.getBottomToolbar().getComponent("currTime");this.totalTime=this.getBottomToolbar().getComponent("totalTime");this.seekBar=this.getBottomToolbar().getComponent("seekBar");this.volBar=this.getBottomToolbar().getComponent("volBar");this.subtitleSelect=this.getBottomToolbar().getComponent("subtitleSelect");this.videoContainer=this.getComponent("video").body;this.subtitleContainer=this.getComponent("subtitle");this.zoomSelect=this.getBottomToolbar().getComponent("zoomSelect");this.zoomSelect.getStore().loadData(this.zoomArray);this.subParser=new SYNO.SDS.VideoPlayer.SubParser({});this.seekProgress=Ext.DomHelper.insertBefore(this.seekBar.thumbs[0].el,{tag:"div",cls:"progress"},true);this.volProgress=Ext.DomHelper.insertBefore(this.volBar.thumbs[0].el,{tag:"div",cls:"progress"},true);this.subtitleSelect.wrap.addClassOnOver("over");this.subtitleSelect.wrap.addClassOnClick("click");this.addManagedComponent(this.subParser);this.statusRunner=this.addTask({interval:500,scope:this,run:this.updateStatus});this.updateSize();this.resetStatus();this.xPadding=0;this.yPadding=this.getFrameHeight()},selectZoom:function(d){var c=this.controller.getState();if("stop"===c||"error"===c){this.zoomSelect.clearValue();return}var b=d.get("value");var a=this.controller.getResolution();a={width:Math.max(a.width*b+this.xPadding,this.minWidth),height:Math.max(a.height*b+this.yPadding,this.minHeight)};if(a.width>SYNO.SDS.Desktop.getWidth()||a.height>SYNO.SDS.Desktop.getHeight()){this.maximize();return}this.restore();this.zoomSelected=true;this.setSize(a.width,a.height);this.forceRepaint()},forceRepaint:function(){if(this.controller.getPlayerName()!="HTML5"){return}this.hide(true);this.show.defer(1,this)},doDelayedClose:function(){var a=this.controller.getState();if(!a||("stop"!==a&&"error"!==a)){this.resetStatus();arguments.callee.defer(1000,this);return}this.onCloseCallBack(true);this.doClose()},onCloseCallBack:function(a,c){c=c||this.close_url;if(c){var b=new Ajax.Request(c,{asynchronous:Ext.isBoolean(a)?a:false,requestTimeout:10,method:"GET"});if(this.close_url){this.close_url=null}}},onClose:function(){if(!this.closed&&false!==SYNO.SDS.VideoPlayer.MainWindow.superclass.onClose.apply(this,arguments)){this.closed=true;this.resetStatus();this.doDelayedClose()}return false},onOpen:function(a){SYNO.SDS.VideoPlayer.MainWindow.superclass.onOpen.apply(this,arguments);if(a&&!a.requestURL&&a.closeURL){Ext.EventManager.on(window,"unload",this.onCloseCallBack.createDelegate(this,[false,a.closeURL]),this)}return this.onRequest.apply(this,arguments)},onRequest:function(a){SYNO.SDS.VideoPlayer.MainWindow.superclass.onRequest.apply(this,arguments);SYNO.SDS.VideoPlayer.Util.isVLCSupport(this.onRequestDeferDone.createDelegate(this,[a]))},onRequestDeferDone:function(a){if(!this.controller){var b=this.jsConfig.jsBaseURL;this.controller=new SYNO.SDS.VideoPlayer.Controller({container:this.videoContainer,baseURL:b});this.addManagedComponent(this.controller)}if(a&&a.requestURL&&a.url){Ext.Ajax.request({method:"GET",url:a.requestURL,scope:this,callback:function(j,f,l){if(this.isDestroyed){return}var h,m;try{m=Ext.util.JSON.decode(l.responseText)}catch(i){}if(f&&m&&m.success){var g={},c=a.urlParams,d=a.closeParams,k;h=m.data;if(c){c=Ext.decode(c);for(k in c){if(c.hasOwnProperty(k)&&!Ext.isEmpty(h[k])){g[c[k]]=h[k]}}a.url=Ext.urlAppend(a.url,Ext.urlEncode(g))}if(d){g={};d=Ext.decode(d);for(k in d){if(d.hasOwnProperty(k)&&!Ext.isEmpty(h[k])){g[d[k]]=h[k]}}a.closeURL=Ext.urlAppend(a.closeURL,Ext.urlEncode(g))}}Ext.EventManager.on(window,"unload",this.onCloseCallBack.createDelegate(this,[false,a.closeURL]),this);this.doRequest(a)}});return}this.doRequest(a)},doRequest:function(a){if(a&&a.closeURL){this.onCloseCallBack(true);this.close_url=a.close_url}if(a&&a.path&&a.file_id){this.play(a.path,a.file_id);return}if(a&&a.url){this.playurl(a.path,a.url,a.name);return}if(!a||!a.fb_recs){return}this.play(a.fb_recs[0].get("path"),a.fb_recs[0].get("file_id"))},onClickPlay:function(){var a=this.controller.getState();if("buffer"===a||"play"===a){this.controller.pause()}else{this.controller.play()}},onClickStop:function(){this.controller.stop()},onSeek:function(b,c){var a=this.controller.getDuration();this.controller.seek(a*c/100)},onSeekDrag:function(b){var a=this.controller.getDuration(),c=b.getValue();this.controller.seek(a*c/100)},onVolume:function(a,b){this.controller.setVolume(b)},onVolumeDrag:function(a){this.controller.setVolume(a.getValue())},onSeekBarChange:function(){var a=this.seekBar.thumbs[0].el.getLeft(true);this.seekProgress.setWidth(this.seekBarProgressOffset+a)},onVolBarChange:function(){var a=this.volBar.thumbs[0].el.getLeft(true);this.volProgress.setWidth(this.volBarProgressOffset+a)},isAlwaysOnTop:function(){if(!this.controller){return false}var a=this.controller.getState();return a&&"stop"!==a&&"error"!==a},resetController:function(){delete this.preCurrTimeText;delete this.preTotalTimeText;delete this.preText;if(this.controller){this.controller.stop()}this.currTime.setText(this.emptyTimeText);this.totalTime.setText("");this.volBar.setValue(0);this.volBar.disable();this.seekBar.setValue(0);this.seekBar.disable();this.subtitleContainer.body.update("")},resetStatus:function(){this.resetController();this.setState("stop");this.clearStatusBusy()},updateSize:function(){var f=this.getWidth();if(this.seekBar){this.seekBar.setWidth(f-this.bbarWidth-this.zoomSelect.getWidth());this.onSeekBarChange()}if(this.zoomSelected){this.zoomSelected=false;return}try{var g=this.controller.getState();if("pause"!==g&&"play"!==g){return}}catch(h){return}if(this.maximized){return}if(this.getWidth()==this.minWidth&&this.getHeight()==this.minHeight){return}var c=this.controller.getResolution();if(c.width<=0||c.height<=0){return}var b=(this.getWidth()-this.xPadding)/c.width;var a=(this.getHeight()-this.yPadding)/c.height;if(b!=a){this.zoomSelect.clearValue();return}var d=false;Ext.each(this.zoomArray,function(e){d|=(b==e[0])});if(!d){this.zoomSelect.clearValue()}},setState:function(b){var a=this.lastState;if(b===a){return}this.lastState=b;if("stop"===a){this.controller.setVisible(true);this.toFront()}if(this.controller&&this.controller.getPlayerName()=="Flash"){this.zoomSelect.disable()}else{this.zoomSelect.enable()}if(SYNO.SDS.Session.standalone){this.zoomSelect.disable()}this.clearStatusBusy();switch(b){case"buffer":this.setStatusOK({text:"Buffering",iconCls:"x-status-busy",clear:false});this.btnPlay.setIconClass("pause");break;case"play":this.loadSubtitles();this.btnPlay.setIconClass("pause");break;case"pause":this.btnPlay.setIconClass("play");break;case"stop":this.resetStatus();if(this.controller){this.controller.setVisible(false)}this.btnPlay.setIconClass("play");break;case"error":if(this.controller.isPlayerSupported("VLC")&&!this.controller.isPlayerInstalled("VLC")){if(Ext.isMac){this.setStatusError({text:_T("video_player","error_play")})}else{this.setStatusError({text:_T("video_player","error_play_vlc")})}this.showMsg()}else{this.setStatusError({text:_T("video_player","error_play")})}this.zoomSelect.disable();this.resetController();this.controller.setVisible(false);this.btnPlay.setIconClass("play");break}},updateStatus:function(){var a,e=this.controller.getState(),d=this.controller.getTime()||0,b=this.controller.getDuration()||0,c=this.controller.getVolume()||0;this.setState(e);if("stop"===e||"error"===e||"buffer"===e){return}if(c>=0){this.volBar.enable();if(!this.volBar.thumbs[0].dragging){this.volBar.setValue(c)}}else{this.volBar.disable()}if(b>0){this.seekBar.enable();if(!this.seekBar.thumbs[0].dragging){this.seekBar.setValue(100*d/b)}}else{this.seekBar.disable()}a=this.emptyTimeText;if(d>0){a=SYNO.SDS.VideoPlayer.Util.formatTime(d)}if(this.preCurrTimeText!==a){this.preCurrTimeText=a;this.currTime.setText(a)}a="";if(b>0){a=SYNO.SDS.VideoPlayer.Util.formatTime(b)}if(this.preTotalTimeText!==a){this.preTotalTimeText=a;this.totalTime.setText(a)}var f=this.subParser.getText(d);if(this.preText!==f){this.preText=f;this.subtitleContainer.body.update(f);if(-1!==f.indexOf("<br/>")){this.subtitleContainer.body.addClass("twoline")}else{this.subtitleContainer.body.removeClass("twoline")}}},loadSubtitles:function(){var b,a,c;if(this.subtitleLoaded){return}this.subtitleLoaded=true;a=this.subtitleSelect.getStore();c=this.controller.getSubtitles()||[];for(b=0;b<c.length;++b){a.loadData([[b+2,c[b]]],true)}this.controller.setSubtitle(-1)},selectSubtitle:function(a){this.subtitleSelect.setValue(a);if(a<2){this.controller.setSubtitle(-1)}else{this.controller.setSubtitle(a-2)}if(1===a){this.subtitleContainer.show()}else{this.subtitleContainer.hide()}this.doLayout()},resetSubtitle:function(){var a=this.subtitleSelect.getStore();a.removeAll();a.loadData([[0,_T("video_player","no_subtitle")]]);this.selectSubtitle(0);this.subtitleLoaded=false;this.subParser.clear()},playurl:function(c,b,a){this.resetStatus();this.resetSubtitle();var d=SYNO.SDS.Utils.GetLocalizedString(this.jsConfig.title);if(a){d=d+"-"+a}else{if(c){d=d+"-"+c.substr(1+c.lastIndexOf("/"))}}this.setTitle(Ext.util.Format.htmlEncode(d));if(""===c||!c){this.controller.playUrl("liveView.ts",b)}else{this.controller.playUrl(c,b);this.onRequestSubTitle(c)}this.statusRunner.start()},play:function(c,b){var a=c.substr(1+c.lastIndexOf("/")),d=SYNO.SDS.Utils.GetLocalizedString(this.jsConfig.title);this.resetStatus();this.resetSubtitle();this.setTitle(Ext.util.Format.htmlEncode(d+" - "+a));this.controller.playUrl(a,SYNO.SDS.VideoPlayer.Util.getDownloadLink(b));this.statusRunner.start();this.onRequestSubTitle(c)},onRequestSubTitle:function(a){Ext.Ajax.request({method:"POST",url:this.jsConfig.jsBaseURL+"/subtitle.cgi",params:{path:a},scope:this,callback:function(c,b,d){if(!b||this.isDestroyed){return}this.subParser.parseSrt(d.responseText);this.subtitleSelect.getStore().loadData([[1,_T("video_player","external_subtitle")]],true);this.selectSubtitle(1)}})},showMsg:function(){var b;if(Ext.isMac){return}var f=(this.appInstance.getUserSettings("blNotShowVLCMsg")===true)?true:false;if(SYNO.SDS.VideoPlayer.VLC.prototype.isSupported()&&!f&&!SYNO.SDS.VideoPlayer.VLC.prototype.detectPlugin("VideoLAN.VLCPlugin.2","VideoLAN","VLC")&&!SYNO.SDS.VideoPlayer.VLC.prototype.detectPlugin("VideoLAN.VLCPlugin.2","VLC","VLC")&&!SYNO.SDS.VideoPlayer.isVLCSupported){var e=Ext.id();var a=Ext.id();b=_T("plugin","plugin_installation").replace("{@}",'<a href="http://www.videolan.org/vlc" target="_blank">VLC</a>');b+="<br><a id = '"+a+'\' class="pathlink"">';b+="<br><span>";b+=_T("plugin","plugin_help");b+="</span></a><br>";b+="<input type='checkbox' id='"+e+"' autocomplete='off' class=' x-form-checkbox x-form-field'>";b+="<label class='x-form-cb-label' style='top: -2px;'>"+_T("plugin","plugin_not_remind")+"</label>";var g=SYNO.SDS.SystemTray.notifyMsg("SYNO.SDS.VideoPlayer.Application",_T("video_player","title"),b,0);var i=Ext.get(a);var h=function(){SYNO.SDS.AppLaunch("SYNO.SDS.HelpBrowser.Application",{topic:"SYNO.SDS.App.FileStation3.Instance:FileBrowser/preview.html"},false)};i.on("click",h,this);var c=Ext.get(e);var d=function(){this.appInstance.setUserSettings("blNotShowVLCMsg",c.dom.checked)};c.on("click",d,this);g.mon(g,"destory",function(){i.un("click",h,this);c.un("click",d,this)},this)}},setStatusError:function(a){if(a&&a.text){this.getMsgBox().alert(this.title,a.text)}}});