/*var synoFileGroupPieData = [
    { data : [[ 0,5 ]], label : 'Comedy' },
    { data : [[ 0,2 ]], label : 'Action' },
    { data : [[ 0,3 ]], label : 'Romance' }
];*/

/*var synoFileGroupTableData = [
	[ 'doc', 'public', 500 ],
	[ 'doc', 'web', 1500 ],
	[ 'music', 'public', 2500 ],
	[ 'music', 'web', 3500 ]
];*/

var FileGroupSubNameColor = {
	reportUI_file_type_document:'#066EC3',
	reportUI_file_type_zip:		'#14B9EB',
	reportUI_file_type_video:	'#DC440F',
	reportUI_file_type_audio:	'#FF9128',
	reportUI_file_type_image:	'#F5C82C',
	reportUI_file_type_web:		'#A5C010',
	reportUI_file_type_iso:		'#96B200',
	reportUI_file_type_exe:		'#029E3C',
	reportUI_file_type_other:	'#A8865F'
};

var FileGroupSubNameType = {
	other:	'Other',
	txt:	'Document',
	doc:	'Document',
	csv:	'Document',
	html:	'Document',
	htm:	'Document',
	js:		'Document',
	css:	'Document',
	sh:		'Document',
	bat:	'Document',
	conf:	'Document',
	php5:	'Document',
	php:	'Document',
	py:		'Document',
	pl:		'Document',
	awk:	'Document',
	c:		'Document',
	cpp:	'Document',
	h:		'Document',
	ini:	'Document',
	jpg:	'Image', 
	png:	'Image', 
	tif:	'Image', 
	avi:	'Video',
	mpg:	'Video',
	rm:		'Video',
	rmvb:	'Video',
	mp3:	'Music',
	tgz:	'Zip File', 
	z:		'Zip File', 
	gz:		'Zip File', 
	zip:	'Zip File'
};
//var FileGroupColorHash = {};

function addChildTable(name)
{
	var table, divPie, divPieTitle, divPieBody, divGrid;
	var title = 'synoAll' === name ? _T('report','reportUI_title_all_user') : _T('report','reportUI_title_user_is') + name;

	table= Ext.get('file_group_table_all').createChild({
		tag: 'div',
		style: "width:930px; height:500px;",
		html: ''
	});

	divPie = table.createChild({
		tag: 'div',
		style: 'width: 230px; float: left;',
		html: ''
	});

	divPieTitle = divPie.createChild({
		tag: 'div',
		style: 'font-size: 15px; color: #313131; padding-top: 25px; font-weight: bold;',
		html: Ext.util.Format.htmlEncode(title)
	});

	divPieBody = divPie.createChild({
		tag: 'div',
		style: 'width: 230px; height: 230px;',
		html: ''
	});

	divGrid = table.createChild({
		tag: 'div',
		style: 'float: left; padding-top: 25px; padding-left: 30px;',
		html: ''
	});

	return [ divPieBody, divGrid ];

}



function FileGroup()
{
	if(typeof synoFileGroupTableData === 'undefined' || !synoFileGroupTableData['synoAll'] || synoFileGroupTableData['synoAll'].length === 0) {
		NoDataSet('file_group_nodata');
		return;
	}

	var data = synoFileGroupTableData;
	var tmp;
	for ( data in synoFileGroupTableData) {
		tmp = addChildTable(data);
		FileGroupPie(tmp[0], synoFileGroupTableData[data], data);
		FileGroupTable(tmp[1], synoFileGroupTableData[data], data);
	}
}

function FileGroupTransateDateToDocType()
{
	var i=0, type, share, size;

	var fileType = {};
	var fileTypeArray = [];
	
	for(i=0; i<synoFileGroupTableData.length; i++) {
		type  = FileGroupSubNameType[synoFileGroupTableData[i][0].toLowerCase()];
		share = synoFileGroupTableData[i][1];
		size  = synoFileGroupTableData[i][2];
		if( type === undefined) {
			type = 'Other';
		}
		if( fileType[type] === undefined) {
			fileType[type] = {};
		}	

		if(fileType[type][share] === undefined) {
			fileType[type][share] = size;
		} else {
			fileType[type][share] += size;
		}
	}

	for(type in fileType) {
		for(share in fileType[type]) {
			fileTypeArray.push( [ type, share, fileType[type][share] ] );
		}
	}

	return fileTypeArray;
}


function FileGroupTranslateData(tableData, pieData, myColor, user)
{
	var i, key, total=0;
	var HashTmp = {};

	for(i=0; i<tableData.length; i++) {
		if( HashTmp[tableData[i][0]] === undefined) {
			HashTmp[tableData[i][0]] = tableData[i][2];
			total++;
		} else {
			HashTmp[tableData[i][0]] += tableData[i][2];
		}
	}

	i=0;
	/*if(FileGroupColorHash[user] === undefined) {
		FileGroupColorHash[user] = {};
	}*/
	for(key in HashTmp) {
		//pickColor(FileGroupColorHash[user], key, i, total);
		pieData.push( { data: [[ 0, HashTmp[key] ]], label : key } );
		//myColor.push(FileGroupColorHash[user][key]);
		myColor.push(FileGroupSubNameColor[key]);
		i++;
	}
}

function FileGroupPie(container, tableData, user)
{
  var pieData = [];

  var graph, myColor = [], key;

  FileGroupTranslateData(tableData, pieData, myColor, user);
  

  graph = Flotr.draw(container.dom, pieData, {
  /*graph = Flotr.draw(container, [
    { data : d1, label : 'Comedy' },
    { data : d2, label : 'Action' },
    { data : d3, label : 'Romance'},
    { data : d4, label : 'Drama' }
  ], {*/
    HtmlText : false,
    grid : {
	  outlineWidth: 0,
	  labelMargin: 0,
      verticalLines : false,
      horizontalLines : false
    },
    xaxis : { showLabels : false },
    yaxis : { showLabels : false },
    pie : {
      sizeRatio: 0.95,
      show : true, 
	  fill: true,
	  startAngle: 0.5,
	  explode: 0,
	  labelFormatter: function() {return '';}
    },
	colors: myColor,
	mouse: { 
		track : true,
		lineColor : '#FFFFFF',
		trackFormatter: function(x) {
			return _T('report', x.series.label);
		}
	},
	shadowSize: 0,
	legend : { show : false }
  });
}



function FileGroupTable(container, tableData, name)
{
	Ext.QuickTips.init();

    // NOTE: This is an example showing simple state management. During development,
    // it is generally best to disable state management as dynamically-generated ids
    // can change across page loads, leading to unpredictable results.  The developer
    // should ensure that stable state ids are set for stateful components in real apps.
    Ext.state.Manager.setProvider(new Ext.state.CookieProvider());

    var store = new Ext.data.ArrayStore({
        fields: [
           {name: 'Type'},
           {name: 'Share'},
           {name: 'Size'}
        ]
    });

    // manually load local data
    store.loadData(tableData);
	
	// create the Grid
    var grid = new Ext.grid.GridPanel({
        border: false,
        store: store,
		renderTo: container,
        width: 670,
		enableColumnResize: false,
		enableHdMenu: false,
		enableColumnHide: false,
		enableColumnMove: false,
		viewConfig: GridViewConfig,
        columns: [
            {
                id       : 'Type',
				header   : styleHeaderRenderer(_T('report', 'reportUI_title_file_type')),
                width    : 230,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_file_type'),
				renderer : styleRendererDecorator(function(val) {
								return "<table><tr><td width=12 height=10 bgcolor='" + FileGroupSubNameColor[val] +
									"'>&nbsp;</td><td>&nbsp;" + _T('report', val) + "</td></tr></table>";
							}),
                dataIndex: 'Type',
				align: 'left'
            },
            {
                id       : 'Share',
                header   : _T('report', 'reportUI_title_share'),
                width    : 280,
                sortable : true,
				tooltip  : _T('report', 'reportUI_title_share'),
                dataIndex: 'Share'
            },
            {
				header   : _T('common', 'size'),
                width    : 120,
                sortable : true,
				tooltip  : _T('common', 'size'),
                renderer : SizeUnit,
                dataIndex: 'Size'
            }
        ],
        plugins: [ new GridPanelPlugin(14) ],
        // config options for stateful behavior
        stripeRows: true
    });



    // render the grid to the specified div in the page
	//grid.renderTo(container);
	//grid.render('file_group_table_' + name);
    //grid.render('file_group_table');
	//container.appendChild(grid.getEl());
}
