#!/bin/sh
# Copyright (c) 2000-2012 Synology Inc. All rights reserved.

source /etc.defaults/rc.subr

SYNOINFO="/etc/synoinfo.conf"
PIDFILE="/var/run/ntpd.pid"
NTPD_NAME="ntpd"
NTPD_BIN="/usr/sbin/${NTPD_NAME}"
NTPCONF="/etc/ntp.conf"
SYNO_DATE_TOOL="/usr/syno/sbin/synodate"
SYNO_NTP_SERV_CONF_FILE="/usr/syno/etc/services.d/syno_ntp.sc"
RUNNING=0
RUNNTPD=0
PID=""
eval $(/bin/grep "^run_ntp_client=" ${SYNOINFO})
eval $(/bin/grep "^run_ntp_server=" ${SYNOINFO})

CheckPID () {
	RUNNING=0
	# check for podfile
	if [ -f $PIDFILE ]; then
		PID=`cat $PIDFILE`
		if [ "x$PID" != "x" ] && kill -0 $PID 2>/dev/null ; then
			RUNNING=1
		else
			RUNNING=0
		fi
	else
		RUNNING=0
	fi
}

CheckNTPServiceConf () {
	if [ ! -f $SYNO_NTP_SERV_CONF_FILE -a -x $SYNO_DATE_TOOL ]; then
		$SYNO_DATE_TOOL --genNTPServiceConf
		echo "NTP service conf file is created: $SYNO_NTP_SERV_CONF_FILE"
	fi
}

if [ "$run_ntp_client" = "yes" -o "$run_ntp_server" = "yes" ]; then
	RUNNTPD=1
fi

case "$1" in
'start')
	CheckNTPServiceConf
	if [ $RUNNTPD -ne 1 ]; then
		exit 0
	fi
	CheckPID
	if [ $RUNNING -eq 1 ]; then
		echo "ntp daemon already running. ntp start aborted"
		exit 0
	fi
	if [ -f $NTPCONF -a -x $NTPD_BIN ]; then
		$NTPD_BIN -p $PIDFILE -g
		echo "$NTPD_BIN is started"
	fi
	;;
'stop')
	CheckPID
	if [ $RUNNING -eq 1 ]; then
		kill $PID
		echo "$NTPD_BIN is stopped"
	fi
	rm -f ${PIDFILE}
	;;
'restart')
	CheckNTPServiceConf
	CheckPID
	if [ $RUNNING -eq 1 ]; then
		kill $PID
		echo "$NTPD_BIN is stopped"
		sleep 2
	fi

	if [ -f $NTPCONF -a -x $NTPD_BIN -a $RUNNTPD -eq 1 ]; then
		$NTPD_BIN -p $PIDFILE -g
		echo "$NTPD_BIN is started"
	fi
	;;
'status')
	lsb_status "${NTPD_NAME}" "${PIDFILE}"
	return $?
	;;
*)
	echo "Usage: $0 { start | stop | restart | status }"
	;;
esac
