#!/bin/sh

SZF_ROUTER_MONITOR_LOCK="/tmp/synoroutermonitor.lock"
SZF_ROUTER_CONF="/etc/portforward/router.conf"
SZF_RULE_CONF="/etc/portforward/rule.conf"
SYNOROUTERTOOL="/usr/syno/sbin/synoroutertool"
MAX_RETRY=15

pre_up ()
{
        # avoid exec many times when encounter series net interface chain
		GATEWAY_INTERFACE=`ip route | grep default | cut -d ' ' -f 5`
		if [ ! "$IFNAME" == "$GATEWAY_INTERFACE" ]; then
				return
		fi
		ROUTER_TYPE=`/bin/get_key_value $SZF_ROUTER_CONF router_type`
		if [ ! "$ORIGIN_ADDRESS" == "$NEW_ADDRESS" ]; then #ip change
			if [ "$ROUTER_TYPE" == "upnp" ]; then
				SUPPORT_UPNP=`/bin/get_key_value $SZF_ROUTER_CONF support_router_upnp`
				if [ "$SUPPORT_UPNP" == "yes" ]; then
						$SYNOROUTERTOOL --apply_clean_ruleconf $ORIGIN_ADDRESS
				fi
			elif [ "$ROUTER_TYPE" == "natpmp" ]; then
				# make sure the following code not blocking ip change
				# For --pre of ip change event, 'change ip' needs to wait all hookscripts to be done.
				$SYNOROUTERTOOL --apply_clean_ruleconf
			fi
		fi

}

post_up ()
{
        # avoid exec many times when encounter series net interface chain
		GATEWAY_INTERFACE=`ip route | grep default | cut -d ' ' -f 5`
		if [ ! "$IFNAME" == "$GATEWAY_INTERFACE" ]; then
				return
		fi
		ROUTER_TYPE=`/bin/get_key_value $SZF_ROUTER_CONF router_type`
		if [ ! "$ORIGIN_ADDRESS" == "$NEW_ADDRESS" ]; then #ip change
			if [ "$ROUTER_TYPE" == "upnp" ]; then
				SUPPORT_UPNP=`/bin/get_key_value $SZF_ROUTER_CONF support_router_upnp`
				if [ "$SUPPORT_UPNP" == "yes" ]; then
					$SYNOROUTERTOOL --apply_set_ruleconf
					synoservice --restart upnpd
				fi
			elif [ "$ROUTER_TYPE" == "natpmp" ]; then
				$SYNOROUTERTOOL --apply_set_ruleconf
				synoservice --restart natpmpd
			fi
		fi
}

case $1 in
	--sdk-mod-ver)
        	#Print SDK support version
	        echo "1.0"
	;;
	--name)
        	#Print package name
	        echo "SynorouterClient"
	;;
	--pkg-ver)
        	#Print package version
	        echo "1.0"
	;;
	--vendor)
        	#Print package vendor
	        echo "Synology"
	;;
	--pre)
			pre_up
	;;
	--post)
	        post_up &
	;;
	*)
	        echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
	;;
esac

