#!/bin/sh

PKG_NAME="iscsitrg"
PKG_VERSION="1.0"
PKG_VENDOR="Synology Inc."
PKG_MODVER="1.0"

LOGGER="/usr/bin/logger"

case $1 in
	--sdk-mod-ver)
		#Print SDK support version
		echo $PKG_MODVER;
		;;
	--name)
		#Print package name
		echo $PKG_NAME;
		;;
	--pkg-ver)
		#Print package version
		echo $PKG_VERSION;
		;;
	--vendor)
		#Print package vendor
		echo $PKG_VENDOR;
		;;
	--pre)
		;;
	--post)
		# do nothing when mtu change on booting-up step
		if /usr/syno/bin/synobootseq --is-booting-up > /dev/null 2>&1 ; then
			exit
		fi
		# do nothing when mtu change shutdown step
		if /usr/syno/bin/synobootseq --is-shutdown > /dev/null 2>&1 ; then
			exit
		fi
		/usr/syno/sbin/synoservice --pause-by-reason iscsitrg 'mtu_change'
		/usr/syno/sbin/synoservice --resume-by-reason iscsitrg 'mtu_change'
		;;
	*)
		echo "Usage: $0 --sdk-mod-ver|--name|--pkg-ver|--vendor|--pre|--post"
		;;
esac

