#!/bin/sh

###############################################################
#   This script should be hooked when invoking share_set hook.
#   Usable environment variable:
#       ORIGIN_SHARE_NAME, ORIGIN_SHARE_STATUS, ORIGIN_SHARE_PATH, SHARE_NAME, SHARE_STATUS, SHARE_PATH
###############################################################

BIN=/usr/syno/sbin/synosharesnapshot

#At begining, acquire package settings
case $1 in
    --sdk-mod-ver)
	    echo "2.0" ;;
    --name)
	    echo "ShareSnapshot" ;;
    --pkg-ver)
	    echo "1.0" ;;
    --vendor)
	    echo "Synology Inc." ;;
    --pre)
	    true ;;
    --post)
		if [ "${ORIGIN_SHARE_PATH}" != "${SHARE_PATH}" ]; then
			if [ -f "${BIN}" ]; then
				${BIN} snap_syslock rename_share "${ORIGIN_SHARE_NAME}" "${SHARE_NAME}"
			fi
		fi
		if [ "" = "${ORIGIN_SHARE_NAME}" ] && [ 0 -eq "${RESULT}" ]; then
			if [ -f "${BIN}" ]; then
				${BIN} shareconf set "${SHARE_NAME}" "local_time_format=true"
			fi
		fi

		;;
    *)
	    echo "Usage: $0 --sdk_mod_ver|--name|--pkg_ver|--vendor|--pre|--post" ;;
esac


