#!/usr/bin/python
import os
import sys
import subprocess
import json
import ConfigParser
import StringIO

PACKAGE_PATH = '/var/packages'
RESOURCE_PATH = 'conf/resource'
SYNOPKG = '/usr/syno/bin/synopkg'
INFO_PATH = 'INFO'
DUMMY_SECTION = 'dummy section'


def is_package_enabled(package):
    with open(os.devnull, 'w') as FNULL:
        try:
            result = subprocess.check_output([SYNOPKG, 'status', package],
                                             stderr=FNULL)
            return 'package is started' in result
        except subprocess.CalledProcessError:
            return False


def is_package_using_share(package, target_share):
    resource_file = '%s/%s/%s' % (PACKAGE_PATH, package, RESOURCE_PATH)
    try:
        with open(resource_file) as resource_file_obj:
            resources = json.load(resource_file_obj)
            for share in resources['data-share']['shares']:
                if share['name'] == target_share:
                    return True
    except (IOError, KeyError):
        # resource file does not exist OR does not require data-share
        return False
    return False


def append_section_and_get_cp(file_path):
    try:
        with open(file_path) as file:
            config = StringIO.StringIO()
            config.write('[%s]\n' % DUMMY_SECTION)
            config.write(file.read())
            config.seek(0, os.SEEK_SET)

            cp = ConfigParser.ConfigParser()
            cp.readfp(config)
    except (IOError, ConfigParser.ParsingError):
        return False
    return cp


def get_package_display_name(package):
    info_file = '%s/%s/%s' % (PACKAGE_PATH, package, INFO_PATH)
    info_cp = append_section_and_get_cp(info_file)
    if info_cp:
        try:
            return info_cp.get(DUMMY_SECTION, 'displayname').strip('"')
        except ConfigParser.NoOptionError:
            return package
    return package


if __name__ == "__main__":
    occupied_packages = []
    target_share = sys.argv[1]

    for package in os.walk(PACKAGE_PATH).next()[1]:  # DIRNAMES
        if not is_package_enabled(package):
            continue
        if is_package_using_share(package, target_share):
            occupied_packages.append(get_package_display_name(package))

    if len(occupied_packages) < 1:
        exit(0)
    else:
        print(', '.join(occupied_packages))
        exit(1)
