#!/bin/sh

SYNORGD="/usr/syno/sbin/synoagentregisterd"
SYNORGD_PIDFILE="/run/synoagentregisterd.pid"

usage() {
	cat <<EOF
Usage: $(basename "$0") [start|stop|restart]
EOF
}

start() {
	echo "Starting synoagentregisterd...";
	if ! "${SYNORGD}"; then
		echo "Start synoagentregisterd failed.";
	fi
}

stop() {
	echo "Stoping synoagentregisterd...";
	if [ -f "${SYNORGD_PIDFILE}" ]; then
		kill "$(cat ${SYNORGD_PIDFILE})";
	fi
}

case "$1" in
	start)   start ;;
	stop)    stop ;;
	restart) stop && start ;;
	*)       usage >&2 ; exit 1 ;;
esac

